<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=0: */
/* mi: charset=Shift_JIS */

/* ImageCache2 - CXg[Ă`FbJ */

// {{{ p2{ݒǂݍ݁F

require_once 'conf/conf.inc.php';

$_login->authorize();

if ($_conf['expack.ic2.enabled'] == 0) {
    exit('<html><body><p>ImageCache2͖łB<br>conf/conf_admin_ex.inc.php ̐ݒςĂB</p></body></html>');
}

// }}}
// {{{ Cuǂݍ݁

$ok = TRUE;

// Cuǂݍ
function libNotFound() { die('<p>KvȃCu܂B</p>'); }
(require_once 'PEAR.php') or libNotFound();
(require_once 'DB.php') or libNotFound();
(require_once 'DB/DataObject.php') or libNotFound();
(require_once 'HTML/QuickForm.php') or libNotFound();
(require_once 'HTML/QuickForm/Renderer/ObjectFlexy.php') or libNotFound();
(require_once 'HTML/Template/Flexy.php') or libNotFound();
(require_once 'HTML/Template/Flexy/Element.php') or libNotFound();
(require_once 'Validate.php') or libNotFound();
(require_once P2EX_LIBRARY_DIR . '/ic2/findexec.inc.php') or libNotFound();
(require_once P2EX_LIBRARY_DIR . '/ic2/db_images.class.php') or libNotFound();
(require_once P2EX_LIBRARY_DIR . '/ic2/thumbnail.class.php') or libNotFound();
(require_once P2EX_LIBRARY_DIR . '/ic2/loadconfig.inc.php') or libNotFound();

// ݒt@Cǂݍ
$ini = ic2_loadconfig();

// DB_DataObject̐ݒ
$options = &PEAR::getStaticProperty('DB_DataObject','options');
$options = array('database' => $ini['General']['dsn'], 'quote_identifiers' => TRUE);

// ݒ֘ÃG[͂̃NX̃RXgN^Ń`FbN
$thumbnailer = &new ThumbNailer;
$icdb = &new IC2DB_images;
$db = &$icdb->getDatabaseConnection();

// }}}
// {{{ SQL

// AԂŎL[ƂȂ̌^Ȃ
preg_match('/^(\w+)(?:\((\w+)\))?:/', $ini['General']['dsn'], $m);
switch ($m[1]) { // phptype
case 'mysql':
case 'mysqli':
    $serial = 'INTEGER PRIMARY KEY AUTO_INCREMENT';
    $table_extra_defs = ' TYPE=MyISAM';
    $version = &$db->getRow("SHOW VARIABLES LIKE 'version'", array(), DB_FETCHMODE_ORDERED);
    if (!DB::isError($version) && version_compare($version[1], '4.1.0') != -1) {
        $charset = &$db->getRow("SHOW VARIABLES LIKE 'character_set_database'", array(), DB_FETCHMODE_ORDERED);
        if (!DB::isError($charset) && $charset[1] == 'latin1') {
            $errmsg = "<p><b>Warning:</b> f[^x[X̕Zbg latin1 ɐݒ肳Ă܂B</p>";
            $errmsg .= "<p>mysqld  default-character-set  binary, ujis, utf8 łȂƓ{̂̕ ";
            $errmsg .= "<a href=\"http://www.mysql.gr.jp/frame/modules/bwiki/?FAQ#content_1_40\">{MySQL[UFAQ</a>";
            $errmsg .= " Ql my.cnf ̐ݒςĂB</p>";
            die($errmsg);
        }
        $db->query('SET NAMES utf8');
        if (version_compare($version[1], '4.1.2') != -1) {
            $table_extra_defs = ' ENGINE=MyISAM DEFAULT CHARACTER SET utf8';
            //$table_extra_defs = ' ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci';
            //$table_extra_defs = ' ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin';
        }
    }
    break;
case 'pgsql':
    $serial = 'SERIAL PRIMARY KEY';
    $table_extra_defs = '';
    break;
case 'sqlite':
    $serial = 'INTEGER PRIMARY KEY';
    $table_extra_defs = '';
    break;
default:
    die('MySQL, PostgreSQL, SQLiteȊÕf[^x[Xɂ͑ΉĂ܂B');
}

// e[u͐ݒɂĂDB̗\ꂪg邩Ȃ̂DB_xxx::quoteIdentifier()
// NH[g邪AJɂ͗\gȂ̂quoteIdentifier()͏ȗB

$createTableSQL = array();
$createIndexSQL = array();
$format_createIndex = 'CREATE INDEX %s ON %s (%s);';

// Ce[u
$imgcache_table_quoted = $db->quoteIdentifier($ini['General']['table']);
$createTableSQL['imgcache'] = <<<EOQ
CREATE TABLE $imgcache_table_quoted (
    id     $serial,
    uri    VARCHAR (255),
    host   VARCHAR (255),
    name   VARCHAR (255),
    size   INTEGER NOT NULL,
    md5    CHAR (32) NOT NULL,
    width  SMALLINT NOT NULL,
    height SMALLINT NOT NULL,
    mime   VARCHAR (50) NOT NULL,
    time   INTEGER NOT NULL,
    rank   SMALLINT NOT NULL DEFAULT 0,
    memo   TEXT
)$table_extra_defs;
EOQ;

// Ce[ũCfbNXiURLj
$createIndexSQL['imgcache_uri'] = sprintf($format_createIndex,
    $db->quoteIdentifier('idx_'.$ini['General']['table'].'_uri'),
    $imgcache_table_quoted,
    'uri'
);

// Ce[ũCfbNXiLbVԂUNIX^CX^vj
$createIndexSQL['imgcache_time'] = sprintf($format_createIndex,
    $db->quoteIdentifier('idx_'.$ini['General']['table'].'_time'),
    $imgcache_table_quoted,
    'time'
);

// Ce[ũCfbNXit@CTCYEMD5`FbNTEMIME^Cvj
$createIndexSQL['imgcache_unique'] = sprintf($format_createIndex,
    $db->quoteIdentifier('idx_'.$ini['General']['table'].'_unique'),
    $imgcache_table_quoted,
    'size, md5, mime'
);

// ɉ摜LbVꗗŎgf[^LbVpe[u
$datacache_table_quoted = $db->quoteIdentifier($ini['Cache']['table']);
$createTableSQL['datacache'] = <<<EOQ
CREATE TABLE $datacache_table_quoted (
    id         CHAR(32) NOT NULL,
    cachegroup VARCHAR (127) NOT NULL,
    cachedata  TEXT,
    userdata   VARCHAR (255),
    expires    INTEGER NOT NULL,
    changed    INTEGER NOT NULL DEFAULT 0,
    PRIMARY KEY (id, cachegroup)
)$table_extra_defs;
EOQ;

// f[^LbVpe[ũCfbNXiLj
$createIndexSQL['datacache_expires'] = sprintf($format_createIndex,
    $db->quoteIdentifier('idx_'.$ini['Cache']['table'].'_expires'),
    $datacache_table_quoted,
    'expires'
);

// G[Ope[u
$ic2error_table_quoted = $db->quoteIdentifier($ini['General']['error_table']);
$createTableSQL['ic2_error'] = <<<EOQ
CREATE TABLE $ic2error_table_quoted (
    uri     VARCHAR (255),
    errcode VARCHAR(64) NOT NULL,
    errmsg  TEXT,
    occured INTEGER NOT NULL
)$table_extra_defs;
EOQ;

// G[ÕCfbNXiURLj
$createIndexSQL['errorlog_uri'] = sprintf($format_createIndex,
    $db->quoteIdentifier('idx_'.$ini['General']['error_table'].'_uri'),
    $ic2error_table_quoted,
    'uri'
);

// ubNXg
$blacklist_table_quoted = $db->quoteIdentifier($ini['General']['blacklist_table']);
$createTableSQL['blacklist'] = <<<EOQ
CREATE TABLE $blacklist_table_quoted (
    id     $serial,
    uri    VARCHAR (255),
    size   INTEGER NOT NULL,
    md5    CHAR (32) NOT NULL,
    type   SMALLINT NOT NULL DEFAULT 0
)$table_extra_defs;
EOQ;

// ubNXg̃CfbNXiURLj
$createIndexSQL['blacklist_uri'] = sprintf($format_createIndex,
    $db->quoteIdentifier('idx_'.$ini['General']['blacklist_table'].'_uri'),
    $blacklist_table_quoted,
    'uri'
);

// ubNXg̃CfbNXit@CTCYEMD5`FbNTEMIME^Cvj
$createIndexSQL['blacklist_unique'] = sprintf($format_createIndex,
    $db->quoteIdentifier('idx_'.$ini['General']['blacklist_table'].'_unique'),
    $blacklist_table_quoted,
    'size, md5'
);

// }}}
// {{{ ֐

function ic2_createTable($sql)
{
    global $db, $ok;

    echo "<pre>{$sql}</pre>\n";
    echo "<p><strong>";

    $result = $db->query($sql);

    if (DB::isError($result)) {
        $why = $result->getMessage();
        if (!stristr($why, 'already exists')) {
            $ok = FALSE;
        }
        echo $why;
    } else {
        echo "OK!";
    }

    echo "</strong></p>\n";
}

function ic2_createIndex($sql)
{
    global $db, $ok;

    echo "<pre>{$sql}</pre>\n";
    echo "<p><strong>";

    $result = $db->query($sql);

    if (DB::isError($result)) {
        $why = $result->getMessage();
        echo $why;
        if (!stristr($why, 'already exists') && !stristr($why, 'unknown error')) {
            $ok = FALSE;
        } else {
            echo " (ɃCfbNX쐬ς݂ȂOK)";
        }
    } else {
        echo "OK!";
    }

    echo "</strong></p>\n";
}

// }}}
// {{{ mF\

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
 "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">
    <title>ImageCache2::Install</title>
</head>
<body style="background:white;font-size:small">

<h1>ImageCache2::install</h1>

<hr>

<h2>C[WhCo</h2>

<p><?php echo $ini['General']['driver']; ?> - OK!</p>

<hr>

<h2>e[u쐬</h2>

<?php
foreach ($createTableSQL as $sql) {
    ic2_createTable($sql);
}
?>

<hr>

<h2>CfbNX쐬</h2>

<?php
foreach ($createIndexSQL as $sql) {
    ic2_createIndex($sql);
}
?>

<hr>

<h2>fBNg쐬</h2>

<?php
$dirs = array(
    $ini['General']['compiledir'],
    $ini['Source']['name'],
    $ini['Thumb1']['name'],
    $ini['Thumb2']['name'],
    $ini['Thumb3']['name'],
);

foreach ($dirs as $dir) {
    $path = $ini['General']['cachedir'] . '/' . $dir;
    if (is_dir($path)) {
        echo "<p>fBNg <em>{$path}</em> ͍쐬";
        if (is_writable($path)) {
            echo "i݌j</p>\n";
        } else {
            echo "i<strong>݌Ȃ</strong>j</p>\n";
            $ok = FALSE;
        }
    } else {
        if (@mkdir($path)) {
            echo "<p>fBNg <em>{$path}</em> 쐬</p>\n";
        } else {
            echo "<p>fBNg <em>{$path}</em> <strong>쐬s</strong></p>\n";
            $ok = FALSE;
        }
    }
}
?>

<hr>

<h2><?php echo ($ok ? "OK" : "߂"); ?></h2>

<?php if (!$ok) echo '<!-- '; ?>
<p>CXg[ɐ炱̃t@C(ic2_install.php)͍폜ĂB</p>
<?php if (!$ok) echo ' -->'; ?>

</body>
</html>
<?php
// }}}
?>
