<?php

// {{{ MatomeCache

/**
 * ܂Ƃߓǂ݃LbVf[^NX
 */
class MatomeCache
{
    // {{{ properties

    /**
     * ܂Ƃߓǂ݂̓e (HTML)
     *
     * @var string
     */
    private $_content;

    /**
     * ܂Ƃߓǂ݂̃^f[^
     *
     * @var array
     */
    private $_metaData;

    /**
     * ܂Ƃߓǂ݂kۑt@C
     *
     * @var string
     */
    private $_tempFile;

    /**
     * ܂Ƃߓǂ݂kۑXg[
     *
     * @var stream
     */
    private $_stream;

    /**
     * ܂Ƃߓǂ݃LbVc
     *
     * @var int
     */
    private $_maxNumEntries;

    /**
     * ܂Ƃߓǂ݃LbVLǂ
     *
     * @var bool
     */
    private $_enabled;

    // }}}
    // {{{ __construct()

    /**
     * RXgN^
     *
     * vpeBAꎞt@C쐬B
     *
     * @param string $title
     * @param int $maxNumEntries
     */
    public function __construct($title, $maxNumEntries = -1)
    {
        global $_conf;

        if ($maxNumEntries == 0) {
            $this->_enabled = false;
            return;
        }

        // vpeB̏
        $this->_content = '';
        $this->_metaData = array(
            'time' => time(),
            'title' => $title,
            'threads' => array(),
            'size' => 0,
        );
        $this->_tempFile = null;
        $this->_stream = null;
        $this->_maxNumEntries = $maxNumEntries;
        $this->_enabled = true;

        // ꎞt@C쐬
        /*
         * PHP tmpnam() ֐Ă΂ƁACꃌxł
         *  PHP_FUNCTION(tempnam) -> php_open_temporary_fd() ->
         *  php_do_open_temporary_file() -> virtual_file_ex()
         * Ƃňꎞt@CpfBNg̉sB
         * ̍ہAvirtual_file_ex()  use_realpath 
         * CWD_REALPATH w肳Ă̂ tempnam() ̌ʂ
         * realpath() ɂKvȂB
        */
        $tempFile = tempnam($_conf['tmp_dir'], 'matome_');
        if (!$tempFile) {
            return;
        }

        // ꎞt@CJAXg[tB^t
        $fp = fopen($tempFile, 'wb');
        if ($fp) {
            stream_filter_append($fp, 'zlib.deflate');
            stream_filter_append($fp, 'convert.base64-encode');
            $this->_tempFile = $tempFile;
            $this->_stream = $fp;
        } else {
            unlink($tempfile);
        }
    }

    // }}}
    // {{{ __destruct()

    /**
     * fXgN^
     *
     * eۑAÂLbV폜B
     * Xbh񂪋̏ꍇ͕ۑȂB
     *
     * @param void
     */
    public function __destruct()
    {
        if (!$this->_enabled) {
            return;
        }

        // Xg[
        if ($this->_stream) {
            fclose($this->_stream);
        }

        // XȂ
        if (count($this->_metaData['threads'])) {
            // eۑ
            if ($this->_tempFile) {
                MatomeCacheList::add($this->_tempFile, $this->_metaData, true);
            } else {
                MatomeCacheList::add($this->_content, $this->_metaData, false);
            }
            // ÂLbV폜B
            if ($this->_maxNumEntries > 0) {
                MatomeCacheList::trim($this->_maxNumEntries);
            }
        }

        // ꎞt@C폜
        if ($this->_tempFile) {
            unlink($this->_tempFile);
        }
    }

    // }}}
    // {{{ concat()

    /**
     * eǉ
     *
     * @param string $content
     * @return void
     */
    public function concat($content)
    {
        if ($this->_enabled) {
            if ($this->_stream) {
                fwrite($this->_stream, $content);
            } else {
                $this->_content .= $content;
            }
            $this->_metaData['size'] += strlen($content);
        }
    }

    // }}}
    // {{{ addReadThread()

    /**
     * ܂Ƃߓǂ݂Ɋ܂܂Xbhǉ
     *
     * @param ThreadRead $aThread
     * @return void
     */
    public function addReadThread(ThreadRead $aThread)
    {
        if ($this->_enabled) {
            $this->_metaData['threads'][] = array(
                'title' => $aThread->ttitle_hd,
                'host'=> $aThread->host,
                'bbs'=> $aThread->bbs,
                'key'=> $aThread->key,
                'ls' => sprintf('%d-%dn',
                                $aThread->resrange['start'],
                                $aThread->resrange['to']),
            );
        }
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
