
/* --------------------------------------------- */
/*  H8-3069F Serial communicate function         */
/*                                               */
/*  CPU    : Renesus H8/3069F 25MHz              */
/*  Memory : ROM 512KB, RAM 16KB E-RAM 2MB       */
/*                (c) KAZ.Imamura                */
/* --------------------------------------------- */

#include "common.h"
#include "ui.h"


// -----------------------------------------------
//  Speed setting
// -----------------------------------------------
enum comm_speed {
	COMM_SPEED_UNKNOWN,
	COMM_SPEED_1200BPS,
	COMM_SPEED_2400BPS,
	COMM_SPEED_4800BPS,
	COMM_SPEED_9600BPS,
	COMM_SPEED_14400BPS,
	COMM_SPEED_19200BPS,
};

typedef struct speed_setting {
	unsigned char			index;
	unsigned char			cks_setting;
	unsigned char			brr_setting;
	char					Name[16];
} SPEED_SETTING, *P_SPEED_SETTING;

// -----------------------------------------------
//  Character code setting
// -----------------------------------------------
enum comm_code {
	COMM_CODE_UNKNOWN,
	COMM_CODE_ISO,
	COMM_CODE_EIA,
	COMM_CODE_ASCII,
};

typedef struct code_setting {
	unsigned char			index;
	char					Name[16];
} CODE_SETTING, *P_CODE_SETTING;

// -----------------------------------------------
//  Communication setting
// -----------------------------------------------
enum comm_param {
	COMM_PARAM_UNKNOWN,
	COMM_PARAM_8BIT_NONPARITY_STOP1,
	COMM_PARAM_8BIT_NONPARITY_STOP2,
	COMM_PARAM_8BIT_ODDPARITY_STOP1,
	COMM_PARAM_8BIT_ODDPARITY_STOP2,
	COMM_PARAM_8BIT_EVNPARITY_STOP1,
	COMM_PARAM_8BIT_EVNPARITY_STOP2,
	COMM_PARAM_7BIT_NONPARITY_STOP1,
	COMM_PARAM_7BIT_NONPARITY_STOP2,
	COMM_PARAM_7BIT_ODDPARITY_STOP1,
	COMM_PARAM_7BIT_ODDPARITY_STOP2,
	COMM_PARAM_7BIT_EVNPARITY_STOP1,
	COMM_PARAM_7BIT_EVNPARITY_STOP2,
};
typedef struct param_setting {
	unsigned char			index;
	unsigned char			smr_setting;
	char					Name[16];
} PARAM_SETTING, *P_PARAM_SETTING;


extern void serial_1ms_handler(void);
extern int  serial_initialize(void);
extern void serial_process(void);
extern void ui_serial_progress( void );
extern unsigned char serial_status(REQUEST_TO_CLASS req);

extern void int_ERI0();
extern void int_RXI0();
extern void int_TXI0();
extern void int_TEI0();
extern unsigned char TransferStartRequest( unsigned char* pBuf, unsigned long size );
extern int ui_function_serial(UI_COMMAND uicmd);

