
/* --------------------------------------------- */
/*  H8-3069F Start up routine                    */
/*                (c) KAZ.Imamura                */
/*                                               */
/*  CPU    : Renesus H8/3069F 25MHz              */
/*  Memory : ROM 512KB, RAM 16KB E-RAM 2MB       */
/*  Target : AKI-3069-USB on h8mon               */
/* --------------------------------------------- */

	.h8300h
	.section .text
	.global	_start
	.global	_permit_irq
	.global	_prohibit_irq
	.global	_wait_100us
	.global	_verify_mem
	.global	_verify_mem256K


_start:
	mov.l	#_stack_end,sp
	jmp	_main					; Goto main()
	
_sleep:
	sleep
	rts
	
_permit_irq:
	andc.b #0x7f, ccr
	rts

_prohibit_irq:
	orc.b #0x80, ccr
	rts


_wait_100us:
	orc.b #0x80, ccr				; 2 state
	push.w r2						; 8 state
	mov.w #0x0271, r2				; 4 state  
	dec.w #1, r2					; 2 state
	bne .-2							; 2 state  ----- 4 state (160ns) * 620+5(O) = 100us
	pop.w r2						; 2 state
	andc.b #0x7f, ccr				; 2 state
	rts

_verify_mem:
	push.w e4						; 8 state
	push.w r4						; 8 state
	push.w r5						; 8 state
	mov.l	#_eram_start,er3		;# 83	*movsi_h8300hs/3	[length = 6] (16)
	mov.l	#_eram_end,er2			;# 85	*movsi_h8300hs/3	[length = 6] (12)
	sub.w	r4,r4
	mov.w	@_memchk_ptn:32,r5
.vm1:
	mov.w	@er3,e4					;# 89	*movhi_h8300hs/5	[length = 2]
	cmp.w	r5,e4					;# 90	*cmphi_h8300hs_znvc/2	[length = 4]
	beq	.vm2						;# 91	branch_true	[length = 2]
	mov.w	#1,r4
.vm2:
	adds	#2,er3					;# 99	*addsi_h8300hs/1	[length = 2]
	cmp.l	er2,er3					;# 100	cmpsi/2	[length = 2]
	blo	.vm1						;# 101	branch_true	[length = 2]
	mov.w	r4, @_memchk_rslt
	pop.w r5						; 2 state
	pop.w r4						; 2 state
	pop.w e4						; 2 state
	rts
	
_verify_mem256K:
	push.w e4						; 8 state
	push.w r4						; 8 state
	push.w r5						; 8 state
	mov.l	@_memchk_start,er3		;# 83	*movsi_h8300hs/3	[length = 6] (16)
	mov.l	er3,er2
	add.l	#0x20000,er2			; End address
	sub.w	r4,r4
	mov.w	@_memchk_ptn:32,r5
.vm2k1:
	mov.w	@er3,e4					;# 89	*movhi_h8300hs/5	[length = 2]
	cmp.w	r5,e4					;# 90	*cmphi_h8300hs_znvc/2	[length = 4]
	beq	.vm2k2						;# 91	branch_true	[length = 2]
	mov.w	#1,r4
.vm2k2:
	adds	#2,er3					;# 99	*addsi_h8300hs/1	[length = 2]
	cmp.l	er2,er3					;# 100	cmpsi/2	[length = 2]
	blo	.vm2k1						;# 101	branch_true	[length = 2]
	mov.w	r4, @_memchk_rslt
	pop.w r5						; 2 state
	pop.w r4						; 2 state
	pop.w e4						; 2 state
	rts

	.end
	