﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace Lugens.Components
{
    public partial class SearchTextBox : UserControl
    {
        private Color borderColor = Color.FromArgb(127, 157, 185);

        private Color fillBackColor = Color.White;
        
        [Category("表示")]
        [Description("境界線の色です。")]
        public Color BorderColor { get { return borderColor; } set { borderColor = value; } }

        [Category("表示")]
        [Description("背景色です。")]
        public Color FillBackColor { get { return fillBackColor; } set { fillBackColor = value; } }

        [Category("表示")]
        [Description("ラベルのテキストです。")]
        public string LabelText { get { return this.label.Text; } set { this.label.Text = value; } }

        [Category("表示")]
        [Description("ラベルのフォントです。")]
        public Font LabelFont { get { return this.label.Font; } set { this.label.Font = value; } }

        public AutoCompleteTextBox TextBox { get { return textBox; } }

        public PictureBox Icon { get { return this.icon; } }

        
        public SearchTextBox()
        {
            InitializeComponent();
            this.textBox.ImeComposition += new AutoCompleteTextBox.ImeCompositionEventHandler(textBox_ImeComposition);
        }

        public void SortItems()
        {
            textBox.Items.Sort(textBox);
        }

        protected override void OnPaintBackground(PaintEventArgs e)
        {
            base.OnPaintBackground(e);

            Pen pen = new Pen(this.borderColor);
            SolidBrush brush = new SolidBrush(this.fillBackColor);
            Graphics g = e.Graphics;
            Rectangle r = this.ClientRectangle;
            r.Width--;
            r.Height--;
            //g.DrawRectangle(pen, r);

            g.FillRectangle(brush, 1, 1, r.Width - 1, r.Height - 1);
            g.DrawLine(pen, 3, 0, r.Width - 3, 0);
            g.DrawLine(pen, 3, r.Height, r.Width - 3, r.Height);
            g.DrawLine(pen, 0, 3, 0, r.Height - 3);
            g.DrawLine(pen, r.Width, 3, r.Width, r.Height - 3);
            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
            g.DrawArc(pen, 0, 0, 6, 6, 180, 90);
            g.DrawArc(pen, r.Width - 6, 0, 6, 6, 270, 90);
            g.DrawArc(pen, 0, r.Bottom - 6, 6, 6, 90, 90);
            g.DrawArc(pen, r.Width - 6, r.Bottom - 6, 6, 6, 0, 90);

            brush.Dispose();
            pen.Dispose();

        }

        protected override void OnSizeChanged(EventArgs e)
        {
            base.OnSizeChanged(e);
            this.textBox.Width = this.Width - 25;
            this.Invalidate();
        }

        private void textBox_TextChanged(object sender, EventArgs e)
        {
            this.label.Visible = String.IsNullOrEmpty(this.textBox.Text);
        }

        private void textBox_ImeComposition(int type, string text)
        {
            this.label.Visible =  String.IsNullOrEmpty(this.textBox.Text) && String.IsNullOrEmpty(text);
        }
    }
}
