﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.VisualBasic;

namespace Lugens.Passer.Macro.Text
{
    public class AddCommentMacro : IMacro
    {

        public string Id()
        {
            return "Lugens.Passer.Macro.Text.AddComment";
        }

        public bool Init()
        {
            return true;
        }

        public string Name()
        {
            return "AddComment";
        }

        public string Description()
        {
            return "先頭にコメントを付与します";
        }

        public string Execute(string str, string[] args)
        {
            StringBuilder sb = new StringBuilder();
            string[] lines = str.Split(new string[]{System.Environment.NewLine}, StringSplitOptions.None);
            for(int i = 0; i < lines.Length - 1; i++)
            {
                sb.Append("//").Append(lines[i]).Append(System.Environment.NewLine);
            }
            if(!String.IsNullOrEmpty(lines[lines.Length-1]))
                sb.Append("//").Append(lines[lines.Length-1]);
            return sb.ToString();
        }
    }
}
