﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.VisualBasic;
using Lugens.Components.IME;

namespace Lugens.Passer.Macro.Text
{
    public class PopupYomiganaMacro : IMacro
    {
        private ImeLanguage ime = new ImeLanguage();

        event MacroEventHandler macroCompletedEvent;

        event MacroEventHandler IMacro.OnMacroCompleted
        {
            add { macroCompletedEvent += value; }
            remove { macroCompletedEvent -= value; }
        }

        public string Id()
        {
            return "Lugens.Passer.Macro.Text.PopupYomigana";
        }

        public MacroType Type()
        {
            return MacroType.InOutPopup;
        }

        public bool Init()
        {
            return true;
        }

        public string Name()
        {
            return "PopupYomigana";
        }

        public string Summary()
        {
            return "漢字の読みをポップアップ表示します";
        }

        public string Description()
        {
            return new StringBuilder()
                .Append("引数：なし").Append(Environment.NewLine)
                .Append(Environment.NewLine)
                .Append("クリップボード、または選択されたテキストの").Append(Environment.NewLine)
                .Append("漢字の読みをポップアップで表示します").ToString();
        }

        public bool Test()
        {
            return true;
        }

        public void ExecuteAsync(string str, string[] args)
        {
            string result = "";
            if (!String.IsNullOrEmpty(str))
            {
                if (str.Length > 100)
                    result = "100文字以内で選択してください";
                else
                    result = ime.GetYomi(str);

            }
            
            if (macroCompletedEvent != null)
                macroCompletedEvent(result);
        }

    }
}
