using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace Lugens.Passer
{
    public partial class EditCommandForm : Form
    {
        public TextBox TextBox_select
        {
            get { return this.textBox_select; }
            set { this.textBox_select = value; }
        }

        public TextBox TextBox_command
        {
            get { return this.textBox_command; }
        }

        public EditCommandForm()
        {
            InitializeComponent();
        }

        private void button_view_Click(object sender, EventArgs e)
        {

            if (DialogResult.OK == openFileDialog1.ShowDialog(this))
            {
                int fileIndex = openFileDialog1.FileName.LastIndexOf('\\');
                if (fileIndex == -1)
                {
                    fileIndex = 0;
                }
                string command = openFileDialog1.FileName.Substring(fileIndex + 1);
                if (command.LastIndexOf('.') != -1)
                {
                    command = command.Substring(0, command.LastIndexOf('.'));
                }
                this.textBox_command.Text = command;
                this.textBox_target.Text = openFileDialog1.FileName;
                this.textBox_path.Text = openFileDialog1.FileName.Substring(0, fileIndex);

            }
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(this.textBox_target.Text))
            {
                MessageBox.Show("t@CIĂ܂");
                return;
            }

            if (!File.Exists(this.textBox_target.Text))
            {
                MessageBox.Show(this, "t@C݂܂\n" + this.textBox_target.Text, "o^G[", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            int index = Program.SettingForm.CommandListTmp.IndexOf(this.textBox_select.Text);
            Program.SettingForm.CommandListTmp[index] = this.textBox_command.Text;
            Program.SettingForm.CommandDicTmp.Remove(this.textBox_select.Text);
            CommandInfo info = new CommandInfo();
            info.Name = this.textBox_command.Text;
            info.Target = this.textBox_target.Text;
            info.Path = this.textBox_path.Text;
            info.Arguments = this.textBox_arguments.Text;
            info.Comment = this.textBox_comment.Text.Length == 0 ? null : this.textBox_comment.Text;
            Program.AddCommand(Program.SettingForm.CommandDicTmp, null, info);
            Program.SettingForm.ReadCommandList(true);
            Program.SettingForm.RequestCommandListViewSelect(info.Name);

            this.Visible = false;
        }

        private void textBox_command_TextChanged(object sender, EventArgs e)
        {
            if (this.textBox_command.Text.Length == 0)
            {
                this.label_duplicate.Visible = false;
                this.button_ok.Enabled = false;
                return;
            }
            if (Program.DefaultCommand.Equals(this.textBox_command.Text))
            {
                this.label_duplicate.Visible = false;
                this.button_ok.Enabled = true;
                return;
            }
            if (this.textBox_command.Text[0] == '\\' || this.textBox_command.Text[0] == '!' || this.textBox_command.Text[0] == '$' || this.textBox_command.Text[0] == ':' || this.textBox_command.Text[0] == '@')
            {
                this.label_duplicate.Text = "͂ꂽL͎gpł܂";
                this.label_duplicate.Visible = true;
                this.button_ok.Enabled = false;
                return;
            }
            if (this.textBox_command.Text.IndexOf(' ') != -1)
            {
                this.label_duplicate.Text = "Xy[X͎gpł܂";
                this.label_duplicate.Visible = true;
                this.button_ok.Enabled = false;
                return;
            }
            if (Program.SettingForm.CommandDicTmp.ContainsKey(this.textBox_command.Text) && !this.textBox_select.Text.Equals(this.textBox_command.Text))
            {
                this.label_duplicate.Text = "dĂ܂";
                this.label_duplicate.Visible = true;
                this.button_ok.Enabled = false;
            }
            else
            {
                this.label_duplicate.Visible = false;
                this.button_ok.Enabled = true;
            }
        }

        private void EditCommandForm_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible)
            {
                if (Program.SettingForm.CommandDicTmp.ContainsKey(this.textBox_select.Text))
                {
                    CommandInfo info = Program.SettingForm.CommandDicTmp[this.textBox_select.Text];
                    this.textBox_command.Text = info.Name;
                    this.textBox_target.Text = info.Target;
                    this.textBox_path.Text = info.Path;
                    this.textBox_arguments.Text = info.Arguments;
                    this.textBox_comment.Text = info.Comment;
                }
            }
        }

    }
}