/**
 * $Revision: 231 $
 * $Date: 2010-03-12 19:32:51 +0900 (金, 12 3 2010) $
*/

using System;
using System.Drawing;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;
using System.Reflection;
using System.Windows.Forms;
using System.Web;
using System.Xml;

using Lugens.Components;
using System.Text;
using Lugens.Utils;
using Newtonsoft.Json;
using Microsoft.WindowsAPICodePack.Shell;

namespace Lugens.Passer
{
    /// <summary>
    /// Form1 の概要の説明です。
    /// </summary>
    public partial class MainForm : Form
    {
        public enum MainFormStatus
        {
            Hide,
            Active,
            NoActive
        }


        private static IntPtr hWndClipboardNext = IntPtr.Zero;
        
        private bool windowMoveFlag = false;
        
        private Point seenPoint;

        private Point mousePoint;

        private Timer timer1;

        public Timer timer_keyRecoding;

        private Timer timer_suggest;

        private int scrollPos = 0;

        private bool showDropdownSupport = true;

        private MainFormStatus status = MainFormStatus.Hide;
        public MainFormStatus Status
        {
            get { return status; }
            set { status = value; }
        }

        private AutoCompleteTextBox textBox_cmd;
        public AutoCompleteTextBox TextBox_cmd
        {
            get { return textBox_cmd; }
        }

        public DropdownListForm DropdownForm
        {
            get { return searchTextBox.TextBox.DropdownForm; }
        }

        public Timer Timer
        {
            get { return timer1; }
        }

        private ContextMenuStrip contextMenuStrip1;
        
        private ToolStripMenuItem 設定ToolStripMenuItem;
        
        private ToolStripMenuItem バージョン情報ToolStripMenuItem;
        
        private ToolStripMenuItem 終了ToolStripMenuItem;
        
        private ToolStripSeparator toolStripSeparator1;
        
        public NotifyIcon notifyIcon1;
        
        private System.ComponentModel.IContainer components;

        private IntPtr beforeHWnd = IntPtr.Zero;
        public IntPtr BeforeHWnd
        {
            get { return beforeHWnd; }
            set { beforeHWnd = value; }
        }

        private KeyboardHook keyboardHook;
        //private MouseHook mouseHook;
        private ToolStripMenuItem 表示ToolStripMenuItem;
        private SearchTextBox searchTextBox;
    
        public SearchTextBox SearchTextBox { get { return searchTextBox; } }

        /// <summary>
        /// 現在選択中の検索エンジン
        /// </summary>
        public int SelectedEngineIndex;

        /// <summary>
        /// 現在選択中の検索エンジンタイプ
        /// </summary>
        private int SelectedEngineType;

        /// <summary>
        /// ツールチップ表示用
        /// </summary>
        private string dropdownListBoxText = "";

        /// <summary>
        /// 検索エンジンサジェスト用
        /// </summary>
        private bool suggestSupport = false;
        private string suggestString = "";

        /// <summary>
        /// サジェストクエリー判定用
        /// </summary>
        private volatile bool textChanged = false;

        private long latestKeyTime = DateTime.Now.Ticks;
        
        public MainForm()
        {
            //
            // Windows フォーム デザイナ サポートに必要です。
            //
            InitializeComponent();

            //
            // TODO: InitializeComponent 呼び出しの後に、コンストラクタ コードを追加してください。
            //
            this.searchTextBox.TextBox.MaxDropdownCount = 10;
            this.searchTextBox.TextBox.Complement += new Lugens.Components.AutoCompleteTextBox.ComplementEventHandler(this.textBox_cmd_Complement);
            this.searchTextBox.TextBox.ImeComposition += new Lugens.Components.AutoCompleteTextBox.ImeCompositionEventHandler(this.textBox_cmd_ImeComposition);
            this.searchTextBox.TextBox.TextChanged += new System.EventHandler(this.textBox_cmd_TextChanged);
            this.searchTextBox.TextBox.KeyDown += new System.Windows.Forms.KeyEventHandler(this.textBox_cmd_KeyDown);
            this.searchTextBox.TextBox.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.textBox1_KeyPress);

            this.searchTextBox.Icon.Image = Properties.Resources.EngineCommand.ToBitmap();

            //if (Process.GetProcessesByName(Process.GetCurrentProcess().ProcessName).Length > 1)
            //    System.Environment.Exit(0);
            //X = System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width / 2 - this.Size.Width / 2;
            this.searchTextBox.TextBox.DropdownForm.Opacity = this.Opacity;
            this.searchTextBox.TextBox.DropdownForm.DropdownListBox.MouseDoubleClick += new MouseEventHandler(this.DropdownListView_MouseDoubleClick);
            this.notifyIcon1.Icon = Properties.Resources.App;

            
            //キーボードフック
            keyboardHook = new KeyboardHook(this.KeyboardHookHandler);
            keyboardHook.Start();

            //マウスフック
            //mouseHook = new MouseHook(this.MouseHookHandler);
            //mouseHook.Start();

            //グローバルフック
            Point p = new Point();
            ghook.SetHook(this.Handle);

            //クリップボードビューア登録
            hWndClipboardNext = Win32.SetClipboardViewer(this.Handle);

            if (Settings.ContainsKey(Settings.PASSER_FORM_MAIN_X) && Settings.ContainsKey(Settings.PASSER_FORM_MAIN_Y))
                this.seenPoint = new Point(Settings.GetInt(Settings.PASSER_FORM_MAIN_X), Settings.GetInt(Settings.PASSER_FORM_MAIN_Y));
            else
                this.seenPoint = new Point((Screen.PrimaryScreen.Bounds.Width >> 1) - (this.Width >> 1), (Screen.PrimaryScreen.Bounds.Bottom >> 1) - (this.Bottom >> 1));
            this.Location = this.seenPoint;
            this.Opacity = 0;
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                keyboardHook.Stop();
                //mouseHook.Stop();
                ghook.FreeHook();

                if (hWndClipboardNext != IntPtr.Zero)
                {
                    Win32.ChangeClipboardChain(this.Handle, hWndClipboardNext);
                    hWndClipboardNext = IntPtr.Zero;
                }

                if (components != null)
                    components.Dispose();
                Settings.Write(Program.SettingFileName);
                Program.WriteSentenceList();
                Program.WriteCommandHistoryList();
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            this.timer1 = new System.Windows.Forms.Timer(this.components);
            this.contextMenuStrip1 = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.表示ToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.設定ToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.バージョン情報ToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.終了ToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.notifyIcon1 = new System.Windows.Forms.NotifyIcon(this.components);
            this.timer_keyRecoding = new System.Windows.Forms.Timer(this.components);
            this.timer_suggest = new System.Windows.Forms.Timer(this.components);
            this.searchTextBox = new Lugens.Components.SearchTextBox();
            this.textBox_cmd = new Lugens.Components.AutoCompleteTextBox();
            this.contextMenuStrip1.SuspendLayout();
            this.SuspendLayout();
            // 
            // timer1
            // 
            this.timer1.Interval = 50;
            this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
            // 
            // contextMenuStrip1
            // 
            this.contextMenuStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.表示ToolStripMenuItem,
            this.設定ToolStripMenuItem,
            this.バージョン情報ToolStripMenuItem,
            this.toolStripSeparator1,
            this.終了ToolStripMenuItem});
            this.contextMenuStrip1.Name = "contextMenuStrip1";
            this.contextMenuStrip1.Size = new System.Drawing.Size(140, 98);
            this.contextMenuStrip1.Opening += new System.ComponentModel.CancelEventHandler(this.contextMenuStrip1_Opening);
            // 
            // 表示ToolStripMenuItem
            // 
            this.表示ToolStripMenuItem.Name = "表示ToolStripMenuItem";
            this.表示ToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.表示ToolStripMenuItem.Text = "表示";
            this.表示ToolStripMenuItem.Click += new System.EventHandler(this.表示ToolStripMenuItem_Click);
            // 
            // 設定ToolStripMenuItem
            // 
            this.設定ToolStripMenuItem.Name = "設定ToolStripMenuItem";
            this.設定ToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.設定ToolStripMenuItem.Text = "設定";
            this.設定ToolStripMenuItem.Click += new System.EventHandler(this.リスト設定ToolStripMenuItem_Click);
            // 
            // バージョン情報ToolStripMenuItem
            // 
            this.バージョン情報ToolStripMenuItem.Name = "バージョン情報ToolStripMenuItem";
            this.バージョン情報ToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.バージョン情報ToolStripMenuItem.Text = "バージョン情報";
            this.バージョン情報ToolStripMenuItem.Click += new System.EventHandler(this.バージョン情報ToolStripMenuItem_Click);
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(136, 6);
            // 
            // 終了ToolStripMenuItem
            // 
            this.終了ToolStripMenuItem.Name = "終了ToolStripMenuItem";
            this.終了ToolStripMenuItem.Size = new System.Drawing.Size(139, 22);
            this.終了ToolStripMenuItem.Text = "終了";
            this.終了ToolStripMenuItem.Click += new System.EventHandler(this.終了ToolStripMenuItem_Click);
            // 
            // notifyIcon1
            // 
            this.notifyIcon1.BalloonTipTitle = "キーボード記録中";
            this.notifyIcon1.ContextMenuStrip = this.contextMenuStrip1;
            this.notifyIcon1.Text = "Passer";
            this.notifyIcon1.Visible = true;
            this.notifyIcon1.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler(this.notifyIcon1_MouseDoubleClick);
            // 
            // timer_keyRecoding
            // 
            this.timer_keyRecoding.Interval = 500;
            this.timer_keyRecoding.Tick += new System.EventHandler(this.timer_keyRecoding_Tick);
            // 
            // timer_suggest
            // 
            this.timer_suggest.Enabled = true;
            this.timer_suggest.Tick += new System.EventHandler(this.timer_suggest_Tick);
            // 
            // searchTextBox
            // 
            this.searchTextBox.BackColor = System.Drawing.Color.Transparent;
            this.searchTextBox.BorderColor = System.Drawing.Color.FromArgb(((int)(((byte)(127)))), ((int)(((byte)(157)))), ((int)(((byte)(185)))));
            this.searchTextBox.FillBackColor = System.Drawing.Color.White;
            this.searchTextBox.ForeColor = System.Drawing.SystemColors.WindowText;
            this.searchTextBox.LabelFont = new System.Drawing.Font("MS UI Gothic", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            this.searchTextBox.LabelText = "label1";
            this.searchTextBox.Location = new System.Drawing.Point(9, 4);
            this.searchTextBox.Name = "searchTextBox";
            this.searchTextBox.Size = new System.Drawing.Size(205, 25);
            this.searchTextBox.TabIndex = 2;
            // 
            // textBox_cmd
            // 
            this.textBox_cmd.BackColor = System.Drawing.SystemColors.Window;
            this.textBox_cmd.Complemented = false;
            this.textBox_cmd.Font = new System.Drawing.Font("Tahoma", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.textBox_cmd.Location = new System.Drawing.Point(3, 6);
            this.textBox_cmd.MaxDropdownCount = 10;
            this.textBox_cmd.Name = "textBox_cmd";
            this.textBox_cmd.ShowableDropdownList = true;
            this.textBox_cmd.Size = new System.Drawing.Size(19, 23);
            this.textBox_cmd.TabIndex = 1;
            this.textBox_cmd.Visible = false;
            this.textBox_cmd.Complement += new Lugens.Components.AutoCompleteTextBox.ComplementEventHandler(this.textBox_cmd_Complement);
            this.textBox_cmd.TextChanged += new System.EventHandler(this.textBox_cmd_TextChanged);
            this.textBox_cmd.KeyDown += new System.Windows.Forms.KeyEventHandler(this.textBox_cmd_KeyDown);
            this.textBox_cmd.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.textBox1_KeyPress);
            // 
            // MainForm
            // 
            this.AllowDrop = true;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.BackgroundImage = global::Lugens.Passer.Properties.Resources.skin;
            this.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
            this.ClientSize = new System.Drawing.Size(221, 33);
            this.ContextMenuStrip = this.contextMenuStrip1;
            this.Controls.Add(this.searchTextBox);
            this.Controls.Add(this.textBox_cmd);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
            this.Location = new System.Drawing.Point(0, -100);
            this.Name = "MainForm";
            this.Opacity = 0D;
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            this.Load += new System.EventHandler(this.MainForm_Load);
            this.DragDrop += new System.Windows.Forms.DragEventHandler(this.MainForm_DragDrop);
            this.DragEnter += new System.Windows.Forms.DragEventHandler(this.MainForm_DragEnter);
            this.DragOver += new System.Windows.Forms.DragEventHandler(this.MainForm_DragOver);
            this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.MainForm_MouseDown);
            this.MouseMove += new System.Windows.Forms.MouseEventHandler(this.MainForm_MouseMove);
            this.MouseUp += new System.Windows.Forms.MouseEventHandler(this.MainForm_MouseUp);
            this.contextMenuStrip1.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        public void ReadSetting()
        {
            String version = Process.GetCurrentProcess().MainModule.FileVersionInfo.FileVersion;
            this.notifyIcon1.Text = "Passer " + version + "\nホットキー: " + HotKeyTextBox.GetKeyText(Program.HotKey_Main);
            Size size = this.Size;
            size.Width = Settings.GetInt(Settings.PASSER_FORM_MAIN_WIDTH);
            this.Size = size;

            if (Program.GetEngineInfo(this.SelectedEngineIndex) == null)
                this.SetSearchEngine(Program.GetEngineInfo(0));
        }

        public void ReadCommandList()
        {
            this.searchTextBox.TextBox.Items.Clear();
            foreach (CommandInfo info in Program.CommandDic.Values)
            {
                if (info.Name[0] != '@')
                {
                    IconListBoxItem item = new IconListBoxItem();
                    item.Name = info.Name;
                    item.Regex = Program.Ime.GetRomaji(info.Name);
                    item.Text = info.Name;
                    item.IconImage = info.ApplicationIcon.ToBitmap();
                    item.Type = IconListBoxType.Command;
                    this.searchTextBox.TextBox.Items.Add(item);
                }
            }

            this.searchTextBox.SortItems();
            AddSystemCommand();
        }

        private void AddSystemCommand()
        {
            searchTextBox.TextBox.Items.Add(new IconListBoxItem(null, ":quit", "アプリケーションを終了します", null, IconListBoxType.SysCommand));
            searchTextBox.TextBox.Items.Add(new IconListBoxItem(null, ":setting", "設定を行います", null, IconListBoxType.SysCommand));
            searchTextBox.TextBox.Items.Add(new IconListBoxItem(null, ":version", "バージョン情報を表示します", null, IconListBoxType.SysCommand));
        }

        private string SetArguments(string str, string[] args)
        {
            if (str == null || "".Equals(str))
                return SetArguments(args);

            int i;
            char c;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < str.Length - 1; i++)
            {
                c = str[i];
                if (c == '$')
                {
                    c = str[i + 1];
                    if (c == '$')
                    {
                        sb.Append(c);
                        i++;
                        continue;
                    }
                    if (c >= '0' && c <= '9')
                    {
                        c -= '0';
                        if (args != null && c == 0)
                            sb.Append(SetArguments(args));
                        else if (args != null && args.Length >= c)
                            sb.Append(args[c - 1]);
                        i++;
                        continue;
                    }
                }
                sb.Append(c);
            }
            if (i < str.Length)
                sb.Append(str[i]);
            return sb.ToString();
        }
        
        private string SetArguments(string[] args)
        {
            if (args == null)
                return "";
            StringBuilder sb = new StringBuilder();
            foreach (string s in args)
                sb.Append(s).Append(" ");
            sb.Remove(sb.Length - 1, 1);
            return sb.ToString();
        }

        
        /// <summary>
        /// コマンドの実行
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        private bool ExecCommand(string command)
        {
            if (command.Equals(""))
                return false;

            string[] args = null;
            string str;
            int i = command.IndexOf(' ');
            if (i == -1)
            {
                str = command;
            }
            else
            {
                str = command.Substring(0, i);
                args = Util.Split(command.Replace("　", " ").Substring(i + 1));
            }

            switch (str[0])
            {
                case ':':
                    RunSystemCommand(str);
                    return false;

                case '@':
                    try
                    {
                        string cmd = str.Substring(1);
                        if (args == null)
                            System.Diagnostics.Process.Start(cmd);
                        else
                            System.Diagnostics.Process.Start(cmd, SetArguments(args));
                        this.DoVisibleChange(false);
                        return true;
                    }
                    catch
                    {
                        return false;
                    }
                default:
                    if (!Program.CommandDic.ContainsKey(str))
                    {
                        if (!Program.CommandDic.ContainsKey(Program.DefaultCommand))
                            return false;
                        str = Program.DefaultCommand;
                        args = Util.Split(command.Replace("　", " "));
                    }
                    try
                    {
                        ProcessStartInfo info = new ProcessStartInfo();
                        CommandInfo commandInfo = Program.CommandDic[str];
                        info.FileName = EnvDeploy(commandInfo.Target);
                        info.WorkingDirectory = EnvDeploy(commandInfo.Path);
                        info.Arguments = SetArguments(commandInfo.Arguments, args);
                        System.Diagnostics.Process.Start(info);
                        this.DoVisibleChange(false);
                        return true;
                    }
                    catch (Exception ex) { MessageBox.Show("ex: " + ex.ToString()); }
                    {
                        return false;
                    }
            }
        }

        /// <summary>
        /// ファイルの実行
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        private bool ExecFile(String str)
        {
            if(Program.OSVersion >= 6.1 && str.StartsWith("ライブラリ"))
            {
                if (str.Equals("ライブラリ") || str.Equals("ライブラリ\\"))
                {
                    ShellObject o = KnownFolders.Libraries as ShellObject;
                    System.Diagnostics.Process.Start(o.ParsingName);
                    this.DoVisibleChange(false);
                    return true;
                }

                string file;
                string[] directories = str.Split('\\');
                if (directories.Length == 2 || (directories.Length == 3 && String.IsNullOrEmpty(directories[2])))
                {
                    file = directories[1];
                    ShellContainer sc = KnownFolders.Libraries as ShellContainer;
                    foreach (ShellObject o in sc)
                    {
                        if (o.Name.Equals(file))
                        {
                            System.Diagnostics.Process.Start(o.ParsingName);
                            this.DoVisibleChange(false);
                            return true;
                        }
                    }
                }
                else if (directories.Length > 2)
                {
                    bool bBreak = false;
                    string fullDir = "";
                    file = directories[2];
                    ShellLibrary lib = Program.GetShellLibrary(directories[1]);
                    if (lib == null)
                        return false;

                    foreach (ShellObject o in lib)
                    {
                        if (o is ShellContainer)
                        {
                            ShellContainer sc = o as ShellContainer;
                            foreach (ShellObject so in sc)
                            {
                                if (so.Name.Equals(file))
                                {
                                    fullDir = so.ParsingName + "\\";
                                    bBreak = true;
                                }
                                if (bBreak)
                                    break;
                            }
                        }
                        if (bBreak)
                            break;
                    }
                    lib.Close();

                    if (!bBreak)
                        return false;

                    for (int i = 3; i < directories.Length; i++)
                    {
                        fullDir += directories[i];
                        if (i + 1 < directories.Length)
                            fullDir += "\\";
                    }
                    str = fullDir;
                }
            }

            if(Directory.Exists(str) || File.Exists(str))
            {
                System.Diagnostics.Process.Start(str);
                this.DoVisibleChange(false);
                return true;
            }
            return false;
        }

        private bool RunSystemCommand(String str)
        {
            //if (str.Equals(":debug on"))
            //{
            //    Program.DEBUG = true;
            //}
            //if (str.Equals(":debug off"))
            //{
            //    Program.DEBUG = false;
            //}
            if (str.Equals(":gc"))
            {
                System.GC.Collect();
            }

            if (str.Equals(":q") || str.Equals(":quit"))
            {
                this.DoVisibleChange(false);
                this.Close();
                Application.Exit();
                return true;
            }

            if (str.Equals(":s") || str.Equals(":setting"))
            {
                this.DoVisibleChange(false);
                Program.SettingForm.DoVisibleChange(true);
                return true;
            }

            if (str.Equals(":v") || str.Equals(":version"))
            {
                this.DoVisibleChange(false);
                Program.Status = ProgramStatus.VersionFormOpen;
                VersionForm f = new VersionForm();
                f.ShowDialog();
                Program.Status = ProgramStatus.Waiting;
            }

            return false;
        }

        private void ExecSearch(string str)
        {
            EngineInfo info = Program.GetEngineInfo(this.SelectedEngineIndex);
            if (String.IsNullOrEmpty(str))
                str = info.Url;
            else
            {
                Encoding src = Encoding.GetEncoding("Shift_JIS");
                byte[] tmp = src.GetBytes(str);
                Encoding enc = Encoding.GetEncoding("UTF-8");
                byte[] tmp2 = Encoding.Convert(src, enc, tmp);
                str = info.SearchUrl.Replace("%s", HttpUtility.UrlEncode(str, Encoding.GetEncoding(info.Encoding)));
            }
            System.Diagnostics.Process.Start(str);
            this.DoVisibleChange(false);
        }

        private string EnvDeploy(string str)
        {
            string ret = "";
            string[] s = str.Split('%');
            for (int i = 0; i < s.Length - 1; i++)
                ret += System.Environment.GetEnvironmentVariable(s[i]);
            ret += s[s.Length - 1];
            return ret;
        }

        
        /// <summary>
        /// 検索エンジンを変更
        /// </summary>
        /// <param name="info"></param>
        public void SetSearchEngine(EngineInfo info)
        {
            int index = Program.GetEngineIndex(info.Name);
            if (index == -1)
            {
                SetSearchEngine(Program.GetEngineInfo(0));
                return;
            }
            this.SelectedEngineIndex = index;
            this.SelectedEngineType = info.Type;
            this.SearchTextBox.LabelText = info.Display;
            this.SearchTextBox.Icon.Image = info.IconImage;
            this.SearchTextBox.Invalidate();
            switch (this.SelectedEngineType)
            {
                case 0: //Passer
                    Program.CommandHistoryIndex = 0;
                    break;
                case 1: //FileSearch
                    this.SetRootDriveList();
                    break;
            }
            this.suggestSupport = !String.IsNullOrEmpty(info.SuggestUrl);
        }

        protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            Pen pen = new Pen(SystemColors.ControlDark);
            SolidBrush brush = new SolidBrush(SystemColors.ActiveCaption);
            g.DrawRectangle(pen, 0, 0, this.Width - 1, this.Height - 1);
        }

        public Icon GetIconCallBack(string name)
        {
            if (Program.CommandDic.ContainsKey(name))
            {
                CommandInfo info = Program.CommandDic[name];
                return info.ApplicationIcon;
            }
            return null;
        }

        public void DoVisibleChange(bool visible)
        {
            if (visible)
            {
                this.Invalidate();
                Program.Status = ProgramStatus.MainFormOpen;
                this.Visible = true;
                this.Location = this.seenPoint;
                this.DoResize(Settings.GetInt(Settings.PASSER_FORM_MAIN_WIDTH));
                this.searchTextBox.TextBox.SelectionStart = 0;
                this.searchTextBox.TextBox.ShowableDropdownList = true;
                if (!Program.Main_MemorizeEngine)
                    this.SetSearchEngine(Program.GetEngineInfo(0));
                this.timer1.Start();
                this.Status = MainFormStatus.Active;
            }
            else
            {
                Program.Status = ProgramStatus.Waiting;
                Program.CommandHistoryIndex = 0;
                Settings.Set(Settings.PASSER_MAIN_ENGINE_INDEX, this.SelectedEngineIndex);
                this.Opacity = 0;
                this.Visible = false;
                this.searchTextBox.TextBox.Text = "";
                this.searchTextBox.TextBox.ShowableDropdownList = false;
                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                this.timer1.Stop();
                this.Status = MainFormStatus.Hide;
            }
        }

        protected override CreateParams CreateParams
        {
            get
            {
                const int CS_NOCLOSE = 0x200;

                CreateParams cp = base.CreateParams;
                cp.ClassStyle |= CS_NOCLOSE | 0x00020000;
                return cp;
            }
        }

        
        protected override void WndProc(ref Message m)
        {
            Rectangle r;
            KeyRecordInfo info;
            StringBuilder sb;
            Point p;
            switch (m.Msg)
            {
                case Program.WM_HOTKEY_EXECUTE:
                    HotKeyProcessExecuter.Execute(Program.HotKeyProcessDic[(int)m.LParam]);
                    break;

                case Program.WM_APP_LBUTTONDOWN:
                case Program.WM_APP_RBUTTONDOWN:
                    switch (Program.Status)
                    {
                        case ProgramStatus.MainFormOpen:
                        case ProgramStatus.SelectingSearchEngine:
                            p = new Point((short)m.WParam, (short)m.LParam);
                            r = Program.MainForm.Bounds;
                            if (r.Left > p.X || r.Right < p.X || r.Top > p.Y || r.Bottom < p.Y)
                            {
                                if (Program.MainForm.DropdownForm.Visible)
                                {
                                    r = Program.MainForm.DropdownForm.Bounds;
                                    if (r.Left > p.X || r.Right < p.X || r.Top > p.Y || r.Bottom < p.Y)
                                    {
                                        //Program.MainForm.DoVisibleChange(false);
                                        Program.MainForm.Opacity = 0.4;
                                        Program.MainForm.DropdownForm.DoVisibleChange(false);
                                        Program.MainForm.Status = MainFormStatus.NoActive;
                                    }
                                }
                                else
                                {
                                    Debug.WriteLine("MainFormOpen:5");
                                    //Program.MainForm.DoVisibleChange(false);
                                    Program.MainForm.Opacity = 0.4;
                                    Program.MainForm.Status = MainFormStatus.NoActive;
                                }
                            }
                            else if(Program.MainForm.Opacity != Program.FormOpacity)
                            {
                                Program.MainForm.Opacity = Program.FormOpacity;
                            }
                            Debug.WriteLine("MainFormOpen:1");
                            Program.Status = ProgramStatus.MainFormOpen;
                            break;

                        case ProgramStatus.SentenceFormOpen:
                            Program.HideToolTip();
                            p = new Point((short)m.WParam, (short)m.LParam);
                            r = Program.SentenceForm.Bounds;
                            if (r.Left > p.X || r.Right < p.X || r.Top > p.Y || r.Bottom < p.Y)
                                Program.SentenceForm.DoVisibleChange(false);
                            break;

                        case ProgramStatus.PopupFormOpen:
                            p = new Point((short)m.WParam, (short)m.LParam);
                            r = Program.PopupForm.Bounds;
                            if (r.Left > p.X || r.Right < p.X || r.Top > p.Y || r.Bottom < p.Y)
                                Program.PopupForm.DoVisibleChange(false);
                            break;
                    }
                    break;

                case Program.WM_APP_CHAR:
                case Program.WM_APP_KEYUP:
                case Program.WM_APP_KEYDOWN:
                    if (Program.Status == ProgramStatus.KeyRecoding)
                    {
                        info = new KeyRecordInfo();
                        info.Message = m.Msg;
                        info.Keycode = (int)m.WParam;
                        info.VkCode = (int)m.LParam;
                        Program.KeyRecordList.Add(info);
                    }
                    break;

                case Program.WM_APP_IME_START:
                case Program.WM_APP_IME_END:
                    if (Program.Status == ProgramStatus.KeyRecoding)
                    {
                        info = new KeyRecordInfo();
                        info.Message = m.Msg;
                        Program.KeyRecordList.Add(info);
                    }
                    break;

                case Program.WM_APP_IME_COMP:
                    if (Program.Status == ProgramStatus.KeyRecoding)
                    {
                        info = new KeyRecordInfo();
                        sb = new StringBuilder(1024);
                        ghook.GetImeString(sb, 1023);
                        info.Message = m.Msg;
                        info.Str = sb.ToString();
                        Program.KeyRecordList.Add(info);
                    }
                    break;

                case Program.WM_APP_REC_END:
                    KeyRecordParser paser = new KeyRecordParser();
                    Program.KeyRecordString = paser.Parse(Program.KeyRecordList, (int)m.WParam);
                    if (!"".Equals(Program.KeyRecordString) && Program.Main_SendRecordToClipboard)
                    {
                        Program.Status = ProgramStatus.Executing;
                        Clipboard.SetText(Program.KeyRecordString);
                        Program.AddClipboardList(Program.KeyRecordString, 1);
                        Program.Status = ProgramStatus.Waiting;
                    }
                    break;

                case Win32.WM_VSCROLL:
                    int code = ((int)m.WParam & 0xFFFF);
                    int pos = ((int)m.WParam >> 16);
                    switch (code)
                    {
                        case Win32.SB_LINEUP:
                        case Win32.SB_LINEDOWN:
                            this.dropdownListBox_SelectedIndexChanged(null, null);
                            break;

                        case Win32.SB_THUMBTRACK:
                            if (this.scrollPos != pos)
                            {
                                this.dropdownListBox_SelectedIndexChanged(null, null);
                                this.scrollPos = pos;
                            }
                            break;
                    }
                    break;

                case Win32.WM_DRAWCLIPBOARD:
                    if (Program.ClipboardFirstTime)
                        Program.ClipboardFirstTime = false;
                    else
                    {
                        if (Program.Status == ProgramStatus.Waiting)
                        {
                            if (Clipboard.ContainsText() && Clipboard.GetText().Length > 0 && Clipboard.GetText().Length <= 500000)
                            {
                                //50万文字以下の場合、クリップボードの内容をコピー
                                if(Program.SentenceGroupList[0].Count == 0)
                                    Program.AddClipboardList(Clipboard.GetText());
                                else if(!Program.SentenceGroupList[0][0].Value.Equals(Clipboard.GetText()))
                                    Program.AddClipboardList(Clipboard.GetText());
                            }

                            if (Clipboard.ContainsFileDropList())
                            {
                                sb = new StringBuilder();
                                foreach (string s in Clipboard.GetFileDropList())
                                    sb = sb.Append(s).Append(System.Environment.NewLine);

                                if (sb.ToString().Length <= 500000)
                                    Program.AddClipboardList(sb.ToString());
                            }
                        }
                    }
                    if (hWndClipboardNext != IntPtr.Zero)
                        Win32.SendMessage(hWndClipboardNext, m.Msg, m.WParam, m.LParam);
                    break;

                case Win32.WM_CHANGECBCHAIN:
                    if (m.WParam == hWndClipboardNext)
                        hWndClipboardNext = (IntPtr)m.LParam;
                    else if (hWndClipboardNext != IntPtr.Zero)
                        Win32.SendMessage(hWndClipboardNext, m.Msg, m.WParam, m.LParam);
                    break;

                case Program.WM_SUGGEST_END:
                    string str = Marshal.PtrToStringAuto(m.LParam);
                    List<string> list = new List<string>();
                    using (StringReader stringReader = new StringReader(str))
                    {
                        using (JsonReader jsonReader = new JsonTextReader(stringReader))
                        {
                            while (jsonReader.Read())
                            {
                                if (jsonReader.TokenType == JsonToken.EndArray)
                                    break;
                                if (jsonReader.TokenType == JsonToken.String)
                                    
                                    list.Add(HttpUtility.HtmlDecode(jsonReader.Value.ToString()));
                            }
                        }
                    }

                    if (this.suggestString.ToLower().Equals(list[0].ToLower()))
                    {
                        list.RemoveAt(0);
                        if (list.Count > 0)
                        {
                            this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Clear();
                            foreach (string s in list)
                            {
                                IconListBoxItem item = new IconListBoxItem();
                                item.Name = s;
                                item.Regex = Program.Ime.GetRomaji(s);
                                item.Text = s;
                                item.Type = IconListBoxType.SearchEngineText;
                                this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
                            }

                            this.searchTextBox.TextBox.SetDropdownFormLocation();
                            this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(true);
                        }
                        else
                        {
                            this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                        }
                    }
                    break;

            }

            base.WndProc(ref m);
        }

        public bool EnumWindowsProc(IntPtr hWnd, IntPtr lParam)
        {
            string s = Program.MainForm.notifyIcon1.BalloonTipText;
            StringBuilder sb = new StringBuilder(256);
            Win32.SendMessage(hWnd, 0x0D, (IntPtr)255, sb);
            if(s.Equals(sb.ToString()))
            {
                Program.BallonWindowHandle = hWnd;
                return false;
            }
            return true;
        }

        private void contextMenuStrip1_Opening(object sender, CancelEventArgs e)
        {
            switch(Program.Status){
                case ProgramStatus.MainFormOpen:
                    Program.MainForm.DoVisibleChange(false);
                    Program.Status = ProgramStatus.Waiting;
                    break;
                case ProgramStatus.PopupFormOpen:
                    Program.PopupForm.DoVisibleChange(false);
                    Program.Status = ProgramStatus.Waiting;
                    break;
            }
        }

        private void MainForm_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                if ((e.KeyState & 0x04) != 0)
                    e.Effect = DragDropEffects.Move;
                else
                    e.Effect = DragDropEffects.Copy;
            }
        }

        private void MainForm_DragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                if ((e.KeyState & 0x04) != 0)
                    e.Effect = DragDropEffects.Move;
                else
                    e.Effect = DragDropEffects.Copy;
            }
        }

        private void MainForm_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (String[])e.Data.GetData(DataFormats.FileDrop);
            if (files == null || files.Length != 1)
                return;

            string file = files[0];

            if ((e.KeyState & 0x04) != 0)
            {
                int sel = this.searchTextBox.TextBox.SelectionStart + file.Length;
                string str = this.searchTextBox.TextBox.Text;
                str = str.Substring(0, this.searchTextBox.TextBox.SelectionStart) + file + str.Substring(this.searchTextBox.TextBox.SelectionStart);
                this.searchTextBox.TextBox.Text = str;
                this.Opacity = Program.FormOpacity;
                this.searchTextBox.TextBox.Focus();
                this.searchTextBox.TextBox.SelectionStart = sel;
            }
            else
            {
                Program.SettingForm.DoVisibleChange(true);
                Program.SettingForm.TabControl.SelectTab("tabPageCommand");
                AddCommandForm form = new AddCommandForm();
                form.SetSelectedFile(file);
                Program.SettingForm.TargetForm = form;
                Win32.PostMessage(Program.SettingForm.Handle, Program.WM_APP_SHOWFORM, IntPtr.Zero, IntPtr.Zero);
                this.DoVisibleChange(false);
            }


        }

    }
}
