/**
 * $Revision: 238 $
 * $Date: 2010-03-18 20:45:05 +0900 (木, 18 3 2010) $
*/

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Web;
using Lugens.Components;
using Lugens.Utils;
using System.Runtime.InteropServices;
using Newtonsoft.Json;
using Microsoft.WindowsAPICodePack.Shell;
using System.Drawing.Imaging;

namespace Lugens.Passer
{
    public partial class MainForm
    {

        private void DoResize(int width)
        {
            Size size = this.Size;
            size.Width = width;
            if (size.Width < 200)
                size.Width = 200;
            else if (size.Width > 600)
                size.Width = 600;

            Settings.Set(Settings.PASSER_FORM_MAIN_WIDTH, size.Width);

            this.Size = size;
            size.Width -= 16;
            size.Height = this.searchTextBox.Size.Height;
            this.searchTextBox.Size = size;
            if (this.searchTextBox.TextBox.DropdownForm.Visible)
            {
                Program.Status = ProgramStatus.MainFormOpen;
                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
            }

        }

        private void MainForm_MouseDown(object sender, MouseEventArgs e)
        {
            if ((e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                this.mousePoint = new Point(-e.X, -e.Y);
                this.windowMoveFlag = true;
            }
        }

        private void MainForm_MouseMove(object sender, MouseEventArgs e)
        {
            if (this.Cursor == Cursors.SizeWE && (e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                //ウィンドウの幅変更
                this.DoResize(e.X);
            }
            else if (this.windowMoveFlag && (e.Button & MouseButtons.Left) == MouseButtons.Left)
            {
                //ウィンドウの移動
                this.seenPoint = new Point(this.Left + mousePoint.X + e.X, this.Top + mousePoint.Y + e.Y);
                this.Location = this.seenPoint;

                Settings.Set(Settings.PASSER_FORM_MAIN_X, this.seenPoint.X);
                Settings.Set(Settings.PASSER_FORM_MAIN_Y, this.seenPoint.Y);

                if (this.searchTextBox.TextBox.DropdownForm.Visible)
                {
                    Program.Status = ProgramStatus.MainFormOpen; 
                    this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                }
            }
            else if (e.X >= (this.Size.Width - 4))
            {
                //幅変更カーソルに変更
                this.Cursor = Cursors.SizeWE;
            }
            else
            {
                //標準カーソルに変更
                if (this.Cursor == Cursors.SizeWE)
                    this.Cursor = Cursors.Default;
            }
        }

        private void MainForm_MouseUp(object sender, MouseEventArgs e)
        {
            this.windowMoveFlag = false;
        }

        private void MainForm_Load(object sender, System.EventArgs e)
        {
            this.Visible = false;
            this.Size = new Size(256, 32);
            this.Location = this.seenPoint;
            ReadCommandList();
            this.searchTextBox.TextBox.DropdownForm.DrawType = Lugens.Components.DropdownListForm.DrawMode.IconText;
            this.searchTextBox.TextBox.DropdownForm.IconCallBack = this.GetIconCallBack;
            this.searchTextBox.TextBox.DropdownForm.VisibleChanged += this.dropdownListBox_SelectedIndexChanged;
            this.searchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndexChanged += this.dropdownListBox_SelectedIndexChanged;
            this.searchTextBox.TextBox.DropdownForm.DropdownListBox.VisibleChanged += this.dropdownListBox_SelectedIndexChanged;
            this.Activated += this.dropdownListBox_SelectedIndexChanged;
            this.AddOwnedForm(this.searchTextBox.TextBox.DropdownForm);

            if (Program.Main_MemorizeEngine)
            {
                EngineInfo info = Program.GetEngineInfo(Settings.GetInt(Settings.PASSER_MAIN_ENGINE_INDEX));
                if(info == null)
                    this.SetSearchEngine(Program.GetEngineInfo(0));
                else
                    this.SetSearchEngine(info);
            }
        }

        private void ShowDropdownForm(bool filter)
        {
            switch (this.SelectedEngineType)
            {
                case 0: //Passer
                    this.SetDropdownList(filter);
                    if (this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Count > 0)
                    {
                        this.searchTextBox.TextBox.SetDropdownFormLocation();
                        this.searchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndex = 0;
                        this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(true);
                    }
                    break;
                case 1: //FileSearch
                    this.SetLocalDropdownList(filter);
                    if (this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Count > 0)
                    {
                        this.searchTextBox.TextBox.SetDropdownFormLocation();
                        this.searchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndex = 0;
                        this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(true);
                    }
                    break;

                case 2: //WebSearch
                    if (String.IsNullOrEmpty(this.searchTextBox.TextBox.Text))
                    {
                        Program.Status = ProgramStatus.MainFormOpen; 
                        this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                        this.suggestString = "";
                    }
                    else
                    {
                        this.textChanged = true;
                    }
                    break;
            }
        }

        private void SetRootDriveList()
        {
            Program.RootDriveList.Clear();
            Program.AliasDic.Clear();
            foreach (DriveInfo d in DriveInfo.GetDrives())
            {
                IconListBoxItem item = new IconListBoxItem();
                item.Name = d.Name;
                item.Text = item.Name;
                item.ToolTipText = item.Name;
                item.Type = IconListBoxType.Directory;
                switch (d.DriveType)
                {
                    case DriveType.Fixed:
                        if (Environment.SystemDirectory.StartsWith(d.Name))
                            item.IconImage = Properties.Resources.IconDriveWin.ToBitmap();
                        else
                            item.IconImage = Properties.Resources.IconDriveFix.ToBitmap();
                        break;
                    case DriveType.Network:
                        item.IconImage = Properties.Resources.IconDriveNet.ToBitmap();
                        break;
                    case DriveType.CDRom:
                        item.IconImage = Properties.Resources.IconDriveCD.ToBitmap();
                        break;
                    case DriveType.Removable:
                        item.IconImage = Properties.Resources.IconDriveRem.ToBitmap();
                        break;
                    default:
                        item.IconImage = Properties.Resources.IconDriveFix.ToBitmap();
                        break;
                }
                Program.RootDriveList.Add(item);
            }

            if (Program.OSVersion >= 6.1)
            {
                //Win7 or later
                Bitmap bitmap;
                ShellObject lib = (ShellObject)KnownFolders.Libraries;
                IconListBoxItem item = new IconListBoxItem();
                item.Name = lib.ToString() + "\\";
                item.Text = item.Name;
                item.ToolTipText = item.Name;
                item.Regex = Program.Ime.GetRomaji(item.Name);
                item.Type = IconListBoxType.Directory;
                lib.Thumbnail.FormatOption = ShellThumbnailFormatOption.IconOnly;
                item.IconImage = Program.GetBitmap(lib);
                Program.RootDriveList.Add(item);
                Program.AliasDic.Add(lib.ToString(), KnownFolders.Libraries.Path);
            }
            
        }

        private void SetDropdownList(bool filter)
        {
            string[] commands = Program.ParseCommand(this.searchTextBox.TextBox.Text);
            string command = "";
            if(commands.Length > 0)
                command = commands[commands.Length - 1];

            this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Clear();
            if (filter && command.Equals(""))
            {
                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                return;
            }


            foreach (IconListBoxItem item in this.searchTextBox.TextBox.Items)
            {
                if (item.Text.ToLower().StartsWith(this.searchTextBox.TextBox.Text.ToLower()) || Program.Ime.StartsWith(item.Regex, this.searchTextBox.TextBox.Text))
                    this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
            }
            if (command.Length > 0)
            {
                foreach (string str in Program.CommandHistoryList)
                {
                    if (str.StartsWith(command))
                    {
                        bool exist = false;
                        foreach (IconListBoxItem item in this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items)
                        {
                            if (str.Equals(item.Text))
                            {
                                exist = true;
                                break;
                            }
                        }

                        if (exist)
                            continue;
                        IconListBoxItem i = new IconListBoxItem();
                        i.Name = str;
                        i.Text = str;
                        i.Type = IconListBoxType.History;
                        i.IconImage = null;
                        this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(i);
                    }
                }
            }
            
            if (this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Count == 0)
            {
                Program.Status = ProgramStatus.MainFormOpen;
                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                return;
            }
        }


        /// <summary>
        /// ローカルのサジェスト
        /// </summary>
        /// <param name="text"></param>
        public void SetLocalDropdownList(bool filter)
        {
/*
            string[] commands = Program.ParseFile(this.searchTextBox.TextBox.Text);
            

            foreach(string s in commands)
            Debug.WriteLine("commands:" + s);
            Debug.WriteLine("end");

            string command = "";
            if (commands.Length > 0)
                command = commands[commands.Length - 1];
*/
            string command = this.searchTextBox.TextBox.Text;
            string file;
            this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Clear();
            if (filter && command.Equals(""))
            {
                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                return;
            }

            if (command.LastIndexOf('\\') == -1)
            {
                //ルートドライブ
                string str = command.ToLower();
                foreach (IconListBoxItem item in Program.RootDriveList)
                {
                    if (item.Text.ToLower().StartsWith(str) || Program.Ime.StartsWith(item.Regex, str))
                        this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
                }
            }
            else
            {
                if (Program.OSVersion >= 6.1 && command.StartsWith("ライブラリ"))
                {
                    string[] directories = command.Split('\\');
                    if (directories.Length == 2)
                    {
                        file = directories[1];
                        ShellContainer sc = KnownFolders.Libraries as ShellContainer;
                        foreach (ShellObject o in sc)
                        {
                            string regex = Program.Ime.GetRomaji(o.Name);
                            if (o.Name.StartsWith(file) || Program.Ime.StartsWith(regex, file))
                            {
                                IconListBoxItem item = new IconListBoxItem();
                                item.Name = o.Name + "\\";
                                item.Text = item.Name;
                                item.ToolTipText = item.Text;
                                item.Type = IconListBoxType.Directory;
                                item.Regex = regex;
                                o.Thumbnail.FormatOption = ShellThumbnailFormatOption.IconOnly;
                                item.IconImage = Program.GetBitmap(o);
                                this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
                            }
                        }
                    }
                    else if (directories.Length == 3)
                    {
                        file = directories[2];
                        ShellLibrary lib = Program.GetShellLibrary(directories[1]);
                        if (lib == null)
                            return;

                        foreach (ShellObject o in lib)
                        {
                            if (o is ShellContainer)
                            {
                                ShellContainer sc = o as ShellContainer;
                                foreach (ShellObject so in sc)
                                {
                                    string regex = Program.Ime.GetRomaji(so.Name);
                                    if (so.Name.StartsWith(file) || Program.Ime.StartsWith(regex, file))
                                    {
                                        IconListBoxItem item = new IconListBoxItem();
                                        item.Name = so.Name + "\\";
                                        item.Text = item.Name;
                                        item.ToolTipText = item.Text;
                                        item.Type = IconListBoxType.Directory;
                                        item.Regex = regex;
                                        so.Thumbnail.FormatOption = ShellThumbnailFormatOption.IconOnly;
                                        item.IconImage = Program.GetBitmap(so);
                                        this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
                                        Debug.WriteLine(so.ParsingName);
                                    }
                                }
                            }
                        }
                        lib.Close();
                    }
                    else if (directories.Length > 3)
                    {
                        bool bBreak = false;
                        string fullDir = "";
                        file = directories[2];
                        ShellLibrary lib = Program.GetShellLibrary(directories[1]);
                        if (lib == null)
                            return;

                        foreach (ShellObject o in lib)
                        {
                            if (o is ShellContainer)
                            {
                                ShellContainer sc = o as ShellContainer;
                                foreach (ShellObject so in sc)
                                {
                                    if (so.Name.Equals(file))
                                    {
                                        fullDir = so.ParsingName + "\\";
                                        bBreak = true;
                                    }
                                    if (bBreak)
                                        break;
                                }
                            }
                            if (bBreak)
                                break;
                        }
                        lib.Close();

                        if (!bBreak)
                            return;

                        for (int i = 3; i < directories.Length; i++)
                        {
                            fullDir += directories[i];
                            if (i + 1 < directories.Length)
                                fullDir += "\\";
                        }

                        int lindex = fullDir.LastIndexOf("\\") + 1;
                        if (lindex > 0)
                        {
                            string dir = fullDir.Substring(0, lindex);
                            string files = fullDir.Substring(lindex);
                            this.AddFileSearchItem(files, dir);
                        }
                    }
                }
                else
                {
                    int lindex = command.LastIndexOf('\\') + 1;
                    if (lindex > 0)
                    {
                        string directories = command.Substring(0, lindex);
                        string files = command.Substring(lindex);
                        this.AddFileSearchItem(files, directories);
                    }
                }
            }
            if(this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Count == 0)
                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
        }

        public bool AddFileSearchItem(string files, string directories)
        {
            try
            {
                if (Directory.GetFileSystemEntries(directories, "*").Length > 0)
                {
                    this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Clear();
                    if (this.searchTextBox.TextBox.Text.Equals(Directory.GetDirectoryRoot(directories)))
                    {
                        DriveInfo driveInfo = new DriveInfo(this.searchTextBox.TextBox.Text[0].ToString());
                        if (!driveInfo.IsReady)
                            return false;
                    }
                    foreach (string directory in Directory.GetDirectories(directories))
                    {
                        string name = directory.Substring(directories.Length) + "\\";
                        if (name.StartsWith(files) || Program.Ime.StartsWith(Program.Ime.GetRomaji(name), files))
                        {
                            IconListBoxItem item = new IconListBoxItem();
                            item.Name = name;
                            item.Text = item.Name;
                            item.ToolTipText = item.Text;
                            item.Type = IconListBoxType.Directory;
                            item.IconImage = Program.DirectoryIcon.ToBitmap();
                            item.Regex = Program.Ime.GetRomaji(item.Name);
                            this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
                        }
                    }
                    foreach (string s in Directory.GetFiles(directories))
                    {
                        string name = s.Substring(directories.Length);
                        if (name.StartsWith(files) || Program.Ime.StartsWith(Program.Ime.GetRomaji(name), files))
                        {
                            int extindex;
                            string ext;
                            IconListBoxItem item = new IconListBoxItem();
                            item.Name = name;
                            item.Text = item.Name;
                            item.ToolTipText = item.Name;
                            item.Type = IconListBoxType.File;

                            extindex = item.Name.LastIndexOf('.');
                            ext = extindex == -1 ? "" : item.Name.Substring(extindex + 1);

                            if ("exe".Equals(ext) || "lnk".Equals(ext))
                            {
                                Win32.SHFILEINFO shinfo = new Win32.SHFILEINFO();
                                Win32.SHGetFileInfo(s, 0, ref shinfo, Marshal.SizeOf(shinfo), Win32.SHGFI_ICON | Win32.SHGFI_LARGEICON);
                                if (shinfo.hIcon != IntPtr.Zero)
                                    item.IconImage = System.Drawing.Icon.FromHandle(shinfo.hIcon).ToBitmap();
                            }
                            else
                            {
                                if (Program.ExtIconCacheDic.ContainsKey(ext))
                                {
                                    if (Program.ExtIconCacheDic[ext] != null)
                                        item.IconImage = Program.ExtIconCacheDic[ext].ToBitmap();
                                }
                                else
                                {
                                    Win32.SHFILEINFO shinfo = new Win32.SHFILEINFO();
                                    Win32.SHGetFileInfo(s, 0, ref shinfo, Marshal.SizeOf(shinfo), Win32.SHGFI_ICON | Win32.SHGFI_LARGEICON);
                                    if (shinfo.hIcon != IntPtr.Zero)
                                    {
                                        Icon icon = System.Drawing.Icon.FromHandle(shinfo.hIcon);
                                        Program.ExtIconCacheDic.Add(ext, icon);
                                        item.IconImage = icon.ToBitmap();
                                    }
                                    else
                                    {
                                        Program.ExtIconCacheDic.Add(ext, null);
                                    }
                                }
                            }
                            item.Regex = Program.Ime.GetRomaji(item.Name);
                            this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
                        }
                    }
                }
                return true;
            }
            catch (Exception e)
            {
                return false;
                //MessageBox.Show(e.ToString());
                //this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
            }

        }

        /// <summary>
        /// 検索エンジンのサジェスト
        /// </summary>
        public void SetEngineDropdownList(string text)
        {
            if (!this.suggestSupport || this.suggestString.Equals(text))
                return;

            EngineInfo info = Program.GetEngineInfo(this.SelectedEngineIndex);
            if (info == null)
                return;


            string url = info.SuggestUrl.Replace("%s", Uri.EscapeDataString(text));
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
            req.Method = "GET";
            req.UserAgent = Program.UserAgent;

            AsyncCallback readCallBack = new AsyncCallback(SuggestReadCallBack);
            req.BeginGetResponse(readCallBack, req);
            this.suggestString = text;

        }


        /// <summary>
        /// DropdownFormにエンジンリスト一覧を表示する
        /// </summary>
        public void ShowEngineList()
        {
            if (!this.SearchTextBox.TextBox.DropdownForm.Visible)
            {
                //検索エンジンリストの表示
                this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Clear();
                foreach (string key in Program.DefaultEngineList)
                {
                    EngineInfo info = Program.DefaultEngineDic[key];
                    IconListBoxItem item = new IconListBoxItem();
                    item.Name = info.Name;
                    item.Text = info.Name;
                    item.ToolTipText = info.Display;
                    item.IconImage = info.IconImage;
                    item.Type = IconListBoxType.SearchEngine;
                    item.Data = info;
                    item.Regex = Program.Ime.GetRomaji(item.Name);
                    this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
                }
                foreach (string key in Program.EngineList)
                {
                    EngineInfo info = Program.EngineDic[key];
                    IconListBoxItem item = new IconListBoxItem();
                    item.Name = info.Name;
                    item.Text = info.Name;
                    item.ToolTipText = info.Display;
                    item.IconImage = info.IconImage;
                    item.Type = IconListBoxType.SearchEngine;
                    item.Data = info;
                    item.Regex = Program.Ime.GetRomaji(item.Name);
                    this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Add(item);
                }
                this.searchTextBox.TextBox.SetDropdownFormLocation();
                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(true);
                this.searchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndex = 0;
                Program.Status = ProgramStatus.SelectingSearchEngine;
            }
        }


        private void SuggestReadCallBack(IAsyncResult ar)
        {
            try
            {
                HttpWebRequest req = (HttpWebRequest)ar.AsyncState;
                HttpWebResponse response = (HttpWebResponse)req.EndGetResponse(ar);
                StreamReader streamReader = new StreamReader(response.GetResponseStream(), Encoding.GetEncoding(response.CharacterSet));
                string str = streamReader.ReadToEnd();
                streamReader.Close();
                Win32.PostMessage(Program.MainFormHandle, Program.WM_SUGGEST_END, IntPtr.Zero, Marshal.StringToHGlobalAuto(str));
            }
            catch (Exception ex)
            {
                Debug.WriteLine("error:" + ex);
            } 
        } 

        private void textBox1_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
        {
            if (Program.HotKeyEngineList.Contains(KeyboardHook.Keycode))
            {
                EngineInfo info = Program.GetEngineInfoFromHotKey(KeyboardHook.Keycode);
                if (info == null)
                    return;

                this.SetSearchEngine(info);
                if (this.searchTextBox.TextBox.DropdownForm.Visible)
                    this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                e.Handled = true;
                return;
            }

            switch ((Keys)e.KeyChar)
            {
                case Keys.Tab:
                    e.Handled = true;
                    if (this.searchTextBox.TextBox.DropdownForm.Visible && this.searchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndex >= 0)
                    {
                        //タブキーによるコマンド補完
                        this.searchTextBox.TextBox.Complemented = true;
                        IconListBoxItem item = (IconListBoxItem)this.searchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedItem;
                        switch (item.Type)
                        {
                            case IconListBoxType.File:
                            case IconListBoxType.Directory:
                                int index = this.searchTextBox.TextBox.Text.LastIndexOf('\\');
                                if (index == -1)
                                    this.searchTextBox.TextBox.Text = item.Name;
                                else
                                    this.searchTextBox.TextBox.Text = this.searchTextBox.TextBox.Text.Substring(0, index + 1) + item.Name;
                                this.searchTextBox.TextBox.SelectionStart = this.searchTextBox.TextBox.Text.Length;
                                Program.Status = ProgramStatus.MainFormOpen; 
                                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                                break;
                            case IconListBoxType.Command:
                            case IconListBoxType.History:
                            case IconListBoxType.SysCommand:
                            case IconListBoxType.SearchEngineText:
                                this.searchTextBox.TextBox.Text = item.Text;
                                this.searchTextBox.TextBox.SelectionStart = this.searchTextBox.TextBox.Text.Length;
                                Program.Status = ProgramStatus.MainFormOpen; 
                                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                                break;
                            case IconListBoxType.SearchEngine:
                                EngineInfo info = (EngineInfo)item.Data;
                                this.SetSearchEngine(info);
                                Program.Status = ProgramStatus.MainFormOpen; 
                                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                                return;
                        }
                    }

                    if (this.SearchTextBox.TextBox.Complemented)
                        return;

                    if (!this.SearchTextBox.TextBox.DropdownForm.Visible)
                    {
                        this.ShowDropdownForm(false);
                        return;
                    }
                    break;

                case Keys.Space:
                    if ((Control.ModifierKeys & Keys.Control) == Keys.Control)
                    {
                        e.Handled = true;
                        if (!this.searchTextBox.TextBox.DropdownForm.Visible)
                        {
                            switch (this.SelectedEngineType)
                            {
                                case 0: //Passer
                                case 1: //FileSearch
                                    if (this.SearchTextBox.TextBox.ShowableDropdownList)
                                        this.ShowDropdownForm(false);
                                    break;
                                case 2: //WebSearch
                                    this.suggestString = "";
                                    this.textChanged = true;
                                    break;
                            }
                        }
                    }
                    break;

                case Keys.Enter:
                    e.Handled = true;
                    if (this.searchTextBox.TextBox.DropdownForm.Visible)
                    {
                        if (this.searchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndex >= 0)
                        {
                            IconListBoxItem item = (IconListBoxItem)this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Items[this.searchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndex];
                            if (item.Type == IconListBoxType.SearchEngine)
                            {
                                EngineInfo info = (EngineInfo)item.Data;
                                this.SetSearchEngine(info);
                                Program.Status = ProgramStatus.MainFormOpen;
                                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                                break;
                            }
                            else
                            {
                                if (item.Type == IconListBoxType.File || item.Type == IconListBoxType.Directory)
                                {
                                    int index = this.searchTextBox.TextBox.Text.LastIndexOf('\\');
                                    if (index == -1)
                                        this.searchTextBox.TextBox.Text = item.Name;
                                    else
                                        this.searchTextBox.TextBox.Text = this.searchTextBox.TextBox.Text.Substring(0, index + 1) + item.Name;
                                    this.searchTextBox.TextBox.SelectionStart = this.searchTextBox.TextBox.Text.Length;
                                    Program.Status = ProgramStatus.MainFormOpen;
                                    this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                                }
                                else
                                    this.searchTextBox.TextBox.Text = this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Text;
                                this.searchTextBox.TextBox.SelectionStart = this.Text.Length;
                                Program.Status = ProgramStatus.MainFormOpen;
                                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                            }
                        }
                    }

                    string command = this.SearchTextBox.TextBox.Text.Trim();
                    switch (this.SelectedEngineType)
                    {
                        case 0: //COMMAND
                            if (this.ExecCommand(command))
                            {
                                Program.AddHistoryList(command);
                            }
                            break;

                        case 1: //FILE_VIEW
                            this.ExecFile(command);
                            break;

                        case 2: //WEB_SEARCH
                            this.ExecSearch(command);
                            break;
                    }
                    return;

                case Keys.Escape:
                    if (this.SearchTextBox.TextBox.DropdownForm.Visible)
                    {
                        Program.Status = ProgramStatus.MainFormOpen;
                        this.SearchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                        Program.HideToolTip();
                        e.Handled = true;
                        return;
                    }
                    if (!"".Equals(searchTextBox.TextBox.Text))
                    {
                        this.SearchTextBox.TextBox.Text = "";
                        this.SearchTextBox.TextBox.SelectionStart = 0;
                        e.Handled = true;
                        return;
                    }
                    if(this.Visible)
                    {
                        this.DoVisibleChange(false);
                        Program.ForceForegroundWindow(this.beforeHWnd);
                    }
                    e.Handled = true;
                    return;

                default:
                    if (Program.Status == ProgramStatus.SelectingSearchEngine)
                    {
                        //検索エンジンリストが開いてる場合
                        string key = e.KeyChar + "";
                        IconListBoxItem item;
                        int index = this.SearchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndex + 1;
                        if (index >= this.SearchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Count)
                            index = 0;
                        for (int i = 0; i < this.SearchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Count; i++)
                        {
                            item = (IconListBoxItem)this.SearchTextBox.TextBox.DropdownForm.DropdownListBox.Items[index];
                            EngineInfo info = (EngineInfo)item.Data;
                            if (Program.Ime.StartsWith(item.Regex, key))
                            {
                                this.SearchTextBox.TextBox.DropdownForm.DropdownListBox.SelectedIndex = index;
                                break;
                            }
                            if (++index >= this.SearchTextBox.TextBox.DropdownForm.DropdownListBox.Items.Count)
                                index = 0;
                        }

                        e.Handled = true;
                    }
                    break;
            }
        }

        private void textBox_cmd_KeyDown(object sender, KeyEventArgs e)
        {
            if (Program.MainForm.Opacity != Program.FormOpacity)
                Program.MainForm.Opacity = Program.FormOpacity;

            switch (e.KeyCode)
            {
                case Keys.Up:
                    if ((Keys.Control & Control.ModifierKeys) == Keys.Control)
                    {
                        if (!this.SearchTextBox.TextBox.DropdownForm.Visible)
                        {
                            //検索エンジンの切替
                            this.SelectedEngineIndex--;
                            if (this.SelectedEngineIndex == -1)
                                this.SelectedEngineIndex = Program.DefaultEngineList.Count + Program.EngineList.Count - 1;
                            this.SetSearchEngine(Program.GetEngineInfo(this.SelectedEngineIndex));
                        }
                    }
                    else
                    {
                        if (this.SelectedEngineType == 0)
                        {
                            if (!this.SearchTextBox.TextBox.DropdownForm.Visible)
                            {
                                if (Program.CommandHistoryList.Count > 0)
                                {
                                    if (Program.CommandHistoryList.Count > Program.CommandHistoryIndex)
                                        Program.CommandHistoryIndex++;
                                    this.showDropdownSupport = false;
                                    this.SearchTextBox.TextBox.Text = Program.CommandHistoryList[Program.CommandHistoryIndex - 1];
                                    this.SearchTextBox.TextBox.SelectionStart = this.SearchTextBox.TextBox.Text.Length;
                                    this.showDropdownSupport = true;
                                }
                            }
                        }
                    }
                    break;

                case Keys.Down:
                    if ((Keys.Alt & Control.ModifierKeys) == Keys.Alt)
                    {
                        this.ShowEngineList();
                    }
                    else if ((Keys.Control & Control.ModifierKeys) == Keys.Control)
                    {
                        if (!this.SearchTextBox.TextBox.DropdownForm.Visible)
                        {
                            //検索エンジンの切替
                            this.SelectedEngineIndex++;
                            int count = Program.DefaultEngineList.Count + Program.EngineList.Count;
                            if (this.SelectedEngineIndex == count)
                                this.SelectedEngineIndex = 0;
                            this.SetSearchEngine(Program.GetEngineInfo(this.SelectedEngineIndex));
                        }
                    }
                    else
                    {
                        switch (this.SelectedEngineType)
                        {
                            case 0: //Passer
                                if (!this.SearchTextBox.TextBox.DropdownForm.Visible)
                                {
                                    if (Program.CommandHistoryIndex > 0)
                                    {
                                        Program.CommandHistoryIndex--;
                                        this.showDropdownSupport = false;
                                        if (Program.CommandHistoryIndex == 0)
                                            this.SearchTextBox.TextBox.Text = "";
                                        else
                                            this.SearchTextBox.TextBox.Text = Program.CommandHistoryList[Program.CommandHistoryIndex - 1];
                                        this.SearchTextBox.TextBox.SelectionStart = this.SearchTextBox.TextBox.Text.Length;
                                        this.showDropdownSupport = true;
                                    }
                                    else
                                    {
                                        this.ShowDropdownForm(false);
                                    }
                                }
                                break;

                            case 1: //FileSearch
                                if (!this.SearchTextBox.TextBox.DropdownForm.Visible)
                                {
                                    this.ShowDropdownForm(false);
                                }
                                break;
                            case 2:
                                if (!this.SearchTextBox.TextBox.DropdownForm.Visible)
                                {
                                    this.suggestString = "";
                                    this.textChanged = true;
                                }
                                break;
                        }
                    }
                    break;
            }
        }
        
        private void textBox_cmd_TextChanged(object sender, EventArgs e)
        {
            this.latestKeyTime = DateTime.Now.Ticks;
            this.searchTextBox.TextBox.ImeText = this.searchTextBox.TextBox.Text;
            if (!this.showDropdownSupport || !this.Visible)
                return;

            Size s = TextRenderer.MeasureText(this.searchTextBox.TextBox.Text, this.searchTextBox.TextBox.Font);
            if (s.Width > this.searchTextBox.TextBox.Width)
            {
                //MessageBox.Show("!!!");
            }

            if(!this.searchTextBox.TextBox.Complemented)
                this.ShowDropdownForm(true);
        }

        private void textBox_cmd_Complement(IconListBoxType type)
        {
        }

        private void textBox_cmd_ImeComposition(int type, string text)
        {
            if(!String.IsNullOrEmpty(this.searchTextBox.TextBox.Text))
            {
                string str = this.searchTextBox.TextBox.Text;
                text = str.Substring(0, this.searchTextBox.TextBox.SelectionStart)
                     + text
                     + str.Substring(this.searchTextBox.TextBox.SelectionStart);
            }
            this.searchTextBox.TextBox.ImeText = text;

            if (type == 0 && String.IsNullOrEmpty(text))
            {
                Program.Status = ProgramStatus.MainFormOpen;
                this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
                this.suggestString = "";
            }
            else
            {
                if ((type & Win32.GCS_RESULTSTR) != Win32.GCS_RESULTSTR)
                {
                    this.latestKeyTime = DateTime.Now.Ticks;
                    this.textChanged = true;
                }
            }
        }

        private void dropdownListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            Program.HideToolTip();
            if (!this.searchTextBox.TextBox.DropdownForm.Visible)
                return;

            IconListBox listBox = this.searchTextBox.TextBox.DropdownForm.DropdownListBox;
            if (listBox.SelectedIndex == -1)
                return;

            string text = listBox.Text;
            if (text.Equals(this.dropdownListBoxText))
                return;

            int lastIndex = listBox.ClientRectangle.Height / listBox.ItemHeight;
            if (listBox.TopIndex > listBox.SelectedIndex || (listBox.TopIndex + lastIndex) <= listBox.SelectedIndex)
                return;

            IconListBoxItem item = (IconListBoxItem)listBox.SelectedItem;
            if (item.Type == IconListBoxType.SearchEngineText)
                return;

            DropdownListForm dropdownForm = this.searchTextBox.TextBox.DropdownForm;

            Rectangle r = dropdownForm.Bounds;
            r.Y = dropdownForm.Location.Y + listBox.GetItemRectangle(listBox.SelectedIndex).Y;
            if (this.SelectedEngineType == 0 && (item.ToolTipText == null || item.ToolTipText.Length == 0))
            {
                if (Program.CommandDic.ContainsKey(text))
                {
                    CommandInfo info = Program.CommandDic[text];
                    text = info.Comment == null ? info.Name : info.Comment;
                }
            }
            else
            {
                text = item.ToolTipText;
            }
            Program.ShowToolTip(Util.CutText(text, 50, 10), r, 5000, false);
        }

        private void timer1_Tick(object sender, System.EventArgs e)
        {
            if (this.Visible)
            {
                if (this.Opacity + Program.FadeInSpeed < Program.FormOpacity)
                {
                    this.Opacity += Program.FadeInSpeed;
                    this.searchTextBox.TextBox.DropdownForm.Opacity = this.Opacity;
                    this.Update();
                }
                else
                {
                    this.Opacity = Program.FormOpacity;
                    this.searchTextBox.TextBox.DropdownForm.Opacity = this.Opacity;
                    this.timer1.Stop();
                }
            }
        }

        private void timer_keyRecoding_Tick(object sender, EventArgs e)
        {
            if (Program.Status == ProgramStatus.KeyRecoding && Program.Main_ShowBalloonWhileRecoding && Program.BallonWindowHandle != IntPtr.Zero)
                Win32.PostMessage(Program.BallonWindowHandle, Win32.WM_MOUSEMOVE, (IntPtr)0, (IntPtr)0);
        }

        private void timer_suggest_Tick(object sender, EventArgs e)
        {
            if (this.SelectedEngineType == 2 && this.textChanged)
            {
                string text = this.searchTextBox.TextBox.ImeText;
                if (String.IsNullOrEmpty(text))
                    return;

                if (DateTime.Now.Ticks > this.latestKeyTime + 000000 && !this.suggestString.Equals(text))
                {
                    this.textChanged = false;
                    this.SetEngineDropdownList(text);
                }
            }
        }

        private void toolTip_Popup(object sender, PopupEventArgs e)
        {
       
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                switch (Program.Status)
                {
                    case ProgramStatus.Loading:
                    case ProgramStatus.Waiting:
                    case ProgramStatus.MainFormOpen:
                        HotKeyProcessExecuter.OpenMainForm();
                        break;
                }
            }
        }

        private void DropdownListView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            this.searchTextBox.TextBox.Text = this.searchTextBox.TextBox.DropdownForm.DropdownListBox.Text;
            this.searchTextBox.TextBox.Select(this.searchTextBox.TextBox.Text.Length, 0);
            Program.Status = ProgramStatus.MainFormOpen;
            this.searchTextBox.TextBox.DropdownForm.DoVisibleChange(false);
        }

        private void 表示ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            switch (Program.Status)
            {
                case ProgramStatus.Loading:
                case ProgramStatus.Waiting:
                case ProgramStatus.MainFormOpen:
                    HotKeyProcessExecuter.OpenMainForm();
                    break;
            }
        }

        private void リスト設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!Program.SettingForm.Visible)
            {
                this.DoVisibleChange(false);
                Program.SettingForm.DoVisibleChange(true);
            }
        }

        private void バージョン情報ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (Program.Status == ProgramStatus.Waiting)
            {
                Program.Status = ProgramStatus.VersionFormOpen;
                VersionForm f = new VersionForm();
                f.ShowDialog();
                Program.Status = ProgramStatus.Waiting;
            }
        }

        private void 終了ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
            Application.Exit();
        }
    }
}
