/**
 * $Revision: 228 $
 * $Date: 2010-03-11 20:50:40 +0900 (木, 11 3 2010) $
*/

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Drawing;
using Lugens.Utils;
using Lugens.Components;

namespace Lugens.Passer
{

    public partial class MainForm 
    {
        delegate void HotkeyProcessExecute(List<HotKeyProcess> processList);
        /// <summary>
        /// キーボードフック
        /// </summary>
        /// <param name="nCode"></param>
        /// <param name="wParam"></param>
        /// <param name="lParam"></param>
        /// <param name="keyboardHookStruct"></param>
        /// <returns></returns>
        public int KeyboardHookHandler(int nCode, IntPtr wParam, IntPtr lParam, ref Win32.KeyboardHookStruct keyboardHookStruct)
        {
            HotkeyProcessExecute hotKeyProcessExecute = new HotkeyProcessExecute(HotKeyProcessExecuter.Execute);

            if (Program.Status == ProgramStatus.SendMessaging)
            {
/*                if (keyboardHookStruct.vkCode == 163)
                {
                    Debug.Write("hook_rcontrol:");
                    if ((int)wParam == Win32.WM_KEYDOWN || (int)wParam == Win32.WM_SYSKEYDOWN)
                    {
                        Debug.WriteLine("KEYDOWN");
                    }
                    if ((int)wParam == Win32.WM_KEYUP || (int)wParam == Win32.WM_SYSKEYUP)
                    {
                        Debug.WriteLine("KEYUP");
                    }
                }
*/
                if ((int)keyboardHookStruct.dwExtraInfo == 0)
                    return 1;
            }

            //定型文、スクリプトのホットキーを押した状態に変更する前に
            //キーが離された場合は無効にする
            if (Program.Status == ProgramStatus.SendMessageClosing)
            {
                if (HotKeyTextBox.IsControlKey(keyboardHookStruct.vkCode))
                {
                    int code = HotKeyTextBox.GetControlKeycode(keyboardHookStruct.vkCode);
                    if ((Program.closingKeycode & code) != 0 && (int)keyboardHookStruct.dwExtraInfo == 1)
                        return 1;
                    Program.closingKeycode |= code;
                }
            }

            int keycode = KeyboardHook.Keycode;
            switch (Program.Status)
            {
                case ProgramStatus.MainFormOpen:
                    if ((int)wParam == Win32.WM_KEYDOWN || (int)wParam == Win32.WM_SYSKEYDOWN)
                    {
                        if (Program.HotKeyProcessDic.ContainsKey(keycode) && Program.HotKeyProcessDic[keycode][0].ProcessType == HotKeyProcessType.OpenMainForm)
                        {
                            Win32.PostMessage(this.Handle, Program.WM_HOTKEY_EXECUTE, IntPtr.Zero, (IntPtr)keycode);
                            return 1;
                        }
                    }
                    break;

                case ProgramStatus.Loading:
                case ProgramStatus.Waiting:
                    if ((int)wParam == Win32.WM_KEYDOWN || (int)wParam == Win32.WM_SYSKEYDOWN)
                    {
                        if (Program.HotKeyProcessDic.ContainsKey(keycode))
                        {
                            Win32.PostMessage(this.Handle, Program.WM_HOTKEY_EXECUTE, IntPtr.Zero, (IntPtr)keycode);
                            return 1;
                        }
                    }
                    break;

                case ProgramStatus.KeyRecoding:
                    if ((int)wParam == Win32.WM_KEYDOWN || (int)wParam == Win32.WM_SYSKEYDOWN)
                    {
                        if (Program.HotKeyProcessDic.ContainsKey(keycode))
                        {
                            if (Program.HotKeyProcessDic[keycode][0].ProcessType == HotKeyProcessType.KeyRecord)
                            {
                                Win32.PostMessage(this.Handle, Program.WM_HOTKEY_EXECUTE, IntPtr.Zero, (IntPtr)keycode);
                                return 1;
                            }
                        }
                    }
                    break;

                case ProgramStatus.SentenceFormOpen:
                    if ((int)wParam == Win32.WM_KEYDOWN || (int)wParam == Win32.WM_SYSKEYDOWN)
                    {
                        if (keycode == 0 || keycode == (int)Keycode.PrintScreen || HotKeyTextBox.IsControlKey(keycode))
                            return keyboardHook.CallNextHook(nCode, wParam, lParam);

                        Win32.PostMessage(Program.SentenceForm.Handle, (int)wParam, (IntPtr)keycode, (IntPtr)lParam);
                        Win32.PostMessage(Program.SentenceForm.Handle, Program.WM_APP_KHOOK, wParam, (IntPtr)keycode);
                        return 1;
                    }
                    return keyboardHook.CallNextHook(nCode, wParam, lParam);

                case ProgramStatus.PopupFormOpen:
                    if ((int)wParam == Win32.WM_KEYDOWN || (int)wParam == Win32.WM_SYSKEYDOWN)
                    {
                        if (keycode == 0 || keycode == (int)Keycode.PrintScreen || HotKeyTextBox.IsControlKey(keycode))
                            return keyboardHook.CallNextHook(nCode, wParam, lParam);

                        Win32.PostMessage(Program.PopupForm.Handle, (int)wParam, (IntPtr)keycode, (IntPtr)lParam);
                        Win32.PostMessage(Program.PopupForm.Handle, Program.WM_APP_KHOOK, wParam, (IntPtr)keycode);
                        return 1;
                    }
                    return keyboardHook.CallNextHook(nCode, wParam, lParam);

                case ProgramStatus.HotKeyTextBoxFocus:
                    return keyboardHook.CallNextHook(nCode, wParam, lParam);
            }
            return keyboardHook.CallNextHook(nCode, wParam, lParam);
        }

        /// <summary>
        /// マウスフック
        /// </summary>
        /// <param name="nCode"></param>
        /// <param name="wParam"></param>
        /// <param name="lParam"></param>
        /// <param name="keyboardHookStruct"></param>
        /// <returns></returns>
        /// 
        /*        public int MouseHookHandler(int nCode, IntPtr wParam, IntPtr lParam, ref Win32.MouseHookStruct mouseHookStruct)
                {
                    Rectangle r;
                    switch (Program.Status)
                    {
                        case ProgramStatus.MainFormOpen:
                            switch ((int)wParam)
                            {
                                case 0x0201: //WM_LBUTTONDOWN
                                case 0x0204: //WM_RBUTTONDOWN
                                    r = Program.MainForm.Bounds;
                                    if (r.Left > mouseHookStruct.pt.X || r.Right < mouseHookStruct.pt.X || r.Top > mouseHookStruct.pt.Y || r.Bottom < mouseHookStruct.pt.Y)
                                    {
                                        if (Program.MainForm.DropdownForm.Visible)
                                        {
                                            r = Program.MainForm.DropdownForm.Bounds;
                                            if (r.Left > mouseHookStruct.pt.X || r.Right < mouseHookStruct.pt.X || r.Top > mouseHookStruct.pt.Y || r.Bottom < mouseHookStruct.pt.Y)
                                            {
                                                Program.MainForm.DoVisibleChange(false);
                                            }
                                        }
                                        else
                                        {
                                            Program.MainForm.DoVisibleChange(false);
                                        }
                                    }
                                    break;
                            }
                            break;
                        case ProgramStatus.SentenceFormOpen:
                            switch ((int)wParam)
                            {
                                case 0x0201: //WM_LBUTTONDOWN
                                case 0x0204: //WM_RBUTTONDOWN
                                    r = Program.SentenceForm.Bounds;
                                    if (r.Left > mouseHookStruct.pt.X || r.Right < mouseHookStruct.pt.X || r.Top > mouseHookStruct.pt.Y || r.Bottom < mouseHookStruct.pt.Y)
                                        Program.SentenceForm.DoVisibleChange(false);
                                    break;
                                //case 0x0202: //WM_LBUTTONUP
                                //    break;
                                //case 0x0205: //WM_RBUTTONUP
                                //    break;
                            }
                            break;
                    }
                    return mouseHook.CallNextHook(nCode, wParam, lParam);
                }*/
    }
}
