﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace Lugens.Passer
{
    public static class Settings
    {
        public const string PASSER_MAIN_FADEIN = "Passer.Main.FadeIn";
        public const string PASSER_MAIN_SHOWBALLOONWHILERECODING = "Passer.Main.ShowBalloonWhileRecoding";
        public const string PASSER_MAIN_SENDRECORDTOCLIPBOARD = "Passer.Main.SendRecordToClipboard";
        public const string PASSER_MAIN_MEMORIZE_ENGINE = "Passer.Main.MemorizeEngine";
        public const string PASSER_MAIN_ENGINE_INDEX = "Passer.Main.EngineIndex";

        public const string PASSER_HOTKEY_MAIN = "Passer.HotKey.Main";
        public const string PASSER_HOTKEY_CLIP = "Passer.HotKey.Clip";
        public const string PASSER_HOTKEY_CLIP_PASTE = "Passer.HotKey.ClipPaste";
        public const string PASSER_HOTKEY_KEY_RECORD = "Passer.HotKey.KeyRecord";
        public const string PASSER_HOTKEY_KEY_PLAY = "Passer.HotKey.KeyPlay";

        public const string PASSER_FORM_OPACITY = "Passer.Form.Opacity";
        public const string PASSER_FORM_MAIN_X = "Passer.Form.Main.X";
        public const string PASSER_FORM_MAIN_Y = "Passer.Form.Main.Y";
        public const string PASSER_FORM_MAIN_WIDTH = "Passer.Form.Main.Width";
        public const string PASSER_FORM_SENTENCE_WIDTH = "Passer.Form.Sentence.Width";
        public const string PASSER_FORM_SENTENCE_HEIGHT = "Passer.Form.Sentence.Height";

        public const string PASSER_SENTENCE_SELECTEDGROUP = "Passer.Sentence.SelectedGroup";
        public const string PASSER_SENTENCE_SHOWSCRIPTTOOLTIP = "Passer.Sentence.ShowScriptToolTip";

        public const string PASSER_COMMANDLIST_DIR = "Passer.CommandList.Dir";
        public const string PASSER_SENTENCELIST_DIR = "Passer.SentenceList.Dir";
        public const string PASSER_ENGINELIST_DIR = "Passer.EngineList.Dir";

        private static Dictionary<string, string> config = new Dictionary<string, string>();

        public static void Load(string file)
        {
            if (!File.Exists(Program.SettingFileName))
            {
                LoadDefault();
                return;
            }

            try
            {
                StreamReader reader = File.OpenText(file);
                string key;
                string line;
                string[] str;
                while ((line = reader.ReadLine()) != null)
                {
                    if (line.Trim().StartsWith("//"))
                        continue;

                    str = line.Split('=');
                    if (str.Length == 2)
                    {
                        key = str[0].Trim();
                        if (!config.ContainsKey(key))
                            config.Add(key, str[1].Trim());
                    }
                }
                reader.Close();

            }
            catch
            {
                LoadDefault();
            }
        }

        public static void LoadDefault()
        {
            config.Clear();
            config.Add(Settings.PASSER_HOTKEY_MAIN, "4128");
            config.Add(Settings.PASSER_HOTKEY_CLIP, "288");
            config.Add(Settings.PASSER_HOTKEY_CLIP_PASTE, "301");
            config.Add(Settings.PASSER_HOTKEY_KEY_RECORD, "368");
            config.Add(Settings.PASSER_HOTKEY_KEY_PLAY, "369");
            config.Add(Settings.PASSER_SENTENCE_SELECTEDGROUP, "0");
            config.Add(Settings.PASSER_FORM_OPACITY, "86");
            config.Add(Settings.PASSER_MAIN_ENGINE_INDEX, "0");

            config.Add(Settings.PASSER_MAIN_SHOWBALLOONWHILERECODING, "True");
            config.Add(Settings.PASSER_MAIN_SENDRECORDTOCLIPBOARD, "True");
        }

        public static bool Write(string file)
        {
            try
            {
                StreamWriter sw = new StreamWriter(file, false);
                foreach (string key in config.Keys)
                {
                    sw.WriteLine("{0} = {1}", key, config[key]);
                }
                sw.Close();
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static bool ContainsKey(string key)
        {
            return config.ContainsKey(key);
        }
        public static string Get(string key)
        {
            if (config.ContainsKey(key))
                return config[key];
            return null;
        }

        public static int GetInt(string key)
        {
            int ret;
            if (config.ContainsKey(key) && int.TryParse(config[key], out ret))
                return ret;
            return 0;

        }

        public static double GetDouble(string key)
        {
            double ret;
            if (config.ContainsKey(key) && double.TryParse(config[key], out ret))
                return ret;
            return 0.0D;

        }

        public static bool GetBool(string key)
        {
            bool ret;
            if (config.ContainsKey(key) && bool.TryParse(config[key], out ret))
                return ret;
            return false;
        }

        public static string GetString(string key)
        {
            return Get(key);
        }

        public static void Set(string key, string value)
        {
            if(config.ContainsKey(key))
                config.Remove(key);

            config.Add(key, value);
        }

        public static void Set(string key, char value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, int value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, bool value)
        {
            Set(key, value.ToString());
        }

    }
}
