﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using Lugens.Utils;

namespace Lugens.Passer
{
    public sealed class ShellLink : IDisposable
    {
        private Win32com.IShellLinkW shellLinkW = null;
        private StringBuilder targetPath = new StringBuilder(1024, 1024);

        public ShellLink(string ShortCutFile)
        {
            shellLinkW = (Win32com.IShellLinkW)(new Win32com.ShellLinkObject());
            ((Win32com.IPersistFile)shellLinkW).Load(ShortCutFile, 0);
            shellLinkW.Resolve(IntPtr.Zero, 2);
        }

        public void Dispose()
        {
            if(shellLinkW != null){
                Marshal.ReleaseComObject(shellLinkW);
            }
            shellLinkW = null;
        }

        public void Close()
        {
            this.Dispose();
        }


        public string TargetPath
        {
            get
            {
                Win32.WIN32_FIND_DATAW data = new Win32.WIN32_FIND_DATAW();
                shellLinkW.GetPath(targetPath, targetPath.Capacity, ref data, 0x0002);
                return targetPath.ToString();
            }
        }

        public string WorkingDirectory
        {
            get
            {
                shellLinkW.GetWorkingDirectory(targetPath, targetPath.Capacity);
                return targetPath.ToString();
            }
        }

        public string Arguments
        {
            get
            {
                shellLinkW.GetArguments(targetPath, targetPath.Capacity);
                return targetPath.ToString();
            }
        }

        public string Description
        {
            get
            {
                shellLinkW.GetDescription(targetPath, targetPath.Capacity);
                return targetPath.ToString();
            }
        }

    }
}
