﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Windows.Forms;

namespace Lugens.Utils
{
    public delegate int KeyboardHookEventProc(int nCode, IntPtr wParam, IntPtr lParam);
    public delegate int KeyboardHookEventHandler(int nCode, IntPtr wParam, IntPtr lParam, ref Win32.KeyboardHookStruct keyboardHookStruct);

    public class KeyboardHook
    {

        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        private static extern IntPtr SetWindowsHookEx(int idHook, KeyboardHookEventProc lpfn, IntPtr hInstance, int threadId);

        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        private static extern bool UnhookWindowsHookEx(IntPtr idHook);

        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        private static extern int CallNextHookEx(IntPtr idHook, int nCode, IntPtr wParam, IntPtr lParam);

        [DllImport("kernel32.dll", SetLastError = true)]
        private static extern IntPtr GetModuleHandle(string lpModuleName);

        private const int WH_KEYBOARD_LL = 13;

        private KeyboardHookEventProc keyboardHookEventProc;

        private KeyboardHookEventHandler handler;

        private IntPtr hHook = IntPtr.Zero;

        private static bool Recoding = false;

        private static List<int> RecordKeyList = new List<int>();

        public static int[] KeyState = new int[256];

        private static int keycode;
        public static int Keycode
        {
            get { return KeyboardHook.keycode; }
        }

        public KeyboardHook(KeyboardHookEventHandler handler)
        {
            this.handler = handler;
            this.keyboardHookEventProc = new KeyboardHookEventProc(KeyboardHookProc);
        }

        /// <summary>
        /// キーボードフック開始
        /// </summary>
        public void Start()
        {
            hHook = SetWindowsHookEx(WH_KEYBOARD_LL, this.keyboardHookEventProc, GetModuleHandle(Process.GetCurrentProcess().MainModule.ModuleName), 0);
        }

        /// <summary>
        /// キーボードフック停止
        /// </summary>
        public void Stop()
        {
            if (hHook != IntPtr.Zero)
            {
                UnhookWindowsHookEx(hHook);
                hHook = IntPtr.Zero;
            }
        }

        public int CallNextHook(int nCode, IntPtr wParam, IntPtr lParam)
        {
            return CallNextHookEx(hHook, nCode, wParam, lParam);
        }

        /// <summary>
        /// キーコードの生成
        /// </summary>
        /// <param name="code"></param>
        private static void SetKeycode(int code)
        {
            KeyboardHook.keycode = 0;
            if (Win32.GetKeyState((int)Keys.LWin) < 0)
                KeyboardHook.keycode |= 0xC000;
            if (Win32.GetKeyState((int)Keys.LControlKey) < 0)
                KeyboardHook.keycode |= 0x2000;
            if (Win32.GetKeyState((int)Keys.RControlKey) < 0)
                KeyboardHook.keycode |= 0x1000;
            if (Win32.GetKeyState((int)Keys.LMenu) < 0)
                KeyboardHook.keycode |= 0x0800;
            if (Win32.GetKeyState((int)Keys.RMenu) < 0)
                KeyboardHook.keycode |= 0x0400;
            if (Win32.GetKeyState((int)Keys.LShiftKey) < 0)
                KeyboardHook.keycode |= 0x0200;
            if (Win32.GetKeyState((int)Keys.RShiftKey) < 0)
                KeyboardHook.keycode |= 0x0100;

            switch (code)
            {
                case (int)Keys.ShiftKey:
                case (int)Keys.LShiftKey:
                case (int)Keys.RShiftKey:
                case (int)Keys.ControlKey:
                case (int)Keys.LControlKey:
                case (int)Keys.RControlKey:
                case (int)Keys.Menu:
                case (int)Keys.LMenu:
                case (int)Keys.RMenu:
                case (int)Keys.LWin:
                    break;

                default:
                    KeyboardHook.keycode |= code;
                    break;
            }
        }

        public static void RecodingStart()
        {
            KeyboardHook.RecordKeyList.Clear();
            KeyboardHook.Recoding = true;
        }

        public static void RecodingStop(int keycode)
        {
            KeyboardHook.Recoding = false;
            keycode &= 0xFF00;
            foreach (int key in KeyboardHook.RecordKeyList)
            {
                if (keycode != 0)
                {
                    switch(key)
                    {
                        case 162:
                            keycode = keycode & 0xDFFF;
                            break;
                        case 163:
                            keycode = keycode & 0xEFFF;
                            break;
                        case 164:
                            keycode = keycode & 0xF7FFF;
                            break;
                        case 165:
                            keycode = keycode & 0xFBFFF;
                            break;
                        case 160:
                            keycode = keycode & 0xFDFF;
                            break;
                        case 161:
                            keycode = keycode & 0xFEFF;
                            break;
                    }
                    continue;
                }
                KeyboardHook.KeyState[key & 0xFF] = (key >> 16);
            }
        }

        /// <summary>
        /// キーボードフックプロシージャ
        /// </summary>
        /// <param name="nCode"></param>
        /// <param name="wParam"></param>
        /// <param name="lParam"></param>
        /// <returns></returns>
        private int KeyboardHookProc(int nCode, IntPtr wParam, IntPtr lParam)
        {
            if (nCode < 0)
                return CallNextHookEx(hHook, nCode, wParam, lParam);
            
            Win32.KeyboardHookStruct keyboardHookStruct = (Win32.KeyboardHookStruct)Marshal.PtrToStructure(lParam, typeof(Win32.KeyboardHookStruct));

            switch ((int)wParam)
            {
                case 0x0101: //WM_KEYUP
                case 0x0105: //WM_SYSKEYUP
                    if (keyboardHookStruct.vkCode < 256)
                    {
                        if (KeyboardHook.Recoding && keyboardHookStruct.vkCode == 91 || (keyboardHookStruct.vkCode >= 160 & keyboardHookStruct.vkCode <= 165))
                            KeyboardHook.RecordKeyList.Add(keyboardHookStruct.vkCode);
                        KeyboardHook.KeyState[keyboardHookStruct.vkCode] = 0;
                        KeyboardHook.SetKeycode(keyboardHookStruct.vkCode);
                    }
                    break;

                case 0x0100: //WM_KEYDOWN
                case 0x0104: //WM_SYSKEYDOWN
                    if (keyboardHookStruct.vkCode < 256)
                    {
                        if (KeyboardHook.Recoding && keyboardHookStruct.vkCode == 91 || (keyboardHookStruct.vkCode >= 160 & keyboardHookStruct.vkCode <= 165))
                            KeyboardHook.RecordKeyList.Add(keyboardHookStruct.vkCode | 0x100);
                        KeyboardHook.KeyState[keyboardHookStruct.vkCode] = 1;
                        KeyboardHook.SetKeycode(keyboardHookStruct.vkCode);
                    }
                    break;
            }
            return this.handler(nCode, wParam, lParam, ref keyboardHookStruct);
        }
    }
}
