﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.VisualBasic;

namespace Lugens.Passer.Macro.Text
{
    public class ToLowerMacro : IMacro
    {
        
        event MacroEventHandler macroCompletedEvent;

        event MacroEventHandler IMacro.OnMacroCompleted
        {
            add { macroCompletedEvent += value; }
            remove { macroCompletedEvent -= value; }
        }

        public string Id()
        {
            return "Lugens.Passer.Macro.Text.ToLower";
        }

        public MacroType Type()
        {
            return MacroType.CutOutText;
        }

        public bool Init()
        {
            return true;
        }

        public string Name()
        {
            return "ToLower";
        }

        public string Summary()
        {
            return "アルファベットの大文字を小文字に変換します";
        }

        public string Description()
        {
            return new StringBuilder()
                .Append("引数：なし").Append(Environment.NewLine)
                .Append(Environment.NewLine)
                .Append("ＡＢＣABC　⇒　ａｂｃabc").ToString();
        }

        public bool Test()
        {
            return true;
        }

        public void ExecuteAsync(string str, string[] args)
        {
            string result = "";
            if (!String.IsNullOrEmpty(str))
                result = Strings.StrConv(str, VbStrConv.Lowercase, 0);

            if (macroCompletedEvent != null)
                macroCompletedEvent(result);
        }

    }
}
