﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.VisualBasic;

namespace Lugens.Passer.Macro.Text
{
    public class ToZenkakuMacro : IMacro
    {

        event MacroEventHandler macroCompletedEvent;

        event MacroEventHandler IMacro.OnMacroCompleted
        {
            add { macroCompletedEvent += value; }
            remove { macroCompletedEvent -= value; }
        }

        public string Id()
        {
            return "Lugens.Passer.Macro.Text.ToZenkaku";
        }

        public MacroType Type()
        {
            return MacroType.CutOutText;
        }

        public bool Init()
        {
            return true;
        }

        public string Name()
        {
            return "ToZenkaku";
        }

        public string Summary()
        {
            return "半角文字を全角に変換します";
        }

        public string Description()
        {
            return new StringBuilder()
                .Append("引数：なし").Append(Environment.NewLine)
                .Append(Environment.NewLine)
                .Append("ｱｲｳABCabc#$%　⇒　アイウＡＢＣａｂｃ＃＄％").ToString();
        }

        public bool Test()
        {
            return true;
        }

        public void ExecuteAsync(string str, string[] args)
        {
            string result = "";
            if (!String.IsNullOrEmpty(str))
                result = Strings.StrConv(str, VbStrConv.Wide, 0);

            if (macroCompletedEvent != null)
                macroCompletedEvent(result);
        }


    }
}
