﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Net;
using Lugens.Components;
using Lugens.Passer.Macro;
using Lugens.Utils;

namespace Lugens.Passer
{
    public partial class AddEngineForm : Form
    {
        private string id;
        private bool iconChanged;

        public AddEngineForm()
        {
            InitializeComponent();
            this.Init();
        }

        public void Init()
        {
            this.textBox_name.Text = "";
            this.textBox_searchUrl.Text = "";
            this.textBox_display.Text = "";
            this.textBox_shortcut.HotKeycode = 0;
            this.button_icon.Image = null;
            this.comboBox_encoding.Text = "UTF-8";

            this.textBox_shortcut.AcceptKeys = SettingForm.AcceptKeyList;
            this.textBox_shortcut.GotFocus += SettingForm.hotKeyTextBox_GotFocus;
            this.textBox_shortcut.LostFocus += SettingForm.hotKeyTextBox_LostFocus;

            this.id = Program.GetEngineID();
            this.iconChanged = false;
        }

        private void textBox_shortcut_TextChanged(object sender, EventArgs e)
        {
    /*        if (this.textBox_shortcut.HotKeycode != 0)
            {
                foreach (EngineInfo info in Program.DefaultEngineDic.Values)
                {
                    if (info.Shortcut == this.textBox_shortcut.HotKeycode)
                    {
                        this.label_shortcut_duplicate.Visible = true;
                        this.button_ok.Enabled = false;
                        return;
                    }
                }
                foreach (EngineInfo info in Program.SettingForm.EngineDicTmp.Values)
                {
                    if(info.Shortcut == this.textBox_shortcut.HotKeycode)
                    {
                        this.label_shortcut_duplicate.Visible = true;
                        this.button_ok.Enabled = false;
                        return;
                    }
                }
            }
            this.label_shortcut_duplicate.Visible = false;
            this.button_ok.Enabled = true;*/
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            EngineInfo info = new EngineInfo();
            info.Id = this.id;
            info.Name = this.textBox_name.Text;
            info.Url = this.textBox_url.Text;
            info.SearchUrl = this.textBox_searchUrl.Text;
            info.SuggestUrl = this.textBox_suggestUrl.Text;
            info.Shortcut = this.textBox_shortcut.HotKeycode;
            info.Encoding = this.comboBox_encoding.Text;
            info.Display = this.textBox_display.Text;
            info.IconChanged = this.iconChanged;

            if (Program.SettingForm.EngineListTmp.Contains(this.textBox_name.Text) && !Program.SettingForm.EngineDicTmp[this.textBox_name.Text].Removed)
            {
                //重複エラー
                MessageBox.Show("すでに登録されている名前です");
                return;
            }

            if (String.IsNullOrEmpty(info.Url))
            {
                MessageBox.Show("URLを入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!info.Url.StartsWith("http://") && !info.Url.StartsWith("https://"))
            {
                MessageBox.Show("URLを正しく入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!String.IsNullOrEmpty(info.SearchUrl) && !info.SearchUrl.StartsWith("http://") && !info.SearchUrl.StartsWith("https://"))
            {
                MessageBox.Show("検索URLを正しく入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!String.IsNullOrEmpty(info.SuggestUrl) && !info.SuggestUrl.StartsWith("http://") && !info.SuggestUrl.StartsWith("https://"))
            {
                MessageBox.Show("サジェストURLを正しく入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (this.iconChanged)
            {
                if (!Directory.Exists(Program.EngineIconTmpDir))
                    Directory.CreateDirectory(Program.EngineIconTmpDir);

                string iconFile = Program.EngineIconTmpDir + "\\" + this.id;
                this.button_icon.Image.Save(iconFile, System.Drawing.Imaging.ImageFormat.Png);
                Bitmap bitmap = new Bitmap(iconFile);
                info.IconImage = new Bitmap(bitmap);
                bitmap.Dispose();
            }
            else
            {
                info.IconImage = Properties.Resources.DefaultEngine.ToBitmap();
            }

            Program.SettingForm.EngineListTmp.Add(info.Name);
            Program.SettingForm.EngineDicTmp.Add(info.Name, info);
            Program.SettingForm.ReadEngineList(true);
            Program.SettingForm.RequestEngineListViewSelect(info.Name);
            this.Visible = false;
        }

        private void button_icon_Click(object sender, EventArgs e)
        {
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                string file = openFileDialog.FileName;
                if (File.Exists(file))
                {
                    try
                    {
                        Win32.SHFILEINFO shinfo = new Win32.SHFILEINFO();
                        Win32.SHGetFileInfo(file, 0, ref shinfo, Marshal.SizeOf(shinfo), Win32.SHGFI_ICON | Win32.SHGFI_SMALLICON);
                        Icon icon = Icon.FromHandle(shinfo.hIcon);
                        this.button_icon.Image = icon.ToBitmap();
                        icon.Dispose();
                        this.iconChanged = true;
                    }
                    catch (Exception ex) { ex.ToString(); }
                }
            }
        }

        private void textBox_name_TextChanged(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(this.textBox_name.Text))
                return;

            if (this.textBox_name.Text[0] == '@')
            {
                this.label_engine_duplicate.Text = "※先頭に@は使用できません";
                this.label_engine_duplicate.Visible = true;
                this.button_ok.Enabled = false;
                return;
            }

            if (Program.SettingForm.EngineListTmp.Contains(this.textBox_name.Text) && !Program.SettingForm.EngineDicTmp[this.textBox_name.Text].Removed)
            {
                this.label_engine_duplicate.Text = "※重複しています";
                this.label_engine_duplicate.Visible = true;
                this.button_ok.Enabled = false;
            }
            else
            {
                this.label_engine_duplicate.Visible = false;
                this.button_ok.Enabled = true;
            }
        }

        private void button_icon_get_Click(object sender, EventArgs e)
        {
            string str = this.textBox_url.Text;
            if(String.IsNullOrEmpty(str))
            {
                MessageBox.Show("URLを入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!str.StartsWith("http://") && !str.StartsWith("https://"))
            {
                MessageBox.Show("URLを正しく入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            int n = str.IndexOf("//");
            if(str.LastIndexOf('/') == n + 1)
                str += "/favicon.ico";
            else
                str = str.Substring(0, str.IndexOf('/', n + 2)) + "/favicon.ico";

            WebClient wc = new WebClient();
            try
            {
                Program.CreateEngineIconTmpDir();
                string file = Program.EngineIconTmpDir + "\\" + this.id;
                wc.DownloadFile(str, file);
                Bitmap bitmap = new Bitmap(file);
                this.button_icon.Image = new Bitmap(bitmap);
                bitmap.Dispose();
                this.iconChanged = true;
            }
            catch
            {
                MessageBox.Show("ダウンロードエラー");
            }
        }

        private void button_cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }


    }
}
