﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Net;
using Lugens.Components;
using Lugens.Passer.Macro;
using Lugens.Utils;

namespace Lugens.Passer
{
    public partial class EditEngineForm : Form
    {
        private string id;
        private string name;
        private int shortcut;
        private bool iconChanged;

        public EditEngineForm(EngineInfo info)
        {
            InitializeComponent();
            this.Init(info);
        }

        public void Init(EngineInfo info)
        {
            this.id = info.Id;
            this.name = info.Name;
            this.shortcut = info.Shortcut;
            this.textBox_name.Text = info.Name;
            this.textBox_url.Text = info.Url;
            this.textBox_searchUrl.Text = info.SearchUrl;
            this.textBox_suggestUrl.Text = info.SuggestUrl;
            this.textBox_display.Text = info.Display;
            this.textBox_shortcut.HotKeycode = info.Shortcut;
            this.button_icon.Image = info.IconImage;
            this.comboBox_encoding.Text = info.Encoding;

            this.textBox_shortcut.AcceptKeys = SettingForm.AcceptKeyList;
            this.textBox_shortcut.GotFocus += SettingForm.hotKeyTextBox_GotFocus;
            this.textBox_shortcut.LostFocus += SettingForm.hotKeyTextBox_LostFocus;

            this.iconChanged = false;
        }

        private void textBox_shortcut_TextChanged(object sender, EventArgs e)
        {
/*            if (this.textBox_shortcut.HotKeycode != 0)
            {
                foreach (EngineInfo info in Program.DefaultEngineDic.Values)
                {
                    if (info.Shortcut == this.textBox_shortcut.HotKeycode && info.Shortcut != this.shortcut)
                    {
                        this.label_shortcut_duplicate.Visible = true;
                        this.button_ok.Enabled = false;
                        return;
                    }
                }
                foreach (EngineInfo info in Program.SettingForm.EngineDicTmp.Values)
                {
                    if (info.Shortcut == this.textBox_shortcut.HotKeycode && info.Shortcut != this.shortcut)
                    {
                        this.label_shortcut_duplicate.Visible = true;
                        this.button_ok.Enabled = false;
                        return;
                    }
                }
            }
            this.label_shortcut_duplicate.Visible = false;
            this.button_ok.Enabled = true;*/
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            EngineInfo info = new EngineInfo();
            info.Id = this.id;
            info.Name = this.textBox_name.Text;
            info.Url = this.textBox_url.Text;
            info.SearchUrl = this.textBox_searchUrl.Text;
            info.SuggestUrl = this.textBox_suggestUrl.Text;
            info.Shortcut = this.textBox_shortcut.HotKeycode;
            info.Encoding = this.comboBox_encoding.Text;
            info.Display = this.textBox_display.Text;
            info.IconChanged = this.iconChanged;

            if (String.IsNullOrEmpty(info.Url))
            {
                MessageBox.Show("URLを入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!info.Url.StartsWith("http://") && !info.Url.StartsWith("https://"))
            {
                MessageBox.Show("URLを正しく入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!String.IsNullOrEmpty(info.SearchUrl) && !info.SearchUrl.StartsWith("http://") && !info.SearchUrl.StartsWith("https://"))
            {
                MessageBox.Show("検索URLを正しく入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!String.IsNullOrEmpty(info.SuggestUrl) && !info.SuggestUrl.StartsWith("http://") && !info.SuggestUrl.StartsWith("https://"))
            {
                MessageBox.Show("サジェストURLを正しく入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (this.iconChanged)
            {
                if (!Directory.Exists(Program.EngineIconTmpDir))
                    Directory.CreateDirectory(Program.EngineIconTmpDir);

                string iconFile = Program.EngineIconTmpDir + "\\" + this.id;
                this.button_icon.Image.Save(iconFile, System.Drawing.Imaging.ImageFormat.Png);
                Bitmap bitmap = new Bitmap(iconFile);
                info.IconImage = new Bitmap(bitmap);
                bitmap.Dispose();
            }
            else
            {
                info.IconImage = this.button_icon.Image;
            }

            int index = Program.SettingForm.EngineListTmp.IndexOf(this.name);
            Program.SettingForm.EngineListTmp[index] = this.textBox_name.Text;
            Program.SettingForm.EngineDicTmp.Remove(this.name);
            Program.SettingForm.EngineDicTmp.Add(info.Name, info);
            Program.SettingForm.ReadEngineList(true);
            Program.SettingForm.RequestEngineListViewSelect(info.Name);
            this.Visible = false;
        }

        private void button_icon_Click(object sender, EventArgs e)
        {
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                string file = openFileDialog.FileName;
                if (File.Exists(file))
                {
                    try
                    {
                        Win32.SHFILEINFO shinfo = new Win32.SHFILEINFO();
                        Win32.SHGetFileInfo(file, 0, ref shinfo, Marshal.SizeOf(shinfo), Win32.SHGFI_ICON | Win32.SHGFI_SMALLICON);
                        Icon icon = Icon.FromHandle(shinfo.hIcon);
                        this.button_icon.Image = icon.ToBitmap();
                        icon.Dispose();
                        this.iconChanged = true;
                    }
                    catch (Exception ex) { ex.ToString(); }
                }
            }
        }

        private void textBox_name_TextChanged(object sender, EventArgs e)
        {
            if (!this.name.Equals(this.textBox_name.Text) && Program.SettingForm.EngineListTmp.Contains(this.textBox_name.Text))
            {
                this.label_engine_duplicate.Visible = true;
                this.button_ok.Enabled = false;
            }
            else
            {
                this.label_engine_duplicate.Visible = false;
                this.button_ok.Enabled = true;
            }
        }

        private void button_icon_get_Click(object sender, EventArgs e)
        {
            string str = this.textBox_url.Text;
            if(String.IsNullOrEmpty(str))
            {
                MessageBox.Show("URLを入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (!str.StartsWith("http://") && !str.StartsWith("https://"))
            {
                MessageBox.Show("URLを正しく入力してください", "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            int n = str.IndexOf("//");
            if(str.LastIndexOf('/') == n + 1)
                str += "/favicon.ico";
            else
                str = str.Substring(0, str.IndexOf('/', n + 2)) + "/favicon.ico";

            WebClient wc = new WebClient();
            string file = Program.EngineIconTmpDir + "\\" + this.id;
            try
            {
                Program.CreateEngineIconTmpDir();
                wc.DownloadFile(str, file);
            }
            catch
            {
                MessageBox.Show("ダウンロードエラー");
                return;
            }

            try
            {
                Bitmap bitmap = new Bitmap(file);
                this.button_icon.Image = new Bitmap(bitmap);
                bitmap.Dispose();
                this.iconChanged = true;
                return;
            }
            catch 
            {
                MessageBox.Show("画像の変換に失敗しました。");
                return;
            }

        }

        private void button_cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }


    }
}
