﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using Lugens.Utils;
using System.Runtime.InteropServices;

namespace Lugens.Passer
{
    public partial class ToolTipForm : Form
    {
        private const int SWP_NOSIZE = 1;
        private const int SWP_NOMOVE = 2;
        private const int SWP_NOACTIVATE = 0x10;
        private const int HWND_TOPMOST = -1;
        private const int GWL_EXSTYLE = -20;

        private Point drawPoint = new Point(0, 0);

        //private Size calcSize;

        private int visibledTime = 0;
        private int displayedTime = 0;

        /// <summary>
        /// 表示されて可視状態かどうか
        /// </summary>
        private bool displayed = false;

        /// <summary>
        /// 表示時間(ms)
        /// </summary>
        private int duration = 5000;
        public int Duration
        {
            get { return duration; }
            set { duration = value; }
        }
        

        /// <summary>
        /// 表示までのディレイ時間(ms)
        /// </summary>
        private int startDelay = 200;
        public int StartDelay
        {
            get { return startDelay; }
            set { startDelay = value; }
        }

        private int borderSpace;
        public int BorderSpace
        {
            get { return borderSpace; }
            set
            {
                borderSpace = value;
                drawPoint.X = drawPoint.Y = value;
            }
        }
        private bool alive = true;
        public bool Alive
        {
            get { return this.alive; }
        }

        public ToolTipForm() : this(false)
        {
        }

        public ToolTipForm(bool top)
        {
            this.TopMost = top;
            InitializeComponent();
            this.Paint += this.OnPaint;
            this.BorderSpace = 3;
        }

        protected override void CreateHandle()
        {
            base.CreateHandle();
            Win32.SetWindowPos(new HandleRef(this, this.Handle), (IntPtr)HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);
        }

        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams cp = base.CreateParams;
                cp.ClassStyle |= 0x00020000;
                cp.ExStyle |= Win32.WS_EX_NOACTIVATE;
                return cp;
            }
        }

        protected override bool ShowWithoutActivation
        {
            get { return true; }
        }

        private void OnPaint(object sender, PaintEventArgs e)
        {
            
            TextRenderer.DrawText(e.Graphics, this.Text, this.Font, this.drawPoint, this.ForeColor, TextFormatFlags.NoPrefix);
            using(Pen pen = new Pen(this.ForeColor, 1.0F)){
                e.Graphics.DrawRectangle(pen, 0, 0, this.ClientSize.Width - 1, this.ClientSize.Height - 1);
            }
        }

        public override string Text
        {
            get { return base.Text; }
            set
            {
                int borderSpace = this.borderSpace << 1;
                base.Text = value.Replace("\t", "    ");
                Size size = TextRenderer.MeasureText(base.Text, this.Font);
                size.Width += borderSpace;
                size.Height += borderSpace;
                this.Size = size;
            }
        }

        public void Show(Point p, int duration, bool fadeIn)
        {
            if(fadeIn)
                this.Opacity = 0D;
            this.displayed = false;
            this.duration = duration;
            this.Location = p;
            this.visibledTime = System.Environment.TickCount;
            this.timer1.Enabled = true;
            //Size size = this.Size;
            //this.Show();
            //this.Size = size;
            this.Invalidate();
        }

        public void Show(string text, Point p, int duration, bool fadeIn)
        {
            this.Text = text;
            this.Show(p, duration, fadeIn);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            int tickCount = System.Environment.TickCount;
            if (tickCount > this.visibledTime + this.startDelay)
            {
                if (!displayed){
                    this.displayedTime = tickCount;
                    this.displayed = true;
                    Size size = this.Size;
                    this.Show();
                    this.Size = size;
                }

                if (tickCount - this.displayedTime > this.duration)
                {
                    this.Opacity -= Program.FadeInSpeed;
                    if (this.Opacity <= 0D)
                    {
                        this.timer1.Enabled = false;
                        this.Close();
                    }
                }
                else
                {
                    if (this.Opacity + Program.FadeInSpeed < Program.FormOpacity)
                        this.Opacity += Program.FadeInSpeed;
                    else
                        this.Opacity = Program.FormOpacity;
                }

            }
        }

        private void ToolTipForm_Resize(object sender, EventArgs e)
        {
            this.Invalidate();
        }

        private void ToolTipForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            this.alive = false;
        }

    }
}
