﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace Lugens.Utils
{
    public static class Util
    {
        public static string[] Split(string str)
        {
            return Split(str, ' ', '"');
        }

        public static string[] Split(string str, char separate, char around)
        {
            List<string> list = new List<string>();
            if (str == null || "".Equals(str))
                return new string[1] { "" };

            int i = 0;
            int ei = str.Length - 1;
            char c1;
            char c2;
            bool isAround = false;
            StringBuilder sb = new StringBuilder();

            for (; i < ei; i++)
            {
                c1 = str[i];

                if (c1 == '\\')
                {
                    c2 = str[i + 1];
                    if (c2 != around)
                        sb.Append(c1);
                    sb.Append(c2);
                    i++;
                    continue;
                }

                if (c1 == separate && !isAround)
                {
                    list.Add(sb.ToString());
                    sb.Remove(0, sb.Length);
                    continue;
                }

                if (c1 == around)
                {
                    isAround = !isAround;
                    continue;
                }

                sb.Append(c1);
            }

            c1 = str[i];
            if (c1 != separate && c1 != around)
                sb.Append(c1);
            list.Add(sb.ToString());
            return list.ToArray();
        }

        public static string CutText(string str, int length)
        {
            if (str == null || str.Length == 0)
                return str;

            StringBuilder sb = new StringBuilder();
            string[] lines = str.Split('\n');
            for (int i = 0; i < lines.Length; i++)
            {
                if (lines[i].Length > length)
                    sb.Append(lines[i].Substring(0, length)).Append("...\n");
                else
                    sb.Append(lines[i]).Append("\n");
            }
            return sb.ToString(0, sb.Length - 1);
        }

        public static string CutText(string str, int length, int line)
        {
            if (str == null || str.Length == 0)
                return str;

            StringBuilder sb = new StringBuilder();
            string[] lines = str.Split('\n');
            for (int i = 0; i < lines.Length; i++)
            {
                if (lines[i].Length > length)
                    sb.Append(lines[i].Substring(0, length)).Append("...\n");
                else
                    sb.Append(lines[i]).Append("\n");
                if (--line <= 0)
                    break;
            }
            return sb.ToString(0, sb.Length - 1);
        }

        public static string TrimCutText(string str, int length)
        {
            if (str == null || str.Length == 0)
                return str;

            StringBuilder sb = new StringBuilder();
            string[] lines = str.Split('\n');
            for (int i = 0; i < lines.Length; i++)
            {
                sb.Append(lines[i].Trim()).Append(" ");
                if (sb.Length > length)
                    break;
            }
            if (sb.Length > length)
                return sb.ToString(0, length);
            else
                return sb.ToString();
        }

        public enum Locate { Right, Down }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="r">表示位置のウィンドウ</param>
        /// <param name="window">表示するウィンドウサイズ</param>
        /// <param name="locate"></param>
        /// <returns></returns>
        public static Point CalcWindowLocate(Rectangle r, Size size, Locate locate)
        {
            Point p = r.Location;

            Rectangle workingArea = Screen.FromPoint(p).WorkingArea;

            switch (locate)
            {
                case Locate.Right:
                    //X座標を求める
                    if (r.Right + size.Width > (workingArea.X + workingArea.Width))
                    {
                        //右に収まらないので、幅がある方に表示
                        if (System.Math.Abs(r.Left) > System.Math.Abs(workingArea.X + workingArea.Width - r.Right))
                            p.X = r.Left - size.Width;
                        else
                            p.X = r.Right;
                    }
                    else
                        p.X = r.Right;

                    //Y座標を決める
                    if (r.Top + size.Height > workingArea.Height)
                        p.Y = workingArea.Height - size.Height;
                    else
                        p.Y = r.Top;
                    break;

                case Locate.Down:
                    //X座標を決める
                    if (r.X + size.Width > (workingArea.X + workingArea.Width))
                        p.X = workingArea.X + workingArea.Width - (size.Width + 1);
                    else if (workingArea.X > r.X)
                        p.X = workingArea.X;
                    else
                        p.X = r.Left;

                    //Y座標を決める
                    if (r.Y > workingArea.Height)
                        p.Y = workingArea.Height - (size.Height + 1);
                    else if (p.Y + size.Height + (r.Height - r.Y) > workingArea.Height)
                        p.Y = r.Top - size.Height;
                    else
                        p.Y = r.Height;
                    break;

            }
            return p;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="r">表示位置のウィンドウ</param>
        /// <param name="window">表示するウィンドウ</param>
        /// <param name="locate"></param>
        /// <returns></returns>
        /*        public static Point CalcWindowLocate(Rectangle r, Rectangle window, Locate locate)
                {
                    Point p = r.Location;

                    Rectangle workingArea = Screen.FromPoint(p).WorkingArea;

                    switch (locate)
                    {
                        case Locate.Left:
                            break;

                        case Locate.Down:
                            //X座標を決める
                            if (r.X + window.Size.Width > (workingArea.X + workingArea.Width))
                                p.X = workingArea.X + workingArea.Width - (window.Size.Width + 1);
                            else if (workingArea.X > r.X)
                                p.X = workingArea.X;
                            else
                                p.X = r.Left;

                            //Y座標を決める
                            if (r.Y > workingArea.Height)
                                p.Y = workingArea.Height - (window.Size.Height + 1);
                            else if (p.Y + window.Size.Height + (r.Height - r.Y) > workingArea.Height)
                                p.Y = r.Top - window.Size.Height;
                            else
                                p.Y = r.Height;
                            break;

                    }
                    return p;
                }*/
    }
}
