/**
 * $Revision: 12 $
 * $Date: 2006-08-17 16:26:11 +0900 (木, 17 8 2006) $
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Diagnostics;
using Lugens.Utils;
using System.IO;

namespace Lugens.Components
{
    public partial class AutoCompleteTextBox : TextBox, IComparer<IconListBoxItem>
    {
        [DllImport("Imm32.dll")]
        private static extern IntPtr ImmGetContext(IntPtr hWnd);

        [DllImport("Imm32.dll")]
        private static extern int ImmGetCompositionString(
            IntPtr hIMC, int dwIndex, byte[] buf, int dwBufLen);

        [DllImport("Imm32.dll")]
        private static extern bool ImmReleaseContext(IntPtr hWnd, IntPtr hIMC);

        // IME入力中文字取得に使用する値(ひらがな)
        private const int GCS_COMPSTR = 0x0008;

        /// <summary>
        /// オートコンプリートドロップダウンリスト表示の最大件数
        /// </summary>
        private int maxDropdownCount = 3;
        /// <summary>
        /// オートコンプリートドロップダウンリスト表示の最大件数
        /// </summary>
        public int MaxDropdownCount { get { return this.maxDropdownCount; } set { this.maxDropdownCount = value; } }

        /// <summary>
        /// オートコンプリートドロップダウンリストのアイテム
        /// </summary>
        private List<IconListBoxItem> items = new List<IconListBoxItem>();
        public List<IconListBoxItem> Items { get { return this.items; } }
        
        private DropdownListForm dropdownForm = new DropdownListForm();
        public DropdownListForm DropdownForm { get { return this.dropdownForm; } }

        private bool showableDropdownList = true;
        public bool ShowableDropdownList { get { return this.showableDropdownList; } set { this.showableDropdownList = value; } }

        /// <summary>
        /// タブ補完時のイベントハンドラ
        /// </summary>
        /// <param name="type"></param>
        public delegate void ComplementEventHandler(IconListBoxType type);
        public event ComplementEventHandler Complement;

        /// <summary>
        /// IME変換時のイベントハンドラ
        /// </summary>
        /// <param name="type"></param>
        public delegate void ImeCompositionEventHandler(int type, string text);
        public event ImeCompositionEventHandler ImeComposition;

        private bool complemented = false;
        public bool Complemented
        {
            get { return complemented; }
            set { complemented = value; }
        }

        private string imeText;
        public string ImeText
        {
            get { return imeText; }
            set { imeText = value; }
        }

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }

        #region コンポーネント デザイナで生成されたコード

        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を 
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // AutoCompleteTextBox
            // 
            this.SizeChanged += new System.EventHandler(this.AutoCompleteTextBox_SizeChanged);
            this.ResumeLayout(false);

        }

        #endregion

        public AutoCompleteTextBox() : base()
        {
            InitializeComponent();
            dropdownForm.ParentTextBox = this;
            dropdownForm.SetBounds(-1, -1, 1, 1);
        }

        protected override void OnTextChanged(EventArgs e)
        {
            base.OnTextChanged(e);
        }

        protected override void OnKeyDown(KeyEventArgs e)
        {
            if (e.Handled)
                return;

            Size t = TextRenderer.MeasureText(this.Text, this.Font);
            int index;
            IconListBox listBox = this.dropdownForm.DropdownListBox;
            switch (e.KeyCode)
            {
                case Keys.A:
                    if ((Keys.Control & Control.ModifierKeys) == Keys.Control || Keys.Home == e.KeyCode)
                    {
                        this.SelectAll();
                        e.Handled = true;
                    }
                    break;

                case Keys.Up:
                    if (listBox.Items.Count > 0)
                    {
                        if ((Keys.Control & Control.ModifierKeys) == Keys.Control || Keys.Home == e.KeyCode)
                            index = 0;
                        else
                            index = listBox.SelectedIndex - 1;
                        index = Math.Max(index, 0);
                        listBox.SelectedIndex = Math.Max(index, 0);
                    }
                    e.Handled = true;
                    break;
                case Keys.Down:
                    if (this.dropdownForm.Visible)
                    {
                        if (listBox.Items.Count > 0)
                        {
                            if ((Control.ModifierKeys & Keys.Control) == Keys.Control || Keys.End == e.KeyCode)
                                index = listBox.Items.Count - 1;
                            else
                                index = listBox.SelectedIndex + 1;
                            listBox.SelectedIndex = Math.Min(index, listBox.Items.Count - 1);
                        }
                    }
                    e.Handled = true;
                    break;
                case Keys.PageUp:
                    if (this.dropdownForm.Visible)
                    {
                        index = listBox.SelectedIndex - maxDropdownCount + 1;
                        if (index < 0)
                            index = 0;
                        listBox.SelectedIndex = index;
                    }
                    break;

                case Keys.PageDown:
                    if (this.dropdownForm.Visible)
                    {
                        index = listBox.SelectedIndex + maxDropdownCount - 1;
                        if (index > listBox.Items.Count - 1)
                            index = listBox.Items.Count - 1;
                        listBox.SelectedIndex = index;
                    }
                    break;

                case Keys.Home:
                    if (this.dropdownForm.Visible)
                    {
                        if (Keys.Control == (Keys.Control & Control.ModifierKeys))
                        {
                            listBox.SelectedIndex = 0;
                            e.Handled = true;
                        }
                    }
                    break;

                case Keys.End:
                    if (this.dropdownForm.Visible)
                    {
                        if (Keys.Control == (Keys.Control & Control.ModifierKeys))
                        {
                            listBox.SelectedIndex = listBox.Items.Count - 1;
                            e.Handled = true;
                        }
                    }
                    break;
            }
            base.OnKeyDown(e);
        }

        protected override void OnKeyPress(KeyPressEventArgs e)
        {
            switch ((Keys)e.KeyChar)
            {
                /*
                case Keys.Enter:
                    if (this.dropdownForm.Visible)
                    {
                        if (this.dropdownForm.DropdownListBox.SelectedIndex >= 0)
                        {
                            this.Text = this.dropdownForm.DropdownListBox.Text;
                            this.SelectionStart = this.Text.Length;
                        }
                        this.dropdownForm.DoVisibleChange(false);
                    }
                    break;
                */
/*                case Keys.Tab:

                    if (this.dropdownForm.Visible)
                    {
                        //タブキーによるコマンド補完
                        this.complemented = true;
                        IconListViewItem item = (IconListViewItem)this.dropdownForm.DropdownListView.SelectedItems[0];
                        switch (item.Type)
                        {
                            case IconListViewType.Directory:
                            case IconListViewType.Command:
                            case IconListViewType.File:
                            case IconListViewType.SysCommand:
                                this.Text = item.Text;
                                this.SelectionStart = this.Text.Length;
                                this.dropdownForm.DoVisibleChange(false);
                                this.Complement(item.Type);
                                break;
                        }
                        e.Handled = true;
                    }
                    break;
*/
                case Keys.F16:
                    int si;
                    int i;

                    si = this.SelectionStart;
                    if (si > 0)
                    {
                        i = si - 2;
                        while (i > 0)
                        {
                            char c = this.Text[i];
                            if (c == '\\' || c == ' ')
                            {
                                i++;
                                break;
                            }
                            i--;
                        }
                        if (this.Text.Length == si)
                            this.Text = this.Text.Substring(0, i);
                        else
                            this.Text = this.Text.Substring(0, i) + this.Text.Substring(si);
                        this.SelectionStart = i;
                    }
                    e.Handled = true;
                    break;
            }
            base.OnKeyPress(e);
            this.complemented = false;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="keyData"></param>
        /// <returns></returns>
        protected override bool IsInputKey(Keys keyData)
        {
            switch (keyData)
            {
                case Keys.Enter:
                case Keys.Escape:
                case Keys.Space:
                case Keys.Tab:
                    return true;
            }
            return base.IsInputKey(keyData);
        }

        public void SetDropdownFormLocation()
        {
            if (this.Parent == null || this.Parent.Parent == null)
                return;
            int count = Math.Min(this.maxDropdownCount, this.dropdownForm.DropdownListBox.Items.Count);
            Rectangle r = this.Parent.Parent.RectangleToScreen(this.Parent.Bounds);
            r.Height += r.Y - 1;
            r.Y++;
            Size size = new Size(this.Parent.Width, this.dropdownForm.DropdownListBox.ItemHeight + 4 + ((count - 1) * this.dropdownForm.DropdownListBox.ItemHeight));
            this.dropdownForm.Size = size;
            this.dropdownForm.Location = Util.CalcWindowLocate(r, size, Util.Locate.Down);
/*
            if (this.Parent == null)
                return;
            int count = Math.Min(this.maxDropdownCount, this.dropdownForm.DropdownListBox.Items.Count);
            Rectangle r = this.Parent.RectangleToScreen(this.Bounds);
            r.Height += r.Y - 1;
            r.Y++;
            Size size = new Size(this.Width, this.dropdownForm.DropdownListBox.ItemHeight + 4 + ((count - 1) * this.dropdownForm.DropdownListBox.ItemHeight));
            this.dropdownForm.Size = size;
            this.dropdownForm.Location = Util.CalcWindowLocate(r, size, Util.Locate.Down);*/
        }

        public void SortItems()
        {
            this.items.Sort(this);
        }

        public int Compare(IconListBoxItem item1, IconListBoxItem item2)
        {
            return item1.Text.CompareTo(item2.Text);
        }

        private void AutoCompleteTextBox_SizeChanged(object sender, EventArgs e)
        {
            this.SetDropdownFormLocation();
        }

        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case 0x010F: //WM_IME_COMPOSITION
                    //if (((int)m.LParam & GCS_COMPSTR) == GCS_COMPSTR)
                    //{
                        IntPtr hIMC = ImmGetContext(this.Handle);
                        StringBuilder sb = new StringBuilder(1024);
                        byte[] buffer = new byte[1024];
                        int length = ImmGetCompositionString(hIMC, GCS_COMPSTR, buffer, 1024);
                        ImmReleaseContext(this.Handle, hIMC);
                        string str = Encoding.GetEncoding("Shift_JIS").GetString(buffer);
                        str = str.TrimEnd('\0');
                        this.ImeComposition((int)m.LParam, str);
                    //}
                    break;
            }
            base.WndProc(ref m);
        }

    }
}