﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using Lugens.Passer.Macro;

namespace Lugens.Passer
{
    public partial class EditSentenceForm : Form
    {
        public EditSentenceForm()
        {
            InitializeComponent();
        }

        private void button_cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        public void Init()
        {
            this.comboBox_type.SelectedIndex = 0;

            this.comboBox_group.Items.Clear();
            for (int i = 1; i < Program.SettingForm.SentenceGroupNameTmp.Length; i++)
                this.comboBox_group.Items.Add(Program.SettingForm.SentenceGroupNameTmp[i]);

            if (Program.SettingForm.SentenceRadio != 0)
                this.comboBox_group.SelectedIndex = Program.SettingForm.SentenceRadio - 1;
            else
                this.comboBox_group.SelectedIndex = 0;

            this.comboBox_macroName.Items.Clear();
            foreach (string key in Program.MacroDic.Keys)
            {
                this.comboBox_macroName.Items.Add(Program.MacroDic[key].Macro.Name());
            }
            if (this.comboBox_macroName.Items.Count >= 0)
                this.comboBox_macroName.SelectedIndex = 0;

            this.textBox_name.Text = "";
            this.textBox_shortcut.HotKeycode = 0;
            this.textBox_value.Text = "";

            this.textBox_shortcut.AcceptKeys = SettingForm.AcceptKeyList;
            this.textBox_shortcut.GotFocus += SettingForm.hotKeyTextBox_GotFocus;
            this.textBox_shortcut.LostFocus += SettingForm.hotKeyTextBox_LostFocus;

            RelocateComponents();
        }

        private void textBox_shortcut_TextChanged(object sender, EventArgs e)
        {
            if (this.textBox_shortcut.HotKeycode != 0 &&
                (Program.SettingForm.hotKeyTextBox_Main.HotKeycode == this.textBox_shortcut.HotKeycode ||
                 Program.SettingForm.hotKeyTextBox_Clip.HotKeycode == this.textBox_shortcut.HotKeycode ||
                 Program.SettingForm.hotKeyTextBox_ClipPaste.HotKeycode == this.textBox_shortcut.HotKeycode))
            {
                this.label_dupulicate.Text = "※ホットキーで使用されています";
                this.label_dupulicate.Visible = true;
                this.button_ok.Enabled = false;
            }
            else
            {
                if (this.textBox_shortcut.HotKeycode != 0 &&
                    ((this.textBox_shortcut.HotKeycode & 0xF300) == 0 || (this.textBox_shortcut.HotKeycode & 0x3F00) == 0))
                {
                    this.label_dupulicate.Text = "※その組み合わせは設定できません";
                    this.label_dupulicate.Visible = true;
                    this.button_ok.Enabled = false;
                }
                else
                {
                    this.label_dupulicate.Visible = false;
                    this.button_ok.Enabled = true;
                }
            }
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            if ("".Equals(this.textBox_name.Text))
            {
                MessageBox.Show("設定名を入力してください", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.textBox_name.Focus();
                return;
            }
            if (!"マクロ".Equals(this.comboBox_type.Text) && "".Equals(this.textBox_value.Text))
            {
                MessageBox.Show("定型文を入力してください", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.textBox_value.Focus();
                return;
            }
            int srcIndex = int.Parse(this.textBox_srcIndex.Text);
            int srcGroup = int.Parse(this.textBox_srcGroup.Text);
            int destGroup = this.comboBox_group.SelectedIndex + 1;

            SentenceInfo info = new SentenceInfo();
            if ("マクロ".Equals(this.comboBox_type.Text))
            {
                info.Id = Program.MacroNameDic[this.comboBox_macroName.Text].Macro.Id();
            }
            info.Name = this.textBox_name.Text;
            info.Type = this.comboBox_type.SelectedIndex;
            info.Shortcut = this.textBox_shortcut.HotKeycode;
            info.Value = "マクロ".Equals(this.comboBox_type.Text) ? this.textBox_args.Text : this.textBox_value.Text;

            if (this.comboBox_group.SelectedIndex + 1 == srcGroup)
            {
                Program.SettingForm.SentenceGroupListTmp[srcGroup][srcIndex] = info;
                Program.SettingForm.RequestSentenceListViewSelect(srcGroup, srcIndex, true);
            }
            else
            {
                Program.SettingForm.SentenceGroupListTmp[srcGroup].RemoveAt(srcIndex);
                Program.SettingForm.SentenceGroupListTmp[destGroup].Add(info);
                Program.SettingForm.RequestSentenceListViewSelect(destGroup, Program.SettingForm.SentenceGroupListTmp[destGroup].Count - 1, false);
            }
            this.Close();
        }

        private void EditSentenceForm_Resize(object sender, EventArgs e)
        {
            RelocateComponents();
        }

        public void RelocateComponents()
        {
            int center = this.Size.Width >> 1;
            this.textBox_value.Size = new Size(this.Size.Width - 114, this.Size.Height - 200);
            this.textBox_args.Size = new Size(this.Size.Width - 114, this.textBox_args.Size.Height);
            this.textBox_summary.Size = new Size(this.Size.Width - 114, this.textBox_summary.Size.Height);
            this.textBox_description.Size = new Size(this.Size.Width - 114, this.Size.Height - 300);
            this.label_bar.Size = new Size(this.Size.Width - 28, 2);
            this.label_bar.Location = new Point(10, this.Size.Height - 80);
            this.button_ok.Location = new Point(center - 70, this.Size.Height - 70);
            this.button_cancel.Location = new Point(center + 6, this.Size.Height - 70);
        }

        private void comboBox_type_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (this.comboBox_type.SelectedIndex)
            {
                case 0:
                case 1:
                    this.label_macro.Visible = false;
                    this.comboBox_macroName.Visible = false;
                    this.label_args.Visible = false;
                    this.textBox_args.Visible = false;
                    this.label_summary.Visible = false;
                    this.textBox_summary.Visible = false;
                    this.label_description.Visible = false;
                    this.textBox_description.Visible = false;

                    this.label_sentence.Visible = true;
                    this.textBox_value.Visible = true;
                    break;

                case 2:
                    this.label_sentence.Visible = false;
                    this.textBox_value.Visible = false;

                    this.label_macro.Visible = true;
                    this.comboBox_macroName.Visible = true;
                    this.label_args.Visible = true;
                    this.textBox_args.Visible = true;
                    this.label_summary.Visible = true;
                    this.textBox_summary.Visible = true;
                    this.label_description.Visible = true;
                    this.textBox_description.Visible = true;
                    break;
            }
        }

        private void comboBox_macroName_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (Program.MacroNameDic.ContainsKey(this.comboBox_macroName.Text))
            {
                IMacro macro = Program.MacroNameDic[this.comboBox_macroName.Text].Macro;
                this.textBox_summary.Text = macro.Summary();
                this.textBox_description.Text = macro.Description();
            }
            else
            {
                this.textBox_summary.Text = "";
                this.textBox_description.Text = "";
            }
        }

    }
}
