using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using System.Text;
using System.Runtime.InteropServices;

using System.Windows.Forms;
using System.Xml;

using Lugens.Components;
using Lugens.Utils;
using Lugens.Passer.Macro;
using System.IO;

namespace Lugens.Passer
{
    public partial class SettingForm : Form
    {

        //private ImageList imageList;

        //private Point mousePoint;

        public Form TargetForm = null;

        private Dictionary<int, int> checkHotKeyDic = new Dictionary<int, int>();

        /// <summary>
        /// R}hXg
        /// </summary>
        private List<string> commandListTmp = new List<string>();
        public List<string> CommandListTmp
        {
            get { return commandListTmp; }
        }
        private Dictionary<string, CommandInfo> commandDicTmp = new Dictionary<string, CommandInfo>();
        public Dictionary<string, CommandInfo> CommandDicTmp
        {
            get { return commandDicTmp; }
        }
        
        /// <summary>
        /// O[v̒^̃Xg
        /// </summary>
        private  List<SentenceInfo>[] sentenceGroupListTmp = new List<SentenceInfo>[6];
        public List<SentenceInfo>[] SentenceGroupListTmp
        {
            get { return sentenceGroupListTmp; }
        }

        /// <summary>
        /// }NXg
        /// </summary>
        private Dictionary<string, MacroInfo> macroDicTmp = new Dictionary<string, MacroInfo>();
        public Dictionary<string, MacroInfo> MacroDicTmp
        {
            get { return macroDicTmp; }
        }

        /// <summary>
        /// ^̃O[v
        /// </summary>
        private string[] sentenceGroupNameTmp = new string[6];
        public string[] SentenceGroupNameTmp
        {
            get { return sentenceGroupNameTmp; }
        }

        private int sentenceRadio = -1;
        public int SentenceRadio
        {
            get { return sentenceRadio; }
        }

        /// <summary>
        /// GWXg
        /// </summary>
        private List<string> engineListTmp = new List<string>();
        public List<string> EngineListTmp
        {
            get { return engineListTmp; }
        }
        private Dictionary<string, EngineInfo> engineDicTmp = new Dictionary<string, EngineInfo>();
        public Dictionary<string, EngineInfo> EngineDicTmp
        {
            get { return engineDicTmp; }
        }

        private static readonly List<int> acceptKeyList = null;
        public static List<int> AcceptKeyList
        {
            get { return acceptKeyList; }
        }

        public TabControl TabControl
        {
            get { return tabControl; }
        }

        static SettingForm()
        {
            acceptKeyList = new List<int>();
            acceptKeyList.Add((int)Keycode.F1);             // F1
            acceptKeyList.Add((int)Keycode.F2);             // F2
            acceptKeyList.Add((int)Keycode.F3);             // F3
            acceptKeyList.Add((int)Keycode.F4);             // F4
            acceptKeyList.Add((int)Keycode.F5);             // F5
            acceptKeyList.Add((int)Keycode.F6);             // F6
            acceptKeyList.Add((int)Keycode.F7);             // F7
            acceptKeyList.Add((int)Keycode.F8);             // F8
            acceptKeyList.Add((int)Keycode.F9);             // F9
            acceptKeyList.Add((int)Keycode.F10);            // F10
            acceptKeyList.Add((int)Keycode.F11);            // F11
            acceptKeyList.Add((int)Keycode.F12);            // F12
            acceptKeyList.Add((int)Keycode.D1);             // D1
            acceptKeyList.Add((int)Keycode.D2);             // D2
            acceptKeyList.Add((int)Keycode.D3);             // D3
            acceptKeyList.Add((int)Keycode.D4);             // D4
            acceptKeyList.Add((int)Keycode.D5);             // D5
            acceptKeyList.Add((int)Keycode.D6);             // D6
            acceptKeyList.Add((int)Keycode.D7);             // D7
            acceptKeyList.Add((int)Keycode.D8);             // D8
            acceptKeyList.Add((int)Keycode.D9);             // D9
            acceptKeyList.Add((int)Keycode.D0);             // D0
            acceptKeyList.Add((int)Keycode.Equals);         // =
            acceptKeyList.Add((int)Keycode.Tilde);          // ~
            acceptKeyList.Add((int)Keycode.VerticalBar);    // |
            acceptKeyList.Add((int)Keycode.Q);              // Q
            acceptKeyList.Add((int)Keycode.W);              // W
            acceptKeyList.Add((int)Keycode.E);              // E
            acceptKeyList.Add((int)Keycode.R);              // R
            acceptKeyList.Add((int)Keycode.T);              // T
            acceptKeyList.Add((int)Keycode.Y);              // Y
            acceptKeyList.Add((int)Keycode.U);              // U
            acceptKeyList.Add((int)Keycode.I);              // I
            acceptKeyList.Add((int)Keycode.O);              // O
            acceptKeyList.Add((int)Keycode.P);              // P
            acceptKeyList.Add((int)Keycode.At);             // @
            acceptKeyList.Add((int)Keycode.OpenBracket);    // [
            acceptKeyList.Add((int)Keycode.A);              // A
            acceptKeyList.Add((int)Keycode.S);              // S
            acceptKeyList.Add((int)Keycode.D);              // D
            acceptKeyList.Add((int)Keycode.F);              // F
            acceptKeyList.Add((int)Keycode.G);              // G
            acceptKeyList.Add((int)Keycode.H);              // H
            acceptKeyList.Add((int)Keycode.J);              // J
            acceptKeyList.Add((int)Keycode.K);              // K
            acceptKeyList.Add((int)Keycode.L);              // L
            acceptKeyList.Add((int)Keycode.SemiColon);      // ;
            acceptKeyList.Add((int)Keycode.Colon);          // :
            acceptKeyList.Add((int)Keycode.CloseBracket);   // ]
            acceptKeyList.Add((int)Keycode.Z);              // Z
            acceptKeyList.Add((int)Keycode.X);              // X
            acceptKeyList.Add((int)Keycode.C);              // C
            acceptKeyList.Add((int)Keycode.V);              // V
            acceptKeyList.Add((int)Keycode.B);              // B
            acceptKeyList.Add((int)Keycode.N);              // N
            acceptKeyList.Add((int)Keycode.M);              // M
            acceptKeyList.Add((int)Keycode.Less);           // <
            acceptKeyList.Add((int)Keycode.Greater);        // >
            acceptKeyList.Add((int)Keycode.Question);       // ?
            acceptKeyList.Add((int)Keycode.Underscore);     // _
            acceptKeyList.Add((int)Keycode.Left);           // 
            acceptKeyList.Add((int)Keycode.Up);             // 
            acceptKeyList.Add((int)Keycode.Right);          // 
            acceptKeyList.Add((int)Keycode.Down);           // 
            acceptKeyList.Add((int)Keycode.Insert);
            acceptKeyList.Add((int)Keycode.Delete);
            acceptKeyList.Add((int)Keycode.Home);
            acceptKeyList.Add((int)Keycode.End);
            acceptKeyList.Add((int)Keycode.PageUp);
            acceptKeyList.Add((int)Keycode.PageDown);
            acceptKeyList.Add((int)Keycode.Space);
            acceptKeyList.Add((int)Keycode.BackSpace);
            acceptKeyList.Add((int)Keycode.Escape);
            acceptKeyList.Add((int)Keycode.Tab);
            acceptKeyList.Add((int)Keycode.Enter);
            acceptKeyList.Add((int)Keycode.Win);
            acceptKeyList.Add((int)Keycode.Control);
            acceptKeyList.Add((int)Keycode.LControl);
            acceptKeyList.Add((int)Keycode.RControl);
            acceptKeyList.Add((int)Keycode.Alt);
            acceptKeyList.Add((int)Keycode.LAlt);
            acceptKeyList.Add((int)Keycode.RAlt);
            acceptKeyList.Add((int)Keycode.Shift);
            acceptKeyList.Add((int)Keycode.LShift);
            acceptKeyList.Add((int)Keycode.RShift);
        }

        public SettingForm()
        {
            InitializeComponent();

            this.hotKeyTextBox_Main.AcceptKeys = SettingForm.acceptKeyList;
            this.hotKeyTextBox_Main.GotFocus += SettingForm.hotKeyTextBox_GotFocus;
            this.hotKeyTextBox_Main.LostFocus += SettingForm.hotKeyTextBox_LostFocus;
            this.hotKeyTextBox_Main.TextChanged += this.hotKeyTextBox_TextChanged;

            this.hotKeyTextBox_Clip.AcceptKeys = SettingForm.acceptKeyList;
            this.hotKeyTextBox_Clip.GotFocus += SettingForm.hotKeyTextBox_GotFocus;
            this.hotKeyTextBox_Clip.LostFocus += SettingForm.hotKeyTextBox_LostFocus;
            this.hotKeyTextBox_Clip.TextChanged += this.hotKeyTextBox_TextChanged;

            this.hotKeyTextBox_ClipPaste.AcceptKeys = SettingForm.acceptKeyList;
            this.hotKeyTextBox_ClipPaste.GotFocus += SettingForm.hotKeyTextBox_GotFocus;
            this.hotKeyTextBox_ClipPaste.LostFocus += SettingForm.hotKeyTextBox_LostFocus;
            this.hotKeyTextBox_ClipPaste.TextChanged += this.hotKeyTextBox_TextChanged;

            this.hotKeyTextBox_KeyRecord.AcceptKeys = SettingForm.acceptKeyList;
            this.hotKeyTextBox_KeyRecord.GotFocus += SettingForm.hotKeyTextBox_GotFocus;
            this.hotKeyTextBox_KeyRecord.LostFocus += SettingForm.hotKeyTextBox_LostFocus;
            this.hotKeyTextBox_KeyRecord.TextChanged += this.hotKeyTextBox_TextChanged;

            this.hotKeyTextBox_KeyPlay.AcceptKeys = SettingForm.acceptKeyList;
            this.hotKeyTextBox_KeyPlay.GotFocus += SettingForm.hotKeyTextBox_GotFocus;
            this.hotKeyTextBox_KeyPlay.LostFocus += SettingForm.hotKeyTextBox_LostFocus;
            this.hotKeyTextBox_KeyPlay.TextChanged += this.hotKeyTextBox_TextChanged;
        }

        /// <summary>
        /// ݒt@C̓ǂݍ
        /// </summary>
        private void ReadSetting()
        {
            this.checkBox_fadeIn.Checked = Settings.GetBool(Settings.PASSER_MAIN_FADEIN);
            this.checkBox_showBalloonWhileRecoding.Checked = Settings.GetBool(Settings.PASSER_MAIN_SHOWBALLOONWHILERECODING);
            this.checkBox_sendRecordToClipboard.Checked = Settings.GetBool(Settings.PASSER_MAIN_SENDRECORDTOCLIPBOARD);
            this.checkBox_showScriptToolTip.Checked = Settings.GetBool(Settings.PASSER_SENTENCE_SHOWSCRIPTTOOLTIP);
            this.checkBox_memorizeEngine.Checked = Settings.GetBool(Settings.PASSER_MAIN_MEMORIZE_ENGINE);
            this.hotKeyTextBox_Main.HotKeycode = Settings.GetInt(Settings.PASSER_HOTKEY_MAIN);
            this.hotKeyTextBox_Clip.HotKeycode = Settings.GetInt(Settings.PASSER_HOTKEY_CLIP);
            this.hotKeyTextBox_ClipPaste.HotKeycode = Settings.GetInt(Settings.PASSER_HOTKEY_CLIP_PASTE);
            this.hotKeyTextBox_KeyRecord.HotKeycode = Settings.GetInt(Settings.PASSER_HOTKEY_KEY_RECORD);
            this.hotKeyTextBox_KeyPlay.HotKeycode = Settings.GetInt(Settings.PASSER_HOTKEY_KEY_PLAY);
            this.trackBar_opacity.Value = Settings.GetInt(Settings.PASSER_FORM_OPACITY);
            this.textBox_opacity.Text = this.trackBar_opacity.Value.ToString();
            
        }

        /// <summary>
        /// }N̓ǂݍ
        /// </summary>
        public void ReadMacroList()
        {
            this.macro_textBox_id.Text = "";
            this.macro_textBox_summary.Text = "";
            this.macro_textBox_description.Text = "";

            this.macroDicTmp.Clear();
            this.macro_iconListBox.Items.Clear();
            foreach (string key in Program.MacroDic.Keys)
            {
                MacroInfo info = new MacroInfo();
                info.Macro = Program.MacroDic[key].Macro;
                info.Item = new IconListBoxItem();
                info.Item.Name = info.Macro.Id();
                info.Item.Text = info.Macro.Name();
                info.Item.IconImage = Properties.Resources.IconMacro.ToBitmap();
                info.Item.Regex = Program.Ime.GetRomaji(info.Item.Text);
                this.macroDicTmp.Add(key, info);
                this.macro_iconListBox.Items.Add(info.Item);
            }
        }

        /// <summary>
        /// ^̓ǂݍ
        /// </summary>
        public void ReadSentenceList()
        {
            for (int i = 0; i < sentenceGroupNameTmp.Length; i++)
            {
                this.sentenceGroupNameTmp[i] = Program.sentenceGroupName[i];
                this.sentenceGroupListTmp[i] = new List<SentenceInfo>();
                if (Program.SentenceGroupList[i] != null)
                {
                    foreach (SentenceInfo info in Program.SentenceGroupList[i])
                        this.sentenceGroupListTmp[i].Add(info);
                }
            }
            this.sentence_radio1.Checked = true;
            this.sentenceRadio = 1;
            this.ChangeSentenceGroup();
        }

        /// <summary>
        /// GW̓ǂݍ
        /// </summary>
        public void ReadEngineList()
        {
            Program.SettingForm.ReadEngineList(false);
            /*
            this.engineListTmp.Clear();
            this.engineDicTmp.Clear();
            this.engine_iconListBox.Items.Clear();

            foreach (string key in Program.EngineList)
            {
                this.engineListTmp.Add(key);
                this.EngineDicTmp.Add(key, Program.EngineDic[key]);
                IconListBoxItem item = new IconListBoxItem();
                item.Name = key;
                item.Text = key;
                item.IconImage = this.EngineDicTmp[key].IconImage;
                item.Type = IconListBoxType.Command;
                item.Regex = Program.Ime.GetRomaji(key);
                this.engine_iconListBox.Items.Add(item);
            }
            */
        }

        /// <summary>
        /// R}ht@C̓ǂݍ
        /// </summary>
        public void ReadCommandList()
        {
            this.ReadCommandList(false);
        }

        /// <summary>
        /// R}ht@C̓ǂݍ
        /// </summary>
        public void ReadCommandList(bool refresh)
        {
            this.command_textBox_name.Text = "";
            this.command_textBox_target.Text = "";
            this.command_textBox_path.Text = "";
            this.command_textBox_arguments.Text = "";
            this.command_textBox_comment.Text = "";
            this.command_pictureBox1.Image = null;

            if (refresh)
            {
                this.command_iconListBox.Items.Clear();
                foreach(string key in this.commandListTmp)
                {
                    IconListBoxItem item = new IconListBoxItem();
                    item.Name = key;
                    item.Text = key;
                    item.IconImage = this.CommandDicTmp[key].ApplicationIcon.ToBitmap();
                    item.Type = IconListBoxType.Command;
                    item.Regex = Program.Ime.GetRomaji(key);
                    this.command_iconListBox.Items.Add(item);
                }
            }
            else
            {
                this.commandListTmp.Clear();
                this.commandDicTmp.Clear();
                this.command_iconListBox.Items.Clear();
                foreach (string key in Program.CommandList)
                {
                    this.commandListTmp.Add(key);
                    this.commandDicTmp.Add(key, Program.CommandDic[key]);
                    IconListBoxItem item = new IconListBoxItem();
                    item.Name = key;
                    item.Text = key;
                    item.IconImage = this.CommandDicTmp[key].ApplicationIcon.ToBitmap();
                    item.Type = IconListBoxType.Command;
                    item.Regex = Program.Ime.GetRomaji(key);
                    this.command_iconListBox.Items.Add(item);
                }
            }
        }

        /// <summary>
        /// GWt@C̓ǂݍ
        /// </summary>
        public void ReadEngineList(bool refresh)
        {
            this.engine_textBox_name.Text = "";
            this.engine_textBox_url.Text = "";
            this.engine_textBox_searchUrl.Text = "";
            this.engine_textBox_suggestUrl.Text = "";
            this.engine_textBox_shortcut.Text = "";
            this.engine_textBox_encoding.Text = "";
            this.engine_textBox_display.Text = "";
            this.engine_textBox_comment.Text = "";
            this.engine_pictureBox.Image = null;

            if (refresh)
            {
                this.engine_iconListBox.Items.Clear();
                foreach (string key in this.engineListTmp)
                {
                    if (this.EngineDicTmp[key].Removed)
                        continue;

                    IconListBoxItem item = new IconListBoxItem();
                    item.Name = key;
                    item.Text = key;
                    item.IconImage = this.EngineDicTmp[key].IconImage;
                    item.Type = IconListBoxType.Command;
                    item.Regex = null;
                    this.engine_iconListBox.Items.Add(item);
                }
            }
            else
            {
                this.engineListTmp.Clear();
                this.engineDicTmp.Clear();
                this.engine_iconListBox.Items.Clear();
                foreach (string key in Program.EngineList)
                {
                    this.engineListTmp.Add(key);
                    EngineInfo info = new EngineInfo();
                    info.Id = Program.EngineDic[key].Id;
                    info.Name = Program.EngineDic[key].Name;
                    info.Url = Program.EngineDic[key].Url;
                    info.Shortcut = Program.EngineDic[key].Shortcut;
                    info.SearchUrl = Program.EngineDic[key].SearchUrl;
                    info.SuggestUrl = Program.EngineDic[key].SuggestUrl;
                    info.Encoding = Program.EngineDic[key].Encoding;
                    info.Display = Program.EngineDic[key].Display;
                    info.Type = Program.EngineDic[key].Type;
                    info.IconImage = Program.EngineDic[key].IconImage;
                    info.IconChanged = false;
                    info.Removed = false;
                    this.engineDicTmp.Add(key, info);
                    IconListBoxItem item = new IconListBoxItem();
                    item.Name = key;
                    item.Text = key;
                    item.IconImage = this.EngineDicTmp[key].IconImage;
                    item.Type = IconListBoxType.SearchEngine;
                    item.Regex = Program.Ime.GetRomaji(key);
                    this.engine_iconListBox.Items.Add(item);
                }
            }
        }

        /// <summary>
        /// ݒt@C̔f
        /// </summary>
        public void ReflectSetting()
        {
            Settings.Set(Settings.PASSER_MAIN_FADEIN, this.checkBox_fadeIn.Checked);
            Settings.Set(Settings.PASSER_MAIN_SHOWBALLOONWHILERECODING, this.checkBox_showBalloonWhileRecoding.Checked);
            Settings.Set(Settings.PASSER_MAIN_SENDRECORDTOCLIPBOARD, this.checkBox_sendRecordToClipboard.Checked);
            Settings.Set(Settings.PASSER_MAIN_MEMORIZE_ENGINE, this.checkBox_memorizeEngine.Checked);
            Settings.Set(Settings.PASSER_SENTENCE_SHOWSCRIPTTOOLTIP, this.checkBox_showScriptToolTip.Checked);
            Settings.Set(Settings.PASSER_HOTKEY_MAIN, this.hotKeyTextBox_Main.HotKeycode);
            Settings.Set(Settings.PASSER_HOTKEY_CLIP, this.hotKeyTextBox_Clip.HotKeycode);
            Settings.Set(Settings.PASSER_HOTKEY_CLIP_PASTE, this.hotKeyTextBox_ClipPaste.HotKeycode);
            Settings.Set(Settings.PASSER_HOTKEY_KEY_RECORD, this.hotKeyTextBox_KeyRecord.HotKeycode);
            Settings.Set(Settings.PASSER_HOTKEY_KEY_PLAY, this.hotKeyTextBox_KeyPlay.HotKeycode);
            Settings.Set(Settings.PASSER_FORM_OPACITY, this.trackBar_opacity.Value);
        }
        
        /// <summary>
        /// R}hXg̔f
        /// </summary>
        public void ReflectCommandList()
        {
            Program.CommandList.Clear();
            Program.CommandDic.Clear();
            foreach (string key in this.commandListTmp)
            {
                CommandInfo info = this.commandDicTmp[key];
                Program.AddCommand(info);
            }
        }

        /// <summary>
        /// ^Xg̔f
        /// </summary>
        public void ReflectSentenceList()
        {
            for (int i = 0; i < this.SentenceGroupListTmp.Length; i++)
            {
                Program.sentenceGroupName[i] = this.sentenceGroupNameTmp[i];
                Program.SentenceGroupList[i].Clear();
                Program.SentenceGroupList[i].AddRange(this.SentenceGroupListTmp[i]);
            }
        }

        /// <summary>
        /// GWXg̔f
        /// </summary>
        public void ReflectEngineList()
        {
            Program.EngineList.Clear();
            Program.EngineDic.Clear();
            foreach (string key in this.engineListTmp)
            {
                EngineInfo info = this.engineDicTmp[key];
                Program.EngineList.Add(info.Name);
                Program.EngineDic.Add(info.Name, info);
            }
        }

        public void RequestCommandListViewSelect(string key)
        {
            for (int i = 0; i < this.command_iconListBox.Items.Count; i++)
            {
                if (key.Equals(((IconListBoxItem)this.command_iconListBox.Items[i]).Text))
                {
                    this.command_iconListBox.SelectedIndex = i;
                    this.command_iconListBox_SelectedIndexChanged(null, null);
                    return;
                }

            }
        }

        public void RequestSentenceListViewSelect(int group, int index, bool refresh)
        {
            if (refresh || this.SentenceRadio != group)
                this.ChangeSentenceGroup(group);

            if (this.sentence_iconListBox.Items.Count == 0)
                return;

            index = this.sentence_iconListBox.Items.Count > index ? index : this.sentence_iconListBox.Items.Count - 1;
            this.sentence_iconListBox.SelectedIndex = index;

        }

        public void RequestEngineListViewSelect(string key)
        {
            for (int i = 0; i < this.engine_iconListBox.Items.Count; i++)
            {
                if (key.Equals(((IconListBoxItem)this.engine_iconListBox.Items[i]).Text))
                {
                    this.engine_iconListBox.SelectedIndex = i;
                    this.engine_iconListBox_SelectedIndexChanged(null, null);
                    return;
                }

            }
        }

        private void SettingForm_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.Move;
            }
        }

        private void SettingForm_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (String[])e.Data.GetData(DataFormats.FileDrop);
            if (files == null || files.Length == 0)
                return;

            string file = files[0];
            this.tabControl.SelectTab("tabPageCommand");

            AddCommandForm form = new AddCommandForm();
            form.SetSelectedFile(file);
            this.TargetForm = form;
            Win32.PostMessage(this.Handle, Program.WM_APP_SHOWFORM, IntPtr.Zero, IntPtr.Zero);
        }

        private void SettingForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                this.DoVisibleChange(false);
                e.Cancel = true;
            }
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            ReflectSetting();
            ReflectCommandList();
            ReflectSentenceList();
            ReflectEngineList();
            Settings.Write(Program.SettingFileName);
            Program.WriteCommandList();
            Program.WriteSentenceList();
            Program.ReadSentenceList();
            Program.WriteEngineList();
            Program.ReadEngineList();
            Program.ReadSetting();
            Program.MainForm.ReadSetting();
            Program.MainForm.ReadCommandList();
            this.DoVisibleChange(false);
        }

        private void button_cancel_Click(object sender, EventArgs e)
        {
            this.DoVisibleChange(false);
        }

        private void command_button_new_Click(object sender, EventArgs e)
        {
            new AddCommandForm().ShowDialog();
        }

        private void command_button_edit_Click(object sender, EventArgs e)
        {
            EditCommandForm form = new EditCommandForm();
            form.TextBox_select.Text = this.command_iconListBox.Text;
            form.ShowDialog();
        }

        private void command_button_delete_Click(object sender, EventArgs e)
        {
            command_delete();
        }

        private void hotKeyTextBox_TextChanged(object sender, EventArgs e)
        {
            HotKeyTextBox[] hotKeyTextBoxList = { this.hotKeyTextBox_Main, this.hotKeyTextBox_Clip, this.hotKeyTextBox_ClipPaste, this.hotKeyTextBox_KeyPlay, this.hotKeyTextBox_KeyRecord };
            this.checkHotKeyDic.Clear();

            foreach (HotKeyTextBox textBox in hotKeyTextBoxList)
            {
                if (textBox.HotKeycode == 0)
                    continue;
                if (this.checkHotKeyDic.ContainsKey(textBox.HotKeycode))
                {
                    this.label_hotKeyError.Visible = true;
                    this.button_ok.Enabled = false;
                    return;
                }
                this.checkHotKeyDic.Add(textBox.HotKeycode, 0);
            }

            this.label_hotKeyError.Visible = false;
            this.button_ok.Enabled = true;

        }

        public static void hotKeyTextBox_GotFocus(object sender, EventArgs e)
        {
            Program.HotKeyTextBoxHandle = ((Control)sender).Handle;
            Program.Status = ProgramStatus.HotKeyTextBoxFocus;
        }

        public static void hotKeyTextBox_LostFocus(object sender, EventArgs e)
        {
            Program.HotKeyTextBoxHandle = IntPtr.Zero;
            Program.Status = ProgramStatus.SettingFormOpen;
        }

        public void DoVisibleChange(bool visible)
        {
            if (visible)
            {
                ReadSetting();
                ReadCommandList();
                ReadMacroList();
                ReadSentenceList();
                ReadEngineList();
                this.Visible = true;
                Program.Status = ProgramStatus.SettingFormOpen;
            }
            else
            {
                this.Visible = false;
                if (Program.MainForm.Visible)
                    Program.Status = ProgramStatus.MainFormOpen;
                else
                    Program.Status = ProgramStatus.Waiting;
            }
        }

        private void sentence_button_new_Click(object sender, EventArgs e)
        {
            new AddSentenceForm().ShowDialog();
        }

        private void sentence_radio0_CheckedChanged(object sender, EventArgs e)
        {
            if (this.sentenceRadio != 0 && this.sentence_radio0.Checked)
            {
                this.sentenceRadio = 0;
                this.ChangeSentenceGroup();
            }
        }

        private void sentence_radio1_CheckedChanged(object sender, EventArgs e)
        {
            if (this.sentenceRadio != 1 && this.sentence_radio1.Checked)
            {
                this.sentenceRadio = 1;
                this.ChangeSentenceGroup();
            }
        }

        private void sentence_radio2_CheckedChanged(object sender, EventArgs e)
        {
            if (this.sentenceRadio != 2 && this.sentence_radio2.Checked)
            {
                this.sentenceRadio = 2;
                this.ChangeSentenceGroup();
            }
        }

        private void sentence_radio3_CheckedChanged(object sender, EventArgs e)
        {
            if (this.sentenceRadio != 3 && this.sentence_radio3.Checked)
            {
                this.sentenceRadio = 3;
                this.ChangeSentenceGroup();
            }
        }

        private void sentence_radio4_CheckedChanged(object sender, EventArgs e)
        {
            if (this.sentenceRadio != 4 && this.sentence_radio4.Checked)
            {
                this.sentenceRadio = 4;
                this.ChangeSentenceGroup();
            }
        }

        private void sentence_radio5_CheckedChanged(object sender, EventArgs e)
        {
            if (this.sentenceRadio != 5 && this.sentence_radio5.Checked)
            {
                this.sentenceRadio = 5;
                this.ChangeSentenceGroup();
            }
        }

        public void ChangeSentenceGroup()
        {
            int group = this.sentenceRadio;
            this.sentence_textBox_group.Text = this.SentenceGroupNameTmp[group];
            this.sentence_textBox_group.ReadOnly = (group == 0);
            this.sentence_button_new.Enabled = (group != 0);
            this.sentence_button_edit.Enabled = false;
            this.sentence_button_delete.Enabled = false;

            this.sentence_textBox_name.Text = "";
            this.sentence_textBox_type.Text = "";
            this.sentence_textBox_shortcut.Text = "";
            this.sentence_textBox_value.Text = "";
            this.sentence_textBox_macroName.Text = "";
            this.sentence_textBox_args.Text = "";
            this.sentence_textBox_summary.Text = "";
            this.sentence_textBox_description.Text = "";
            this.sentence_iconListBox.Items.Clear();
            for (int i = 0; i < SentenceGroupListTmp[group].Count; i++)
            {
                if (!String.IsNullOrEmpty(SentenceGroupListTmp[group][i].Name))
                {
                    IconListBoxItem item = new IconListBoxItem();
                    item.Name = SentenceGroupListTmp[group][i].Name;
                    item.Text = SentenceGroupListTmp[group][i].Name;
                    item.IconImage = Program.SentenceIcons[SentenceGroupListTmp[group][i].Type].ToBitmap();
                    item.Regex = Program.Ime.GetRomaji(item.Name.Substring(0, item.Name.Length > 30 ? 30 : item.Name.Length));
                    this.sentence_iconListBox.Items.Add(item);
                }
            }
            //this.sentence_iconListView.ItemCountChange();
        }

        private void OpenEditSentenceForm()
        {
            if (this.sentenceRadio == 0 || this.sentence_iconListBox.SelectedIndex < 0)
                return;

            SentenceInfo info = SentenceGroupListTmp[this.sentenceRadio][this.sentence_iconListBox.SelectedIndex];
            EditSentenceForm form = new EditSentenceForm();
            form.Init();
            form.textBox_srcIndex.Text = this.sentence_iconListBox.SelectedIndex.ToString();
            form.textBox_srcGroup.Text = this.sentenceRadio.ToString();
            form.textBox_name.Text = info.Name;
            form.textBox_shortcut.HotKeycode = info.Shortcut;
            form.comboBox_type.SelectedIndex = info.Type;

            if (info.Type == 2)
            {
                IMacro macro = Program.MacroDic[info.Id].Macro;
                form.comboBox_macroName.Text = macro.Name();
                form.textBox_args.Text = info.Value;
            }
            else
            {
                form.textBox_value.Text = info.Value;
            }
            form.ShowDialog();
        }

        private void trackBar_opacity_ValueChanged(object sender, EventArgs e)
        {
            this.textBox_opacity.Text = this.trackBar_opacity.Value.ToString();
        }

        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case Program.WM_APP_SHOWFORM:
                    if (this.TargetForm != null)
                    {
                        this.TargetForm.ShowDialog();
                        this.TargetForm = null;
                    }
                    break;
            }

            base.WndProc(ref m);
        }

        private void command_iconListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.command_iconListBox.SelectedIndex < 0)
            {
                this.command_textBox_name.Text = "";
                this.command_textBox_target.Text = "";
                this.command_textBox_path.Text = "";
                this.command_textBox_arguments.Text = "";
                this.command_textBox_comment.Text = "";
                this.command_pictureBox1.Image = null;
                this.command_button_edit.Enabled = false;
                this.command_button_delete.Enabled = false;
            }
            else
            {
                CommandInfo info = this.CommandDicTmp[this.command_iconListBox.Text];
                if (!File.Exists(info.Target) && !Directory.Exists(info.Target))
                {
                    this.command_textBox_name.Text = "";
                    this.command_textBox_target.Text = "";
                    this.command_textBox_path.Text = "";
                    this.command_textBox_arguments.Text = "";
                    this.command_textBox_comment.Text = "";
                    this.command_pictureBox1.Image = null;
                    this.command_button_edit.Enabled = true;
                    this.command_button_delete.Enabled = true;
                    if (MessageBox.Show("^[Qbg݂܂B\n폜܂H", "ǂݍ݃G[", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning) == DialogResult.OK)
                    {
                        command_delete();
                    }

                    return;
                }
                this.command_button_delete.Enabled = true;
                this.command_button_edit.Enabled = true;

                this.command_textBox_name.Text = info.Name;
                this.command_textBox_target.Text = info.Target;
                this.command_textBox_path.Text = info.Path;
                this.command_textBox_arguments.Text = info.Arguments;
                this.command_textBox_comment.Text = info.Comment;

                Win32.SHFILEINFO shinfo = new Win32.SHFILEINFO();
                Win32.SHGetFileInfo(info.Target, 0, ref shinfo, Marshal.SizeOf(shinfo), Win32.SHGFI_ICON | Win32.SHGFI_LARGEICON);
                Icon icon = System.Drawing.Icon.FromHandle(shinfo.hIcon);
                this.command_pictureBox1.Image = icon == null ? null : icon.ToBitmap();
            }
        }

        private void command_iconListBox_DoubleClick(object sender, EventArgs e)
        {
            //if (this.command_iconListBox.SelectedIndex >= 0)
            //    command_button_edit_Click(null, null);
        }

        private void command_iconListBox_KeyDown(object sender, KeyEventArgs e)
        {
            if (this.command_iconListBox.SelectedIndex > -1 && e.KeyCode == Keys.Delete)
            {
                command_delete();
            }
        }

        public void ChangeSentenceGroup(int group)
        {
            switch (group)
            {
                case 0:
                    this.sentenceRadio = 0;
                    this.sentence_radio0.Checked = true;
                    break;
                case 1:
                    this.sentenceRadio = 1;
                    this.sentence_radio1.Checked = true;
                    break;
                case 2:
                    this.sentenceRadio = 2;
                    this.sentence_radio2.Checked = true;
                    break;
                case 3:
                    this.sentenceRadio = 3;
                    this.sentence_radio3.Checked = true;
                    break;
                case 4:
                    this.sentenceRadio = 4;
                    this.sentence_radio4.Checked = true;
                    break;
                case 5:
                    this.sentenceRadio = 5;
                    this.sentence_radio5.Checked = true;
                    break;
            }
            this.ChangeSentenceGroup();
        }

        private void sentence_textBox_group_TextChanged(object sender, EventArgs e)
        {
            this.SentenceGroupNameTmp[this.sentenceRadio] = this.sentence_textBox_group.Text;
        }

        private void sentence_button_edit_Click(object sender, EventArgs e)
        {
            OpenEditSentenceForm();
        }

        private void sentence_button_delete_Click(object sender, EventArgs e)
        {
            sentence_delete();
        }

        private void sentence_iconListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.sentence_iconListBox.SelectedIndex >= 0)
            {
                SentenceInfo info = SentenceGroupListTmp[this.sentenceRadio][this.sentence_iconListBox.SelectedIndex];
                this.sentence_textBox_name.Text = info.Name;
                this.sentence_textBox_shortcut.Text = HotKeyTextBox.GetKeyText(info.Shortcut);

                if (info.Type == 2)
                {
                    this.sentence_label_value.Visible = false;
                    this.sentence_textBox_value.Visible = false;

                    this.sentence_label_macroName.Visible = true;
                    this.sentence_textBox_macroName.Visible = true;
                    this.sentence_label_args.Visible = true;
                    this.sentence_textBox_args.Visible = true;
                    this.sentence_label_summary.Visible = true;
                    this.sentence_textBox_summary.Visible = true;
                    this.sentence_label_description.Visible = true;
                    this.sentence_textBox_description.Visible = true;
                }
                else
                {
                    this.sentence_label_value.Visible = true;
                    this.sentence_textBox_value.Visible = true;

                    this.sentence_label_macroName.Visible = false;
                    this.sentence_textBox_macroName.Visible = false;
                    this.sentence_label_args.Visible = false;
                    this.sentence_textBox_args.Visible = false;
                    this.sentence_label_summary.Visible = false;
                    this.sentence_textBox_summary.Visible = false;
                    this.sentence_label_description.Visible = false;
                    this.sentence_textBox_description.Visible = false;
                }
                Application.DoEvents();

                switch (info.Type)
                {
                    case 0:
                        this.sentence_textBox_type.Text = "^";
                        this.sentence_textBox_value.Text = info.Value;
                        break;
                    case 1:
                        this.sentence_textBox_type.Text = "XNvg";
                        this.sentence_textBox_value.Text = info.Value;
                        break;
                    case 2:
                        if (Program.MacroDic.ContainsKey(info.Id))
                        {
                            IMacro macro = Program.MacroDic[info.Id].Macro;
                            this.sentence_textBox_macroName.Text = macro.Name();
                            this.sentence_textBox_summary.Text = macro.Summary();
                            this.sentence_textBox_description.Text = macro.Description();
                            this.sentence_textBox_args.Text = info.Value;
                        }
                        else
                        {
                            this.sentence_textBox_macroName.Text = "";
                            this.sentence_textBox_summary.Text = "";
                            this.sentence_textBox_description.Text = "";
                            this.sentence_textBox_args.Text = "";
                        }
                        this.sentence_textBox_type.Text = "}N";
                        break;
                }


                this.sentence_button_edit.Enabled = (this.sentenceRadio != 0);
                this.sentence_button_delete.Enabled = true;
            }
            else
            {
                this.sentence_textBox_name.Text = "";
                this.sentence_textBox_type.Text = "";
                this.sentence_textBox_shortcut.Text = "";
                this.sentence_textBox_value.Text = "";
                this.sentence_textBox_macroName.Text = "";
                this.sentence_textBox_summary.Text = "";
                this.sentence_textBox_description.Text = "";
                this.sentence_textBox_args.Text = "";
                this.sentence_button_edit.Enabled = false;
                this.sentence_button_delete.Enabled = false;
            }

        }

        private void sentence_iconListBox_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Move;
            Win32.ImageList_DragEnter(this.Handle, Cursor.Position.X - this.Left, Cursor.Position.Y - this.Top);
        }

        private void sentence_iconListBox_DragDrop(object sender, DragEventArgs e)
        {
            Win32.ImageList_DragLeave(this.Handle);
            int srcIndex = (int)e.Data.GetData(typeof(int));
            Point p = this.sentence_iconListBox.PointToClient(Control.MousePosition);
            int destIndex = this.sentence_iconListBox.TopIndex + this.sentence_iconListBox.DividePoint;
            if (destIndex < 0 || srcIndex == destIndex || srcIndex == (destIndex - 1))
                return;

            object o = this.sentence_iconListBox.Items[srcIndex];

            this.sentence_iconListBox.Items.RemoveAt(srcIndex);
            if (destIndex > srcIndex)
                destIndex--;
            this.sentence_iconListBox.Items.Insert(destIndex, o);

            SentenceInfo info = SentenceGroupListTmp[this.sentenceRadio][srcIndex];
            SentenceGroupListTmp[this.sentenceRadio].RemoveAt(srcIndex);
            SentenceGroupListTmp[this.sentenceRadio].Insert(destIndex, info);
            this.sentence_iconListBox.Invalidate();
            this.sentence_iconListBox.SelectedIndex = destIndex;
        }

        private void sentence_iconListBox_MouseEnter(object sender, EventArgs e)
        {
            this.sentence_iconListBox.Status = 0;
        }

        private void sentence_iconListBox_MouseDown(object sender, MouseEventArgs e)
        {
            int index = this.sentence_iconListBox.SelectedIndex;
            if (index < 0)
                return;

            sentence_iconListBox_SelectedIndexChanged(null, null);
            if (e.Clicks > 1 && e.Button == MouseButtons.Left)
                this.sentence_iconListBox.Status = 9;
            else
                this.sentence_iconListBox.Status = 1;
            IconListBox.MousePoint = e.Location;
        }

        private void sentence_iconListBox_MouseMove(object sender, MouseEventArgs e)
        {
            if (this.sentence_iconListBox.Status == 9)
            {
                if (IconListBox.MousePoint.X != e.Location.X || IconListBox.MousePoint.Y != e.Location.Y)
                {
                    this.sentence_iconListBox.BeginDragDrop(e);
                }
            }
            else if (this.sentence_iconListBox.Status == 1 && e.Button == MouseButtons.Left)
            {
                this.sentence_iconListBox.BeginDragDrop(e);
            }
        }
/*
        private void BeginDragDrop(MouseEventArgs e)
        {
            if (this.sentence_iconListBox.SelectedIndex < 0)
                return;

            int itemIndex = this.sentence_iconListBox.IndexFromPoint(this.mousePoint);
            Rectangle rect = this.sentence_iconListBox.GetItemRectangle(itemIndex);

            this.imageList = new ImageList();
            this.imageList.ImageSize = this.sentence_iconListBox.SelectedItemImage.Size;
            this.imageList.Images.Add(this.sentence_iconListBox.SelectedItemImage);
            Win32.ImageList_BeginDrag(imageList.Handle, 0, e.X - rect.Left, e.Y - rect.Top);

            this.sentence_iconListBox.Status = 2;
            sentence_iconListBox.DoDragDrop(this.sentence_iconListBox.SelectedIndex, DragDropEffects.Move);

            Win32.ImageList_EndDrag();
        }
*/
        private void sentence_iconListBox_MouseUp(object sender, MouseEventArgs e)
        {
            if (this.sentence_iconListBox.Status == 9)
            {
                OpenEditSentenceForm();
            }
            this.sentence_iconListBox.Status = 0;
        }

        private void sentence_iconListBox_KeyDown(object sender, KeyEventArgs e)
        {
            if (this.sentence_iconListBox.SelectedIndex > -1 && e.KeyCode == Keys.Delete)
            {
                sentence_delete();
            }

        }

        private void engine_iconListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.engine_iconListBox.SelectedIndex >= 0)
            {
                EngineInfo info = EngineDicTmp[this.engine_iconListBox.Text];
                this.engine_textBox_name.Text = info.Name;
                this.engine_textBox_url.Text = info.Url;
                this.engine_textBox_searchUrl.Text = info.SearchUrl;
                this.engine_textBox_suggestUrl.Text = info.SuggestUrl;
                this.engine_textBox_shortcut.Text = HotKeyTextBox.GetKeyText(info.Shortcut);
                this.engine_textBox_encoding.Text = info.Encoding;
                this.engine_textBox_display.Text = info.Display;
                this.engine_pictureBox.Image = info.IconImage;
                this.engine_button_edit.Enabled = true;
                this.engine_button_delete.Enabled = true;
            }
            else
            {
                this.engine_textBox_name.Text = "";
                this.engine_textBox_url.Text = "";
                this.engine_textBox_searchUrl.Text = "";
                this.engine_textBox_suggestUrl.Text = "";
                this.engine_textBox_shortcut.Text = "";
                this.engine_textBox_encoding.Text = "";
                this.engine_textBox_display.Text = "";
                this.engine_textBox_comment.Text = "";
                this.engine_pictureBox.Image = null;
                this.engine_button_edit.Enabled = false;
                this.engine_button_delete.Enabled = false;
            }
        }

        private void macro_iconListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.macro_iconListBox.SelectedIndex < 0)
            {
                this.macro_textBox_id.Text = "";
                this.macro_textBox_summary.Text = "";
                this.macro_textBox_description.Text = "";
            }
            else
            {
                IconListBoxItem item = (IconListBoxItem)this.macro_iconListBox.SelectedItem;
                MacroInfo macroInfo = this.macroDicTmp[item.Name];
                this.macro_textBox_id.Text = macroInfo.Macro.Id();
                this.macro_textBox_summary.Text = macroInfo.Macro.Summary();
                this.macro_textBox_description.Text = macroInfo.Macro.Description();
            }
        }

        private void macro_textBox_shortcut_TextChanged(object sender, EventArgs e)
        {
            if (this.macro_iconListBox.SelectedIndex >= 0)
            {
                IconListBoxItem item = (IconListBoxItem)this.macro_iconListBox.SelectedItem;
                MacroInfo macroInfo = this.macroDicTmp[item.Text];
            }
        }

        private void command_delete()
        {
            if (this.command_iconListBox.Items.Count == 0)
                return;
            int index = this.command_iconListBox.SelectedIndex;
            string key = this.command_iconListBox.Text;
            this.command_iconListBox.Items.Remove(this.command_iconListBox.SelectedItem);
            this.commandListTmp.Remove(key);
            this.commandDicTmp.Remove(key);
            Program.SettingForm.ReadCommandList(true);
            if (this.command_iconListBox.Items.Count > index)
                this.command_iconListBox.SelectedIndex = index;
            else if (this.command_iconListBox.Items.Count > 0)
                this.command_iconListBox.SelectedIndex = this.command_iconListBox.Items.Count - 1;
            else
            {
                this.command_button_edit.Enabled = false;
                this.command_button_delete.Enabled = false;
            }
            this.command_iconListBox.Update();
        }

        private void sentence_delete()
        {
            if (this.sentence_iconListBox.SelectedIndex < 0)
                return;
            int index = this.sentence_iconListBox.SelectedIndex;
            this.sentenceGroupListTmp[this.sentenceRadio].RemoveAt(index);
            this.RequestSentenceListViewSelect(this.sentenceRadio, index, true);
            this.sentence_iconListBox.Update();
        }

        private void sentence_iconListBox_QueryContinueDrag(object sender, QueryContinueDragEventArgs e)
        {
            if (e.Action == DragAction.Drop)
            {
                this.sentence_iconListBox.Status = -1;
                Win32.ImageList_DragLeave(this.Handle);
                this.sentence_iconListBox.Invalidate();
            }
            else
            {
                Win32.ImageList_DragMove(Cursor.Position.X - this.Left, Cursor.Position.Y - this.Top);
            }
        }

        private void command_iconListBox_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (String[])e.Data.GetData(DataFormats.FileDrop);
            if (files != null && files.Length > 0)
            {
                string file = files[0];
                AddCommandForm form = new AddCommandForm();
                form.SetSelectedFile(file);
                this.TargetForm = form;
                Win32.PostMessage(this.Handle, Program.WM_APP_SHOWFORM, IntPtr.Zero, IntPtr.Zero);
            }
            else
            {
                Win32.ImageList_DragLeave(this.Handle);
                int srcIndex = (int)e.Data.GetData(typeof(int));
                Point p = this.command_iconListBox.PointToClient(Control.MousePosition);
                int destIndex = this.command_iconListBox.TopIndex + this.command_iconListBox.DividePoint;
                if (destIndex < 0 || srcIndex == destIndex || srcIndex == (destIndex - 1))
                    return;

                IconListBoxItem item = (IconListBoxItem)this.command_iconListBox.Items[srcIndex];

                this.command_iconListBox.Items.RemoveAt(srcIndex);
                this.commandListTmp.RemoveAt(srcIndex);
                if (destIndex > srcIndex)
                    destIndex--;
                this.command_iconListBox.Items.Insert(destIndex, item);
                this.commandListTmp.Insert(destIndex, item.Name);

                this.command_iconListBox.Invalidate();
                this.command_iconListBox.SelectedIndex = destIndex;
            }
        }

        private void command_iconListBox_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Move;
            Win32.ImageList_DragEnter(this.Handle, Cursor.Position.X - this.Left, Cursor.Position.Y - this.Top);
        }

        private void command_iconListBox_MouseDown(object sender, MouseEventArgs e)
        {
            int index = this.command_iconListBox.SelectedIndex;
            if (index < 0)
                return;

            command_iconListBox_SelectedIndexChanged(null, null);
            if (e.Clicks > 1 && e.Button == MouseButtons.Left)
                this.command_iconListBox.Status = 9;
            else
                this.command_iconListBox.Status = 1;
            IconListBox.MousePoint = e.Location;
        }

        private void command_iconListBox_MouseEnter(object sender, EventArgs e)
        {
            this.command_iconListBox.Status = 0;
        }

        private void command_iconListBox_MouseMove(object sender, MouseEventArgs e)
        {
            if (this.command_iconListBox.Status == 9)
            {
                if (IconListBox.MousePoint.X != e.Location.X || IconListBox.MousePoint.Y != e.Location.Y)
                {
                    this.command_iconListBox.BeginDragDrop(e);
                }
            }
            else if (this.command_iconListBox.Status == 1 && e.Button == MouseButtons.Left)
            {
                this.command_iconListBox.BeginDragDrop(e);
            }
        }

        private void command_iconListBox_MouseUp(object sender, MouseEventArgs e)
        {
            if (this.command_iconListBox.Status == 9)
            {
                if (this.command_iconListBox.SelectedIndex >= 0)
                    command_button_edit_Click(null, null);
            }
            this.command_iconListBox.Status = 0;
        }

        private void command_iconListBox_QueryContinueDrag(object sender, QueryContinueDragEventArgs e)
        {
            if (e.Action == DragAction.Drop)
            {
                this.command_iconListBox.Status = -1;
                Win32.ImageList_DragLeave(this.Handle);
                this.command_iconListBox.Invalidate();
            }
            else
            {
                Win32.ImageList_DragMove(Cursor.Position.X - this.Left, Cursor.Position.Y - this.Top);
            }
        }

        private void engine_iconListBox_QueryContinueDrag(object sender, QueryContinueDragEventArgs e)
        {
            if (e.Action == DragAction.Drop)
            {
                this.engine_iconListBox.Status = -1;
                Win32.ImageList_DragLeave(this.Handle);
                this.engine_iconListBox.Invalidate();
            }
            else
            {
                Win32.ImageList_DragMove(Cursor.Position.X - this.Left, Cursor.Position.Y - this.Top);
            }
        }

        private void engine_iconListBox_DragDrop(object sender, DragEventArgs e)
        {
            Win32.ImageList_DragLeave(this.Handle);
            int srcIndex = (int)e.Data.GetData(typeof(int));
            Point p = this.engine_iconListBox.PointToClient(Control.MousePosition);
            int destIndex = this.engine_iconListBox.TopIndex + this.engine_iconListBox.DividePoint;
            if (destIndex < 0 || srcIndex == destIndex || srcIndex == (destIndex - 1))
                return;

            IconListBoxItem item = (IconListBoxItem)this.engine_iconListBox.Items[srcIndex];

            this.engine_iconListBox.Items.RemoveAt(srcIndex);
            this.engineListTmp.RemoveAt(srcIndex);
            if (destIndex > srcIndex)
                destIndex--;
            this.engine_iconListBox.Items.Insert(destIndex, item);
            this.engineListTmp.Insert(destIndex, item.Name);

            this.engine_iconListBox.Invalidate();
            this.engine_iconListBox.SelectedIndex = destIndex;
        }
        
        private void engine_iconListBox_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Move;
            Win32.ImageList_DragEnter(this.Handle, Cursor.Position.X - this.Left, Cursor.Position.Y - this.Top);
        }
        
        private void engine_iconListBox_MouseDown(object sender, MouseEventArgs e)
        {
            int index = this.engine_iconListBox.SelectedIndex;
            if (index < 0)
                return;

            engine_iconListBox_SelectedIndexChanged(null, null);
            if (e.Clicks > 1 && e.Button == MouseButtons.Left)
                this.engine_iconListBox.Status = 9;
            else
                this.engine_iconListBox.Status = 1;
            IconListBox.MousePoint = e.Location;
        }

        private void engine_iconListBox_MouseEnter(object sender, EventArgs e)
        {
            this.engine_iconListBox.Status = 0;
        }

        private void engine_iconListBox_MouseMove(object sender, MouseEventArgs e)
        {
            if (this.engine_iconListBox.Status == 9)
            {
                if (IconListBox.MousePoint.X != e.Location.X || IconListBox.MousePoint.Y != e.Location.Y)
                {
                    this.engine_iconListBox.BeginDragDrop(e);
                }
            }
            else if (this.engine_iconListBox.Status == 1 && e.Button == MouseButtons.Left)
            {
                this.engine_iconListBox.BeginDragDrop(e);
            }
        }

        private void engine_iconListBox_MouseUp(object sender, MouseEventArgs e)
        {
            if (this.engine_iconListBox.Status == 9)
            {
                if (this.engine_iconListBox.SelectedIndex >= 0)
                {
                    OpenEditEngineForm();
                }
            }
            this.engine_iconListBox.Status = 0;
        }

        private void sentence_iconListBox_DragEnter_1(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Move;
            Win32.ImageList_DragEnter(this.Handle, Cursor.Position.X - this.Left, Cursor.Position.Y - this.Top);
        }

        private void engine_button_new_Click(object sender, EventArgs e)
        {
            new AddEngineForm().ShowDialog();
        }

        private void engine_button_delete_Click(object sender, EventArgs e)
        {
            string key = this.engine_iconListBox.Text;
            int index = this.engineListTmp.IndexOf(key);
            int selectedIndex = this.engine_iconListBox.SelectedIndex;
            this.engineListTmp.RemoveAt(index);
            this.engineListTmp.Add("@" + this.engine_iconListBox.Text);
            //this.engineListTmp[index] = "@" + this.engine_iconListBox.Text;

            EngineInfo info = this.engineDicTmp[key];
            info.Name = "@" + this.engine_iconListBox.Text;
            info.Removed = true;
            this.engineDicTmp.Remove(key);
            this.EngineDicTmp.Add(info.Name, info);

            Program.SettingForm.ReadEngineList(true);
            if (this.engine_iconListBox.Items.Count > selectedIndex)
                this.engine_iconListBox.SelectedIndex = selectedIndex;
            else if (this.engine_iconListBox.Items.Count > 0)
                this.engine_iconListBox.SelectedIndex = this.engine_iconListBox.Items.Count - 1;
            else
            {
                this.engine_button_edit.Enabled = false;
                this.engine_button_delete.Enabled = false;
            }
            this.engine_iconListBox.Update();
        }

        private void engine_button_edit_Click(object sender, EventArgs e)
        {
            OpenEditEngineForm();
        }

        public void OpenEditEngineForm()
        {
            if (this.engine_iconListBox.SelectedIndex < 0)
                return;

            EngineInfo info = this.EngineDicTmp[this.engine_iconListBox.Text];
            EditEngineForm form = new EditEngineForm(info);
            form.ShowDialog();
        }
    
    }
}