package jp.sourceforge.pdt_tools.callhierarchy;

import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.search.IDLTKSearchScope;

public class CalleeProcessor implements ICalleeProcessor {

	private IMethod method;
	private IProgressMonitor monitor;
	private IDLTKSearchScope scope;

	public CalleeProcessor(IMethod method, IProgressMonitor monitor,
			IDLTKSearchScope scope) {
		this.method = method;
		this.monitor = monitor;
		this.scope = scope;
	}

	@SuppressWarnings("rawtypes")
	public Map doOperation() {
		FindCalleeVisitor visitor = new FindCalleeVisitor();
		return visitor.find(method, monitor, scope);
	}

}
