package jp.sourceforge.pdt_tools.codeFolding;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
@SuppressWarnings("restriction")
public class CodeFolding extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.sourceforge.pdt_tools.codeFolding";

	// The shared instance
	private static CodeFolding plugin;

	public static final String PROVIDER_ID = PLUGIN_ID + ".provider";
	private PropertyChangeListener listener;
	private static boolean enabled = false;

	/**
	 * The constructor
	 */
	public CodeFolding() {
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		listener = new PropertyChangeListener();
		IPreferenceStore pref = PreferenceConstants.getPreferenceStore();
		enabled = pref.getBoolean(PreferenceConstants.EDITOR_FOLDING_ENABLED)
				&& pref.getString(PreferenceConstants.EDITOR_FOLDING_PROVIDER)
						.equals(PROVIDER_ID);
		pref.addPropertyChangeListener(listener);
	}

	public void stop(BundleContext context) throws Exception {
		IPreferenceStore pref = PreferenceConstants.getPreferenceStore();
		pref.removePropertyChangeListener(listener);
		listener = null;
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static CodeFolding getDefault() {
		return plugin;
	}

	public static void log(Throwable e) {
		log(IStatus.ERROR, e.getLocalizedMessage());
	}

	public static void log(int severity, String message) {
		Status status = new Status(severity, PLUGIN_ID, message);
		getDefault().getLog().log(status);
	}

	public boolean isEnabled() {
		return enabled;
	}

	private static class PropertyChangeListener implements
			IPropertyChangeListener {

		public void propertyChange(PropertyChangeEvent event) {
			String property = event.getProperty();
			if (property.equals(PreferenceConstants.EDITOR_FOLDING_PROVIDER)) {
				enabled = event.getNewValue().equals(PROVIDER_ID);
			} else if (property
					.equals(PreferenceConstants.EDITOR_FOLDING_ENABLED)) {
				Object value = event.getNewValue();
				if (value instanceof Boolean) {
					enabled = (Boolean) value;
				} else if (value instanceof String) {
					enabled = Boolean.valueOf((String) value);
				}
			}
		}

	}

}
