package jp.sourceforge.pdt_tools.compare;

import java.lang.reflect.Field;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;

public class Startup implements IStartup {

	public void earlyStartup() {
		IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = extensionRegistry
				.getExtensionPoint("org.eclipse.compare.contentMergeViewers");
		IExtension[] extensions = extensionPoint.getExtensions();
		for (IExtension extension : extensions) {
			if (extension.getContributor().getName()
					.equals("org.eclipse.php.ui")) {
				try {
					Field masterToken = extensionRegistry.getClass()
							.getDeclaredField("masterToken");
					masterToken.setAccessible(true);
					extensionRegistry.removeExtension(extension,
							masterToken.get(extensionRegistry));
				} catch (SecurityException e) {
					Activator.log(e);
				} catch (NoSuchFieldException e) {
					Activator.log(e);
				} catch (IllegalArgumentException e) {
					Activator.log(e);
				} catch (IllegalAccessException e) {
					Activator.log(e);
				}
				break;
			}
		}
	}

}
