package jp.sourceforge.pdt_tools.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredPartitioning;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.validation.ValidationFramework;

@SuppressWarnings("restriction")
public class PHPMergeViewer extends TextMergeViewer {

	public PHPMergeViewer(Composite parent, CompareConfiguration configuration) {
		super(parent, configuration);
	}

	@Override
	protected void configureTextViewer(TextViewer textViewer) {
		if (textViewer instanceof SourceViewer) {
			((SourceViewer) textViewer)
					.configure(new PHPStructuredTextViewerConfiguration());
		}
	}

	@Override
	protected SourceViewer createSourceViewer(Composite parent,
			int textOrientation) {
		return new StructuredTextViewer(parent, null, null, false,
				textOrientation | SWT.H_SCROLL | SWT.V_SCROLL);
	}

	@Override
	protected IDocument customizeDocument(IDocument document) {
		if (document instanceof IStructuredDocument) {
			return document;
		}
		IStructuredDocument newDoc = StructuredModelManager.getModelManager()
				.createStructuredDocumentFor(
						ContentTypeIdForPHP.ContentTypeID_PHP);
		newDoc.set(document != null ? document.get() : ""); //$NON-NLS-1$
		return newDoc;
	}

	@Override
	public IDocumentPartitioner getDocumentPartitioner() {
		return new PHPStructuredTextPartitioner();
	}

	@Override
	protected String getDocumentPartitioning() {
		return IStructuredPartitioning.DEFAULT_STRUCTURED_PARTITIONING;
	}

	@Override
	public String getTitle() {
		return Messages.PHPMergeViewer_title;
	}

	@Override
	protected void updateContent(Object ancestor, Object left, Object right) {
		try {
			ValidationFramework.getDefault().join(new NullProgressMonitor());
		} catch (OperationCanceledException e) {
		} catch (InterruptedException e) {
		}
		super.updateContent(ancestor, left, right);
	}
}
