package jp.sourceforge.pdt_tools.variablefilter;

import java.util.LinkedList;
import java.util.List;

import jp.sourceforge.pdt_tools.variablefilter.preferences.PreferenceConstants;

import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class VariablesViewerFilter extends ViewerFilter {

	private List<VariableFilter> variableFilters;

	public VariablesViewerFilter() {
		update();
	}

	public void update() {
		IPreferenceStore store = VariableFilterPlugin.getDefault()
				.getPreferenceStore();
		variableFilters = new LinkedList<VariableFilter>();
		int count = store.getInt(PreferenceConstants.FILTERS);
		for (int i = 0; i < count; i++) {
			String key = PreferenceConstants.FILTER + i;
			int type = store.getInt(key + PreferenceConstants.TYPE);
			String pattern = store.getString(key + PreferenceConstants.PATTERN);
			boolean regex = store.getBoolean(key + PreferenceConstants.REGEX);
			boolean enabled = store.getBoolean(key
					+ PreferenceConstants.ENABLED);
			variableFilters.add(new VariableFilter(type, pattern, regex,
					enabled));
		}
	}

	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (element instanceof IVariable) {
			for (VariableFilter variableFilter : variableFilters) {
				if (variableFilter.isFiltered((IVariable) element)) {
					return false;
				}
			}
		}
		return true;
	}
}
