package jp.sourceforge.pdt_tools.codeChecker;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class CodeCheckerPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.sourceforge.pdt_tools.codeChecker"; //$NON-NLS-1$

	// The problem marker ID
	public static final String MARKER_ID = "jp.sourceforge.pdt_tools.codeChecker.problem"; //$NON-NLS-1$

	// The shared instance
	private static CodeCheckerPlugin plugin;

	public CodeCheckerPlugin() {
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	public static CodeCheckerPlugin getDefault() {
		return plugin;
	}

	public static void log(Throwable e) {
		String loc = new Exception().getStackTrace()[1].toString();
		String err = e.getLocalizedMessage();
		if (err == null) {
			err = e.getClass().getName();
		}
		String msg = err + "\nat " + loc;
		getDefault().getLog().log(new Status(IStatus.ERROR, PLUGIN_ID, msg));
	}

	public static void log(Throwable e, String s) {
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		PrintStream ps = new PrintStream(os);
		e.printStackTrace(ps);
		ps.close();
		String msg = s + "\n" + os.toString();
		getDefault().getLog().log(new Status(IStatus.ERROR, PLUGIN_ID, msg));
	}

	public static void log(int severity, String s) {
		String loc = new Exception().getStackTrace()[1].toString();
		String msg = s + "\nat " + loc;
		getDefault().getLog().log(new Status(severity, PLUGIN_ID, msg));
	}
}
