package jp.sourceforge.pdt_tools.codeChecker;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ProblemMarker {

	protected int severity;
	protected int start;
	protected int end;
	protected int line;
	protected String msg;
	protected IResource resource;

	public ProblemMarker(int severity, String msg, int start, int end,
			int line, IResource resource) {
		this.severity = severity;
		this.msg = msg;
		this.start = start;
		this.end = end;
		this.line = line;
		this.resource = resource;
	}

	public void commit() throws CoreException {
		IMarker marker = resource.createMarker(CodeCheckerPlugin.MARKER_ID);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(IMarker.SEVERITY, severity);
		map.put(IMarker.MESSAGE, msg);
		map.put(IMarker.LINE_NUMBER, line);
		map.put(IMarker.CHAR_START, start);
		map.put(IMarker.CHAR_END, end);
		marker.setAttributes(map);
	}

	public boolean equals(IMarker marker) {
		if (marker.getAttribute(IMarker.SEVERITY, 0) == severity
				&& marker.getAttribute(IMarker.LINE_NUMBER, 0) == line
				&& marker.getAttribute(IMarker.CHAR_START, 0) == start
				&& marker.getAttribute(IMarker.CHAR_END, 0) == end
				&& marker.getAttribute(IMarker.MESSAGE, "").equals(msg)) {
			return true;
		}
		return false;
	}

	public boolean equals(ProblemMarker marker) {
		if (marker.severity == severity && marker.line == line
				&& marker.start == start && marker.end == end
				&& marker.msg.equals(msg)) {
			return true;
		}
		return false;
	}

}
