/*******************************************************************************
 * Copyright (c) 2000, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Benjamin Muskalla <b.muskalla@gmx.net> - [preferences] Add preference for new compiler warning: MissingSynchronizedModifierInInheritedMethod - https://bugs.eclipse.org/bugs/show_bug.cgi?id=245240
 *******************************************************************************/
package jp.sourceforge.pdt_tools.codeChecker.preferences;

import jp.sourceforge.pdt_tools.codeChecker.CodeCheckerOptions;
import jp.sourceforge.pdt_tools.codeChecker.CodeCheckerPlugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.ScrolledPageContent;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/**
 * @see org.eclipse.jdt.internal.ui.preferences.ProblemSeveritiesConfigurationBlock
 */
public class ProblemSeveritiesConfigurationBlock extends
		PHPCoreOptionsConfigurationBlock {

	private static final String SETTINGS_SECTION_NAME = "ProblemSeveritiesConfigurationBlock"; //$NON-NLS-1$

	// code style
	private static final Key PREF_STATIC_ACCESS_RECEIVER = getKey(CodeCheckerOptions.PROBLEM_STATIC_ACCESS_RECEIVER);
	private static final Key PREF_NON_STATIC_METHOD = getKey(CodeCheckerOptions.PROBLEM_NON_STATIC_METHOD);

	// potential programming problems
	private static final Key PREF_UNRESOLVED_TYPES = getKey(CodeCheckerOptions.PROBLEM_UNRESOLVED_TYPES);
	private static final Key PREF_UNRESOLVED_METHODS = getKey(CodeCheckerOptions.PROBLEM_UNRESOLVED_METHODS);
	private static final Key PREF_UNRESOLVED_FIELDS = getKey(CodeCheckerOptions.PROBLEM_UNRESOLVED_FIELDS);
	private static final Key PREF_UNRESOLVED_FUNCTIONS = getKey(CodeCheckerOptions.PROBLEM_UNRESOLVED_FUNCTIONS);
	private static final Key PREF_REDECLARED_TYPES = getKey(CodeCheckerOptions.PROBLEM_REDECLARED_TYPES);
	private static final Key PREF_REDECLARED_METHODS = getKey(CodeCheckerOptions.PROBLEM_REDECLARED_METHODS);
	private static final Key PREF_REDECLARED_FIELDS = getKey(CodeCheckerOptions.PROBLEM_REDECLARED_FIELDS);
	private static final Key PREF_REDECLARED_FUNCTIONS = getKey(CodeCheckerOptions.PROBLEM_REDECLARED_FUNCTIONS);
	private static final Key PREF_FALLTHROUGH_CASE = getKey(CodeCheckerOptions.PROBLEM_FALLTHROUGH_CASE);
	private static final Key PREF_MISSING_ARGUMENTS = getKey(CodeCheckerOptions.PROBLEM_MISSING_ARGUMENTS);
	private static final Key PREF_INCOMPATIBLE_METHOD = getKey(CodeCheckerOptions.PROBLEM_INCOMPATIBLE_METHOD);
	private static final Key PREF_OVERRIDE_FINAL_METHOD = getKey(CodeCheckerOptions.PROBLEM_OVERRIDE_FINAL_METHOD);
	private static final Key PREF_INCLUDE_NOT_FOUND = getKey(CodeCheckerOptions.PROBLEM_INCLUDE_NOT_FOUND);
	private static final Key PREF_UNINITIALIZED_VARIABLE = getKey(CodeCheckerOptions.PROBLEM_UNINITIALIZED_VARIABLE);
	private static final Key PREF_MISC_ERROR = getKey(CodeCheckerOptions.PROBLEM_MISC_ERROR);
	private static final Key PREF_MISC_WARNING = getKey(CodeCheckerOptions.PROBLEM_MISC_WARNING);
	private static final Key PREF_MISC_STRICT = getKey(CodeCheckerOptions.PROBLEM_MISC_STRICT);

	// deprecation and access rule
	private static final Key PREF_DEPRECATION = getKey(CodeCheckerOptions.PROBLEM_DEPRECATION);

	// unnecessary code
	private static final Key PREF_UNUSED_LOCAL = getKey(CodeCheckerOptions.PROBLEM_UNUSED_LOCAL);
	private static final Key PREF_UNUSED_PARAMETER = getKey(CodeCheckerOptions.PROBLEM_UNUSED_PARAMETER);
	private static final Key PREF_UNUSED_PRIVATE = getKey(CodeCheckerOptions.PROBLEM_UNUSED_PRIVATE_MEMBER);

	// realtime detection
	private static final Key PREF_REALTIME_DETECTION = getKey(CodeCheckerOptions.REALTIME_DETECTION);

	// values
	private static final String ERROR = CodeCheckerOptions.ERROR;
	private static final String WARNING = CodeCheckerOptions.WARNING;
	private static final String IGNORE = CodeCheckerOptions.IGNORE;

	private static final String ENABLED = CodeCheckerOptions.ENABLED;
	private static final String DISABLED = CodeCheckerOptions.DISABLED;

	private PixelConverter fPixelConverter;

	public ProblemSeveritiesConfigurationBlock(IStatusChangeListener context,
			IProject project, IWorkbenchPreferenceContainer container) {
		super(context, project, getKeys(), container);
	}

	public static Key[] getKeys() {
		return new Key[] {
				// code style
				PREF_STATIC_ACCESS_RECEIVER, //
				PREF_NON_STATIC_METHOD, //
				// potential programming problems
				PREF_UNRESOLVED_TYPES, //
				PREF_UNRESOLVED_METHODS, //
				PREF_UNRESOLVED_FIELDS, //
				PREF_UNRESOLVED_FUNCTIONS, //
				PREF_REDECLARED_TYPES, //
				PREF_REDECLARED_METHODS, //
				PREF_REDECLARED_FIELDS, //
				PREF_REDECLARED_FUNCTIONS, //
				PREF_FALLTHROUGH_CASE, //
				PREF_MISSING_ARGUMENTS, //
				PREF_INCOMPATIBLE_METHOD, //
				PREF_OVERRIDE_FINAL_METHOD, //
				PREF_INCLUDE_NOT_FOUND, //
				PREF_UNINITIALIZED_VARIABLE, //
				PREF_MISC_ERROR, //
				PREF_MISC_WARNING, //
				PREF_MISC_STRICT, //
				// deprecation
				PREF_DEPRECATION, //
				// unnecessary code
				PREF_UNUSED_LOCAL, //
				PREF_UNUSED_PARAMETER, //
				PREF_UNUSED_PRIVATE, //
				// realtime detection
				PREF_REALTIME_DETECTION //
		};
	}

	protected Control createContents(Composite parent) {
		fPixelConverter = new PixelConverter(parent);
		setShell(parent.getShell());

		Composite mainComp = new Composite(parent, SWT.NONE);
		mainComp.setFont(parent.getFont());
		GridLayout layout = new GridLayout();
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		mainComp.setLayout(layout);

		Composite commonComposite = createStyleTabContent(mainComp);
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		gridData.heightHint = fPixelConverter.convertHeightInCharsToPixels(20);
		commonComposite.setLayoutData(gridData);

		validateSettings(null, null, null);

		return mainComp;
	}

	private Composite createStyleTabContent(Composite folder) {
		String[] errorWarningIgnore = new String[] { ERROR, WARNING, IGNORE };

		String[] errorWarningIgnoreLabels = new String[] {
				PreferenceMessages.ProblemSeveritiesConfigurationBlock_error,
				PreferenceMessages.ProblemSeveritiesConfigurationBlock_warning,
				PreferenceMessages.ProblemSeveritiesConfigurationBlock_ignore };

		String[] enabledDisabled = new String[] { ENABLED, DISABLED };
		// String[] disabledEnabled = new String[] { DISABLED, ENABLED };

		int nColumns = 3;

		final ScrolledPageContent sc1 = new ScrolledPageContent(folder);

		Composite composite = sc1.getBody();
		GridLayout layout = new GridLayout(nColumns, false);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		composite.setLayout(layout);

		Label description = new Label(composite, SWT.LEFT | SWT.WRAP);
		description.setFont(description.getFont());
		description
				.setText(PreferenceMessages.ProblemSeveritiesConfigurationBlock_common_description);
		description.setLayoutData(new GridData(GridData.BEGINNING,
				GridData.CENTER, true, false, nColumns - 1, 1));

		int indentStep = fPixelConverter.convertWidthInCharsToPixels(1);

		int defaultIndent = indentStep * 0;
		// int extraIndent = indentStep * 3;
		String label;
		ExpandableComposite excomposite;
		Composite inner;

		// --- code style

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_section_code_style;
		excomposite = createStyleSection(composite, label, nColumns);

		inner = new Composite(excomposite, SWT.NONE);
		inner.setFont(composite.getFont());
		inner.setLayout(new GridLayout(nColumns, false));
		excomposite.setClient(inner);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_static_access_receiver_label;
		addComboBox(inner, label, PREF_STATIC_ACCESS_RECEIVER,
				errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_non_static_method_label;
		addComboBox(inner, label, PREF_NON_STATIC_METHOD, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		// --- potential programming problems

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_section_potential_programming_problems;
		excomposite = createStyleSection(composite, label, nColumns);

		inner = new Composite(excomposite, SWT.NONE);
		inner.setFont(composite.getFont());
		inner.setLayout(new GridLayout(nColumns, false));
		excomposite.setClient(inner);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_unresolved_types_label;
		addComboBox(inner, label, PREF_UNRESOLVED_TYPES, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_unresolved_methods_label;
		addComboBox(inner, label, PREF_UNRESOLVED_METHODS, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_unresolved_fields_label;
		addComboBox(inner, label, PREF_UNRESOLVED_FIELDS, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_unresolved_functions_label;
		addComboBox(inner, label, PREF_UNRESOLVED_FUNCTIONS,
				errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_redeclared_types_label;
		addComboBox(inner, label, PREF_REDECLARED_TYPES, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_redeclared_methods_label;
		addComboBox(inner, label, PREF_REDECLARED_METHODS, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_redeclared_fields_label;
		addComboBox(inner, label, PREF_REDECLARED_FIELDS, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_redeclared_functions_label;
		addComboBox(inner, label, PREF_REDECLARED_FUNCTIONS,
				errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_fall_through_case_label;
		addComboBox(inner, label, PREF_FALLTHROUGH_CASE, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_missing_arguments_label;
		addComboBox(inner, label, PREF_MISSING_ARGUMENTS, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_incompatible_method_label;
		addComboBox(inner, label, PREF_INCOMPATIBLE_METHOD, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_override_final_method_label;
		addComboBox(inner, label, PREF_OVERRIDE_FINAL_METHOD,
				errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_include_not_found_label;
		addComboBox(inner, label, PREF_INCLUDE_NOT_FOUND, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_uninitialized_variable_label;
		addComboBox(inner, label, PREF_UNINITIALIZED_VARIABLE,
				errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_misc_error_label;
		addComboBox(inner, label, PREF_MISC_ERROR, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_misc_warning_label;
		addComboBox(inner, label, PREF_MISC_WARNING, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_misc_strict_label;
		addComboBox(inner, label, PREF_MISC_STRICT, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		// --- deprecation and access rule

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_section_deprecations;
		excomposite = createStyleSection(composite, label, nColumns);

		inner = new Composite(excomposite, SWT.NONE);
		inner.setFont(composite.getFont());
		inner.setLayout(new GridLayout(nColumns, false));
		excomposite.setClient(inner);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_deprecation_label;
		addComboBox(inner, label, PREF_DEPRECATION, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		// --- unnecessary code

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_section_unnecessary_code;
		excomposite = createStyleSection(composite, label, nColumns);

		inner = new Composite(excomposite, SWT.NONE);
		inner.setFont(composite.getFont());
		inner.setLayout(new GridLayout(nColumns, false));
		excomposite.setClient(inner);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_unused_local_label;
		addComboBox(inner, label, PREF_UNUSED_LOCAL, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_unused_parameter_label;
		addComboBox(inner, label, PREF_UNUSED_PARAMETER, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_unused_private_label;
		addComboBox(inner, label, PREF_UNUSED_PRIVATE, errorWarningIgnore,
				errorWarningIgnoreLabels, defaultIndent);

		// --- realtime detection

		label = PreferenceMessages.ProblemSeveritiesConfigurationBlock_realtime_detection;
		addCheckBox(composite, label, PREF_REALTIME_DETECTION, enabledDisabled,
				defaultIndent);

		IDialogSettings section = CodeCheckerPlugin.getDefault()
				.getDialogSettings().getSection(SETTINGS_SECTION_NAME);
		restoreSectionExpansionStates(section);

		return sc1;
	}

	/*
	 * (non-javadoc) Update fields and validate.
	 * 
	 * @param changedKey Key that changed, or null, if all changed.
	 */
	protected void validateSettings(Key changedKey, String oldValue,
			String newValue) {
		updateEnableStates();
		fContext.statusChanged(new StatusInfo());
	}

	private void updateEnableStates() {
	}

	protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
		String title = PreferenceMessages.ProblemSeveritiesConfigurationBlock_needsbuild_title;
		String message;
		if (workspaceSettings) {
			message = PreferenceMessages.ProblemSeveritiesConfigurationBlock_needsfullbuild_message;
		} else {
			message = PreferenceMessages.ProblemSeveritiesConfigurationBlock_needsprojectbuild_message;
		}
		return new String[] { title, message };
	}

	public void dispose() {
		IDialogSettings section = CodeCheckerPlugin.getDefault()
				.getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
		storeSectionExpansionStates(section);
		super.dispose();
	}

	private static Key getKey(String key) {
		return getKey(CodeCheckerPlugin.PLUGIN_ID, key);
	}

}
