package jp.sourceforge.pdt_tools.codeChecker;

import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class CodeCheckerOptions extends AbstractPreferenceInitializer {

	// code style

	/**
	 * E_STRICT "Accessing static property %s::$%s as non static"
	 */
	public static final String PROBLEM_STATIC_ACCESS_RECEIVER = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.staticAccessReceiver"; //$NON-NLS-1$
	/**
	 * E_STRICT "Non-static method %s::%s() should not be called statically"
	 */
	public static final String PROBLEM_NON_STATIC_METHOD = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.nonStaticMethod"; //$NON-NLS-1$

	// potential programming problems

	/**
	 * E_ERROR "Class '%s' not found" <br>
	 * E_ERROR "Interface '%s' not found"
	 */
	public static final String PROBLEM_UNRESOLVED_TYPES = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.unresolvedTypes"; //$NON-NLS-1$
	/**
	 * "Fatal error: Call to undefined method Foo::bar()"
	 */
	public static final String PROBLEM_UNRESOLVED_METHODS = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.unresolvedMethods"; //$NON-NLS-1$
	/**
	 * "Notice: Undefined property: Foo::$bar"
	 */
	public static final String PROBLEM_UNRESOLVED_FIELDS = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.unresolvedFields"; //$NON-NLS-1$
	/**
	 * "Fatal error: Call to undefined function foobar()"
	 */
	public static final String PROBLEM_UNRESOLVED_FUNCTIONS = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.unresolvedFunctions"; //$NON-NLS-1$
	/**
	 * E_COMPILE_ERROR "Cannot redeclare class %s"<br>
	 * E_WARNING "Cannot redeclare class %s"
	 */
	public static final String PROBLEM_REDECLARED_TYPES = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.redeclaredTypes"; //$NON-NLS-1$
	/**
	 * E_COMPILE_ERROR "Cannot redeclare %s::%s()"
	 */
	public static final String PROBLEM_REDECLARED_METHODS = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.redeclaredMethods"; //$NON-NLS-1$
	/**
	 * E_COMPILE_ERROR "Cannot redeclare %s::$%s"
	 */
	public static final String PROBLEM_REDECLARED_FIELDS = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.redeclaredFields"; //$NON-NLS-1$
	/**
	 * error_level "Cannot redeclare %s() (previously declared in %s:%d)"
	 */
	public static final String PROBLEM_REDECLARED_FUNCTIONS = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.redeclaredFunctions"; //$NON-NLS-1$
	/**
	 * ...
	 */
	public static final String PROBLEM_FALLTHROUGH_CASE = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.fallthroughCase"; //$NON-NLS-1$
	/**
	 * E_WARNING
	 * "Missing argument %ld for %s%s%s(), called in %s on line %d and defined"
	 */
	public static final String PROBLEM_MISSING_ARGUMENTS = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.missingArguments"; //$NON-NLS-1$
	/**
	 * E_COMPILE_ERROR
	 * "Declaration of %s::%s() must be compatible with that of %s::%s()"
	 */
	public static final String PROBLEM_INCOMPATIBLE_METHOD = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.incompatibleMethod"; //$NON-NLS-1$
	/**
	 * E_COMPILE_ERROR
	 */
	public static final String PROBLEM_OVERRIDE_FINAL_METHOD = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.overrideFinalMethod"; //$NON-NLS-1$
	/**
	 * (cannot find include file)
	 */
	public static final String PROBLEM_INCLUDE_NOT_FOUND = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.includeNotFound"; //$NON-NLS-1$
	/**
	 * uninitialized variable
	 */
	public static final String PROBLEM_UNINITIALIZED_VARIABLE = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.uninitializedVariable"; //$NON-NLS-1$
	/**
	 * miscellaneous error
	 */
	public static final String PROBLEM_MISC_ERROR = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.miscError"; //$NON-NLS-1$
	/**
	 * miscellaneous warning
	 */
	public static final String PROBLEM_MISC_WARNING = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.miscWarning"; //$NON-NLS-1$
	/**
	 * miscellaneous strict
	 */
	public static final String PROBLEM_MISC_STRICT = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.miscStrict"; //$NON-NLS-1$

	// deprecation

	public static final String PROBLEM_DEPRECATION = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.deprecation"; //$NON-NLS-1$

	// unnecessary code

	public static final String PROBLEM_UNUSED_LOCAL = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.unusedLocal"; //$NON-NLS-1$
	public static final String PROBLEM_UNUSED_PARAMETER = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.unusedParameter"; //$NON-NLS-1$
	public static final String PROBLEM_UNUSED_PRIVATE_MEMBER = CodeCheckerPlugin.PLUGIN_ID
			+ ".problem.unusedPrivateMember"; //$NON-NLS-1$

	public static final String ERROR = "error"; //$NON-NLS-1$
	public static final String WARNING = "warning"; //$NON-NLS-1$
	public static final String IGNORE = "ignore"; //$NON-NLS-1$

	public static final String ENABLED = "enabled"; //$NON-NLS-1$
	public static final String DISABLED = "disabled"; //$NON-NLS-1$

	public static final String REALTIME_DETECTION = CodeCheckerPlugin.PLUGIN_ID
			+ ".realtimeDetection"; //$NON-NLS-1$

	@Override
	public void initializeDefaultPreferences() {
		IPreferenceStore store = CodeCheckerPlugin.getDefault()
				.getPreferenceStore();

		store.setDefault(PROBLEM_STATIC_ACCESS_RECEIVER, WARNING);
		store.setDefault(PROBLEM_NON_STATIC_METHOD, WARNING);

		store.setDefault(PROBLEM_UNRESOLVED_TYPES, WARNING);
		store.setDefault(PROBLEM_UNRESOLVED_METHODS, WARNING);
		store.setDefault(PROBLEM_UNRESOLVED_FIELDS, WARNING);
		store.setDefault(PROBLEM_UNRESOLVED_FUNCTIONS, WARNING);
		store.setDefault(PROBLEM_REDECLARED_TYPES, WARNING);
		store.setDefault(PROBLEM_REDECLARED_METHODS, WARNING);
		store.setDefault(PROBLEM_REDECLARED_FIELDS, WARNING);
		store.setDefault(PROBLEM_REDECLARED_FUNCTIONS, WARNING);
		store.setDefault(PROBLEM_FALLTHROUGH_CASE, WARNING);
		store.setDefault(PROBLEM_MISSING_ARGUMENTS, WARNING);
		store.setDefault(PROBLEM_INCOMPATIBLE_METHOD, WARNING);
		store.setDefault(PROBLEM_OVERRIDE_FINAL_METHOD, WARNING);
		store.setDefault(PROBLEM_INCLUDE_NOT_FOUND, WARNING);
		store.setDefault(PROBLEM_UNINITIALIZED_VARIABLE, WARNING);
		store.setDefault(PROBLEM_MISC_ERROR, WARNING);
		store.setDefault(PROBLEM_MISC_WARNING, WARNING);
		store.setDefault(PROBLEM_MISC_STRICT, WARNING);

		store.setDefault(PROBLEM_DEPRECATION, WARNING);

		store.setDefault(PROBLEM_UNUSED_LOCAL, WARNING);
		store.setDefault(PROBLEM_UNUSED_PARAMETER, WARNING);
		store.setDefault(PROBLEM_UNUSED_PRIVATE_MEMBER, WARNING);

		store.setDefault(REALTIME_DETECTION, DISABLED);
	}

	public static boolean realtimeDetectionEnabled(IScriptProject project) {
		PreferencesService service = PreferencesService.getDefault();
		IScopeContext[] contexts = (project != null) ? new IScopeContext[] {
				new ProjectScope(project.getProject()), InstanceScope.INSTANCE }
				: new IScopeContext[] { InstanceScope.INSTANCE };
		boolean realtime_detection = getOptionBoolean(service, contexts,
				CodeCheckerOptions.REALTIME_DETECTION);
		return realtime_detection;
	}

	private static boolean getOptionBoolean(PreferencesService service,
			IScopeContext[] contexts, String key) {
		String value = service.getString(CodeCheckerPlugin.PLUGIN_ID, key,
				CodeCheckerOptions.DISABLED, contexts);
		return value.equals(CodeCheckerOptions.ENABLED);
	}
}
