/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.registry.BufferedRandomInputStream;
import org.eclipse.php.internal.core.phar.Messages;
import org.eclipse.php.internal.core.phar.PharEntry;

public class PharEntryBufferedRandomInputStream
extends InputStream {
    private PharEntry pharEntry;
    protected int currentIndex;
    private int totalLength;
    private BufferedRandomInputStream bufferedRandomInputStream;

    public PharEntryBufferedRandomInputStream(File file, PharEntry pharEntry) throws IOException {
        this.bufferedRandomInputStream = new BufferedRandomInputStream(file);
        this.pharEntry = pharEntry;
        this.totalLength = pharEntry.getCsize();
        if (this.bufferedRandomInputStream.skip((long)pharEntry.getPosition()) != (long)pharEntry.getPosition()) {
            throw new IOException(Messages.PharEntry_Too_Long);
        }
    }

    public int read() throws IOException {
        ++this.currentIndex;
        if (this.currentIndex == this.totalLength) {
            return -1;
        }
        return this.bufferedRandomInputStream.read();
    }

    public long skip(long n) throws IOException {
        return this.bufferedRandomInputStream.skip(n);
    }

    public int read(byte[] b2) throws IOException {
        return super.read(b2);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int readLength = this.totalLength - this.currentIndex;
        if (readLength <= 0) {
            return -1;
        }
        if (readLength < len) {
            len = readLength;
        } else {
            readLength = len;
        }
        this.currentIndex += readLength;
        int result = this.bufferedRandomInputStream.read(b2, off, len);
        return result;
    }

    public void close() throws IOException {
        this.bufferedRandomInputStream.close();
    }

    public boolean isEnd() {
        return this.totalLength == this.currentIndex;
    }
}

