/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.includepath.IIncludepathListener;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.phar.PharPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPSearchEngine
implements IIncludepathListener {
    private static Pattern RELATIVE_PATH_PATTERN = Pattern.compile("\\.\\.?[/\\\\].*");
    private Map<IProject, IncludePath[]> projectIncludePaths = new HashMap<IProject, IncludePath[]>();
    private static PHPSearchEngine instance = new PHPSearchEngine();

    private PHPSearchEngine() {
        IncludePathManager.getInstance().registerIncludepathListener(this);
    }

    private static PHPSearchEngine getInstance() {
        return instance;
    }

    public static Result<?, ?> find(String path, String currentWorkingDir, String currentScriptDir, IProject currentProject) {
        return PHPSearchEngine.getInstance().internalFind(path, currentWorkingDir, currentScriptDir, currentProject);
    }

    private Result<?, ?> internalFind(String path, String currentWorkingDir, String currentScriptDir, IProject currentProject) {
        IncludePath[] includePaths;
        if (path == null || currentWorkingDir == null || currentScriptDir == null || currentProject == null) {
            throw new NullPointerException("Parameters can't be null");
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(file);
        }
        if (RELATIVE_PATH_PATTERN.matcher(path).matches()) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(currentWorkingDir, path);
        }
        IncludePath[] includePathArray = includePaths = PHPSearchEngine.buildIncludePath(currentProject);
        int n = includePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IncludePath includePath = includePathArray[n2];
            if (includePath.isBuildpath()) {
                Result<?, ?> searchInBuildpathEntry = PHPSearchEngine.searchInBuildpathEntry(path, (IBuildpathEntry)includePath.getEntry(), currentProject);
                if (searchInBuildpathEntry != null) {
                    return searchInBuildpathEntry;
                }
            } else {
                IContainer container = (IContainer)includePath.getEntry();
                IResource resource = container.findMember(path);
                if (resource instanceof IFile) {
                    return new ResourceResult((IFile)resource);
                }
            }
            ++n2;
        }
        return PHPSearchEngine.searchExternalOrWorkspaceFile(currentScriptDir, path);
    }

    private static Result<?, ?> searchInBuildpathEntry(String path, IBuildpathEntry entry, IProject currentProject) {
        IPath entryPath = EnvironmentPathUtils.getLocalPath((IPath)entry.getPath());
        if (entry.getEntryKind() == 1) {
            File entryDir;
            File file;
            IScriptProject scriptProject = DLTKCore.create((IProject)currentProject);
            IProjectFragment[] projectFragments = scriptProject.findProjectFragments(entry);
            if (projectFragments != null && projectFragments.length > 0 && projectFragments[0] instanceof ArchiveProjectFragment) {
                PharPath pharPath;
                ArchiveProjectFragment apf = (ArchiveProjectFragment)projectFragments[0];
                boolean external = false;
                IPath apfp = apf.getPath();
                if (EnvironmentPathUtils.isFull((IPath)apfp)) {
                    apfp = EnvironmentPathUtils.getLocalPath((IPath)apfp);
                    external = true;
                }
                if ((pharPath = PharPath.getPharPath((IPath)new Path(path))) != null && (external && apfp.equals((Object)new Path(pharPath.getPharName())) || !external && apfp.lastSegment().equals(new Path(pharPath.getPharName()).lastSegment()))) {
                    if (pharPath.isPhar()) {
                        pharPath.setFolder(new Path(".phar/stub.php").removeLastSegments(1).toString());
                        pharPath.setFile(new Path(".phar/stub.php").lastSegment());
                    }
                    IScriptFolder scriptFolder = apf.getScriptFolder((IPath)new Path(pharPath.getFolder()));
                    try {
                        IModelElement[] children = scriptFolder.getChildren();
                        if (children != null && children.length > 0) {
                            int i = 0;
                            while (i < children.length) {
                                if (((ISourceModule)children[i]).getElementName().equals(pharPath.getFile())) {
                                    return new IncludedPharFileResult(scriptFolder, (ISourceModule)children[i]);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (ModelException e) {
                        PHPCorePlugin.log(e);
                        return null;
                    }
                }
            }
            if ((file = new File(entryDir = entryPath.toFile(), path)).exists()) {
                return new IncludedFileResult(entry, file);
            }
        } else if (entry.getEntryKind() == 4) {
            File entryDir = (entryPath = DLTKCore.getResolvedVariablePath((IPath)entryPath)).toFile();
            File file = new File(entryDir, path);
            if (file.exists()) {
                return new IncludedFileResult(entry, file);
            }
        } else if (entry.getEntryKind() == 2) {
            IResource resource;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = workspaceRoot.getProject(entryPath.segment(0));
            if (project.isAccessible() && (resource = project.findMember(path)) instanceof IFile) {
                return new ResourceResult((IFile)resource);
            }
        } else if (entry.getEntryKind() == 3) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = workspaceRoot.findMember(entryPath);
            if (resource instanceof IContainer && (resource = ((IContainer)resource).findMember(path)) instanceof IFile) {
                return new ResourceResult((IFile)resource);
            }
        } else if (entry.getEntryKind() == 5) {
            try {
                IBuildpathEntry[] buildpathEntries;
                IScriptProject scriptProject = DLTKCore.create((IProject)currentProject);
                IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)scriptProject);
                if (container != null && (buildpathEntries = container.getBuildpathEntries()) != null) {
                    IBuildpathEntry[] iBuildpathEntryArray = buildpathEntries;
                    int n = buildpathEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
                        Result<?, ?> result = PHPSearchEngine.searchInBuildpathEntry(path, buildpathEntry, currentProject);
                        if (result != null) {
                            IProjectFragment[] projectFragments = scriptProject.findProjectFragments(entry);
                            ((IncludedFileResult)result).setProjectFragments(projectFragments);
                            return result;
                        }
                        ++n2;
                    }
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
        }
        return null;
    }

    private static Result<?, ?> searchExternalOrWorkspaceFile(String directory, String relativeFile) {
        IContainer container;
        IResource file;
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(directory);
        if (resource instanceof IContainer && (file = (container = (IContainer)resource).findMember(relativeFile)) instanceof IFile) {
            return new ResourceResult((IFile)file);
        }
        File dir = new File(directory);
        if (dir.isDirectory()) {
            return PHPSearchEngine.searchExternalOrWorkspaceFile(new File(dir, relativeFile));
        }
        return null;
    }

    private static Result<?, ?> searchExternalOrWorkspaceFile(File file) {
        if (file.exists()) {
            IFile res = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
            if (res != null) {
                return new ResourceResult(res);
            }
            if (file.exists()) {
                return new ExternalFileResult(file);
            }
        }
        return null;
    }

    public static IncludePath[] buildIncludePath(IProject project) {
        LinkedHashSet<IncludePath> results = new LinkedHashSet<IncludePath>();
        PHPSearchEngine.buildIncludePath(project, results);
        return results.toArray(new IncludePath[results.size()]);
    }

    public static void buildIncludePath(IProject project, Set<IncludePath> results) {
        if (results.contains(project)) {
            return;
        }
        if (!project.isAccessible() || !project.isOpen()) {
            return;
        }
        results.addAll(Arrays.asList(PHPSearchEngine.getInstance().getProjectIncludePath(project)));
    }

    private IncludePath[] getProjectIncludePath(IProject project) {
        IncludePath[] includePaths = this.projectIncludePaths.get(project);
        if (includePaths == null) {
            includePaths = IncludePathManager.getInstance().getIncludePaths(project);
            this.projectIncludePaths.put(project, includePaths);
        }
        return includePaths;
    }

    @Override
    public void refresh(IProject project) {
        IncludePath[] includePaths = IncludePathManager.getInstance().getIncludePaths(project);
        this.projectIncludePaths.put(project, includePaths);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExternalFileResult
    extends Result<Object, File> {
        public ExternalFileResult(File file) {
            super(file.getParentFile(), file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncludedFileResult
    extends Result<IBuildpathEntry, File> {
        private IProjectFragment[] projectFragments;

        public IncludedFileResult(IBuildpathEntry container, File file) {
            super(container, file);
        }

        public void setProjectFragments(IProjectFragment[] projectFragments) {
            this.projectFragments = projectFragments;
        }

        public IProjectFragment[] getProjectFragments() {
            return this.projectFragments;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncludedPharFileResult
    extends Result<IScriptFolder, ISourceModule> {
        public IncludedPharFileResult(IScriptFolder container, ISourceModule file) {
            super(container, file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceResult
    extends Result<Object, IFile> {
        public ResourceResult(IFile file) {
            super(file.getParent(), file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Result<T, S> {
        private T container;
        private S file;

        public Result(T container, S file) {
            this.container = container;
            this.file = file;
        }

        public T getContainer() {
            return this.container;
        }

        public S getFile() {
            return this.file;
        }

        public void setContainer(T container) {
            this.container = container;
        }

        public void setFile(S file) {
            this.file = file;
        }
    }
}

