/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup;

import java.io.File;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;

public class PHPSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public String getSourceName(Object object) throws CoreException {
        if (object instanceof PHPStackFrame) {
            return ((PHPStackFrame)((Object)object)).getSourceName();
        }
        if (object instanceof DBGpStackFrame) {
            String src = ((DBGpStackFrame)((Object)object)).getSourceName();
            if (src == null) {
                src = ((DBGpStackFrame)((Object)object)).getQualifiedFile();
                Path p = new Path(src);
                src = p.lastSegment();
            }
            return src;
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] sourceElements = EMPTY;
        try {
            sourceElements = super.findSourceElements(object);
        }
        catch (Throwable throwable) {}
        if (sourceElements == EMPTY) {
            String fileName = null;
            if (object instanceof PHPStackFrame) {
                fileName = ((PHPStackFrame)((Object)object)).getSourceName();
            } else if (object instanceof DBGpStackFrame) {
                fileName = ((DBGpStackFrame)((Object)object)).getQualifiedFile();
            }
            if (fileName != null) {
                HandleFactory fac = new HandleFactory();
                IDLTKSearchScope scope = DLTKSearchScopeFactory.getInstance().createWorkspaceScope(true, PHPLanguageToolkit.getDefault());
                IPath localPath = EnvironmentPathUtils.getFile((IEnvironment)LocalEnvironment.getInstance(), (IPath)new Path(fileName)).getFullPath();
                Openable openable = fac.createOpenable(localPath.toString(), scope);
                if (openable instanceof IStorage) {
                    return new Object[]{openable};
                }
                File file = new File(fileName);
                if (file.exists()) {
                    return new Object[]{new LocalFile(file)};
                }
                return EMPTY;
            }
        }
        return sourceElements;
    }
}

