/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.internal.ui.views.launch.SourceNotFoundEditorInput;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPCompositeSourceContainer;
import org.eclipse.php.internal.debug.core.xdebug.IDELayer;
import org.eclipse.php.internal.debug.core.xdebug.breakpoints.PdtBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;

public class PdtLayer
implements IDELayer,
DBGpBreakpointFacade {
    public Preferences getPrefs() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        return prefs;
    }

    public String getBreakpointModelID() {
        return "org.eclipse.php.debug.core";
    }

    public Object sourceNotFound(Object debugElement) {
        SourceNotFoundEditorInput obj = null;
        if (debugElement instanceof IStackFrame) {
            obj = new SourceNotFoundEditorInput((IStackFrame)debugElement);
        }
        return obj;
    }

    public ISourceContainer getSourceContainer(IProject resource, ILaunchConfiguration launchConfig) {
        return new PHPCompositeSourceContainer(resource, launchConfig);
    }

    public DBGpBreakpoint createDBGpBreakpoint(IBreakpoint breakpoint) {
        return new PdtBreakpoint((PHPLineBreakpoint)breakpoint);
    }

    public IBreakpoint findBreakpointHit(String filename, int lineno) {
        IBreakpoint bpFound = null;
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getBreakpointModelID());
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof PHPLineBreakpoint) {
                PHPLineBreakpoint lineBreakpoint = (PHPLineBreakpoint)breakpoint;
                Breakpoint zBP = lineBreakpoint.getRuntimeBreakpoint();
                String bFileName = zBP.getFileName();
                int bLineNumber = zBP.getLineNumber();
                if (bLineNumber == lineno && bFileName.equals(filename)) {
                    bpFound = breakpoint;
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("breakpoint at " + filename + "(" + lineno + ") found");
                    }
                }
                if (breakpoint instanceof PHPRunToLineBreakpoint) {
                    IBreakpointManager bmgr = DebugPlugin.getDefault().getBreakpointManager();
                    try {
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("removing runtoline breakpoint");
                        }
                        bmgr.removeBreakpoint(breakpoint, true);
                    }
                    catch (CoreException e) {
                        DBGpLogger.logException("Exception trying to remove a runtoline breakpoint", this, e);
                    }
                }
            }
            ++i;
        }
        return bpFound;
    }

    public boolean supportsBreakpoint(IBreakpoint bp) {
        return bp.getModelIdentifier().equals(this.getBreakpointModelID());
    }

    public IBreakpoint createRunToLineBreakpoint(IFile fileName, int lineNumber) throws DebugException {
        return new PHPRunToLineBreakpoint(fileName, lineNumber);
    }

    public String getSystemDebugProperty() {
        return "org.eclipse.php.debug.ui.activeDebugging";
    }
}

