/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCreation
extends Expression {
    private final ASTNode.NodeList<ArrayElement> elements = new ASTNode.NodeList(ELEMENTS_PROPERTY);
    public static final ChildListPropertyDescriptor ELEMENTS_PROPERTY = new ChildListPropertyDescriptor(ArrayCreation.class, "elements", ArrayElement.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(2);
        properyList.add(ELEMENTS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public ArrayCreation(AST ast) {
        super(ast);
    }

    private ArrayCreation(int start, int end, AST ast, ArrayElement[] elements) {
        super(start, end, ast);
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        ArrayElement[] arrayElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayElement arrayElement = arrayElementArray[n2];
            this.elements.add(arrayElement);
            ++n2;
        }
    }

    public ArrayCreation(int start, int end, AST ast, List elements) {
        this(start, end, ast, elements == null ? null : elements.toArray(new ArrayElement[elements.size()]));
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.elements) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.elements) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.elements) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ArrayCreation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        for (ASTNode aSTNode : this.elements) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</ArrayCreation>");
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getType() {
        return 1;
    }

    public ArrayElement[] getElements() {
        return this.elements.toArray((ArrayElement[])new ArrayElement[this.elements.size()]);
    }

    public List<ArrayElement> elements() {
        return this.elements;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List elements = ASTNode.copySubtrees(target, this.elements());
        ArrayCreation result = new ArrayCreation(this.getStart(), this.getEnd(), target, elements);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ELEMENTS_PROPERTY) {
            return this.elements();
        }
        return super.internalGetChildListProperty(property);
    }
}

