/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EchoStatement
extends Statement {
    private ASTNode.NodeList<Expression> expressions = new ASTNode.NodeList(EXPRESSIONS_PROPERTY);
    public static final ChildListPropertyDescriptor EXPRESSIONS_PROPERTY = new ChildListPropertyDescriptor(EchoStatement.class, "expressions", Expression.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(2);
        properyList.add(EXPRESSIONS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    private EchoStatement(int start, int end, AST ast, Expression[] expressions) {
        super(start, end, ast);
        if (expressions == null) {
            throw new IllegalArgumentException();
        }
        Expression[] expressionArray = expressions;
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            this.expressions.add(expression);
            ++n2;
        }
    }

    public EchoStatement(int start, int end, AST ast, List expressions) {
        this(start, end, ast, expressions.toArray(new Expression[expressions.size()]));
    }

    public EchoStatement(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<EchoStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</EchoStatement>");
    }

    @Override
    public int getType() {
        return 21;
    }

    public Expression[] getExpressions() {
        return this.expressions.toArray((Expression[])new Expression[this.expressions.size()]);
    }

    public List<Expression> expressions() {
        return this.expressions;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == EXPRESSIONS_PROPERTY) {
            return this.expressions();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List expressions = ASTNode.copySubtrees(target, this.expressions());
        EchoStatement echoSt = new EchoStatement(this.getStart(), this.getEnd(), target, expressions);
        return echoSt;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

