/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionInvocation
extends VariableBase {
    private FunctionName functionName;
    private final ASTNode.NodeList<Expression> parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    public static final ChildPropertyDescriptor FUNCTION_PROPERTY = new ChildPropertyDescriptor(FunctionInvocation.class, "functionName", FunctionName.class, true, false);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(FunctionInvocation.class, "parameters", Expression.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(FUNCTION_PROPERTY);
        propertyList.add(PARAMETERS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    private FunctionInvocation(int start, int end, AST ast, FunctionName functionName, Expression[] parameters) {
        super(start, end, ast);
        if (functionName == null || parameters == null) {
            throw new IllegalArgumentException();
        }
        this.setFunctionName(functionName);
        Expression[] expressionArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            this.parameters.add(expression);
            ++n2;
        }
    }

    public FunctionInvocation(AST ast) {
        super(ast);
    }

    public FunctionInvocation(int start, int end, AST ast, FunctionName functionName, List parameters) {
        this(start, end, ast, functionName, parameters == null ? null : parameters.toArray(new Expression[parameters.size()]));
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.functionName.accept(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.functionName.traverseTopDown(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.functionName.traverseBottomUp(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FunctionInvocation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.functionName.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("<Parameters>\n");
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Parameters>\n");
        buffer.append(tab).append("</FunctionInvocation>");
    }

    @Override
    public int getType() {
        return 30;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(FunctionName functionname) {
        if (functionname == null) {
            throw new IllegalArgumentException();
        }
        FunctionName oldChild = this.functionName;
        this.preReplaceChild(oldChild, functionname, FUNCTION_PROPERTY);
        this.functionName = functionname;
        this.postReplaceChild(oldChild, functionname, FUNCTION_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == FUNCTION_PROPERTY) {
            if (get) {
                return this.getFunctionName();
            }
            this.setFunctionName((FunctionName)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        return super.internalGetChildListProperty(property);
    }

    public Expression[] getParameters() {
        return this.parameters.toArray((Expression[])new Expression[this.parameters.size()]);
    }

    public List<Expression> parameters() {
        return this.parameters;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        FunctionName function = ASTNode.copySubtree(target, this.getFunctionName());
        List params = ASTNode.copySubtrees(target, this.parameters());
        FunctionInvocation result = new FunctionInvocation(this.getStart(), this.getEnd(), target, function, params);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IFunctionBinding resolveFunctionBinding() {
        return this.ast.getBindingResolver().resolveFunction(this);
    }
}

