/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class Scalar
extends StringLiteral {
    public static final int TYPE_INT = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int TYPE_SYSTEM = 4;
    private final int scalarType;

    public Scalar(int start, int end, String value, int type) {
        super(start, end, value);
        this.scalarType = type;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        visitor.visit((Expression)this);
        visitor.endvisit((Expression)this);
    }

    public String getType() {
        switch (this.getScalarType()) {
            case 0: {
                return "int";
            }
            case 1: {
                return "real";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "unknown";
            }
            case 4: {
                return "system";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getKind() {
        return 51;
    }

    public int getScalarType() {
        return this.scalarType;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

