/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.corext;

import org.eclipse.core.runtime.Assert;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewriteFlattener;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;

public class ASTNodes {
    public static final int NODE_ONLY = 0;
    public static final int INCLUDE_FIRST_PARENT = 1;
    public static final int INCLUDE_ALL_PARENTS = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int PROBLEMS = 3;
    private static final int CLEAR_VISIBILITY = -113;

    private ASTNodes() {
    }

    public static String asString(ASTNode node) {
        ASTRewriteFlattener flattener = new ASTRewriteFlattener(null);
        node.accept(flattener);
        return flattener.getResult();
    }

    public static String getQualifier(Identifier name) {
        return "";
    }

    public static boolean isControlStatementBody(StructuralPropertyDescriptor locationInParent) {
        return locationInParent == IfStatement.TRUE_STATEMENT_PROPERTY || locationInParent == IfStatement.FALSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY;
    }

    public static boolean needsParentheses(Expression expression) {
        int type = expression.getType();
        return type == 37 || type == 17 || type == 45 || type == 44 || type == 8 || type == 39;
    }

    public static ASTNode getParent(ASTNode node, Class parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    public static ASTNode getParent(ASTNode node, int nodeType) {
        while ((node = node.getParent()) != null && node.getType() != nodeType) {
        }
        return node;
    }

    public static ASTNode findParent(ASTNode node, StructuralPropertyDescriptor[][] pathes) {
        int p = 0;
        while (p < pathes.length) {
            StructuralPropertyDescriptor[] path = pathes[p];
            ASTNode current = node;
            int d = path.length - 1;
            while (d >= 0 && current != null) {
                StructuralPropertyDescriptor descriptor = path[d];
                if (!descriptor.equals(current.getLocationInParent())) break;
                current = current.getParent();
                --d;
            }
            if (d < 0) {
                return current;
            }
            ++p;
        }
        return null;
    }

    public static boolean isParent(ASTNode node, ASTNode parent) {
        Assert.isNotNull((Object)parent);
        do {
            if ((node = node.getParent()) != parent) continue;
            return true;
        } while (node != null);
        return false;
    }

    public static int getExclusiveEnd(ASTNode node) {
        return node.getStart() + node.getLength();
    }

    public static int getInclusiveEnd(ASTNode node) {
        return node.getStart() + node.getLength() - 1;
    }

    private static int computeIterations(int flags) {
        switch (flags) {
            case 0: {
                return 1;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public static int changeVisibility(int modifiers, int visibility) {
        return modifiers & 0xFFFFFF8F | visibility;
    }

    public static void setFlagsToAST(ASTNode root, final int flags) {
        if (root == null) {
            return;
        }
        root.accept(new ApplyAll(){

            protected boolean apply(ASTNode node) {
                node.setFlags(node.getFlags() | flags);
                return true;
            }
        });
    }
}

