/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class CommentIndentationStrategy
extends DefaultIndentationStrategy {
    public void placeMatchingBlanks(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        IPhpScriptRegion scriptRegion;
        if (lineNumber == 0) {
            return;
        }
        IRegion previousLine = document.getLineInformation(lineNumber - 1);
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(previousLine.getOffset());
        if (sdRegion == null) {
            return;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(previousLine.getOffset());
        if (tRegion == null) {
            return;
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(previousLine.getOffset());
            regionStart += tRegion.getStart();
        }
        if (tRegion instanceof IPhpScriptRegion && (tRegion = (scriptRegion = (IPhpScriptRegion)tRegion).getPhpToken(previousLine.getOffset() - regionStart)).getStart() + regionStart < previousLine.getOffset()) {
            tRegion = scriptRegion.getPhpToken(tRegion.getEnd());
        }
        if (tRegion.getType() == "PHP_COMMENT_START" || tRegion.getType() == "PHPDOC_COMMENT_START") {
            String blanks = FormatterUtils.getLineBlanks(document, previousLine);
            result.append(blanks);
            result.append(" ");
        } else {
            super.placeMatchingBlanks(document, result, lineNumber, forOffset);
        }
    }
}

