/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.phar.AbstractFileExporter;
import org.eclipse.php.internal.core.phar.IStub;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.PharUtil;

public class ZipFileExporter
extends AbstractFileExporter {
    private ZipOutputStream outputStream;

    public ZipFileExporter(PharPackage pharPackage) throws IOException {
        super(pharPackage);
        this.outputStream = new ZipOutputStream(this.fileContentStream);
    }

    public void finished() throws IOException {
        this.outputStream.close();
    }

    private void write(ZipEntry entry, InputStream contentStream) throws IOException {
        byte[] readBuffer = new byte[4096];
        this.outputStream.putNextEntry(entry);
        try {
            int n;
            while ((n = contentStream.read(readBuffer)) > 0) {
                this.outputStream.write(readBuffer, 0, n);
            }
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
        this.outputStream.closeEntry();
    }

    private void completeEntry(ZipEntry entry, InputStream contentStream) throws IOException {
        byte[] readBuffer = new byte[4096];
        if (this.pharPackage.getCompressType() == 0) {
            entry.setMethod(0);
            int length = 0;
            CRC32 checksumCalculator = new CRC32();
            try {
                int n;
                while ((n = contentStream.read(readBuffer)) > 0) {
                    checksumCalculator.update(readBuffer, 0, n);
                    length += n;
                }
            }
            finally {
                if (contentStream != null) {
                    contentStream.close();
                }
            }
            entry.setSize(length);
            entry.setCrc(checksumCalculator.getValue());
        }
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        ZipEntry newEntry = new ZipEntry(destinationPath);
        this.completeEntry(newEntry, resource.getContents(false));
        this.write(newEntry, resource.getContents(false));
    }

    public void writeStub(IStub stub) throws IOException, CoreException {
        ZipEntry newEntry = new ZipEntry(".phar/stub.php");
        this.completeEntry(newEntry, PharUtil.getStubInputStream(stub));
        this.write(newEntry, PharUtil.getStubInputStream(stub));
    }

    public void write(IFolder resource, String destinationPath) throws IOException, CoreException {
        ZipEntry newEntry = new ZipEntry(destinationPath);
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.closeEntry();
    }

    public void doWriteSignature() throws IOException {
        byte[] signature = this.fileContentStream.getSignature();
        if (signature != null) {
            signature = PharUtil.getWholeSignature(signature, this.pharPackage);
            ZipEntry newEntry = new ZipEntry(".phar/signature.php");
            this.completeEntry(newEntry, PharUtil.getInputStream(signature));
            this.write(newEntry, PharUtil.getInputStream(signature));
        }
    }
}

