/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class TaskTagsProvider {
    private static TaskTagsProvider instance;
    private HashMap projectToTaskTagListener;
    private HashMap projectToPropagatorListeners;
    private boolean isInstalled;
    private PreferencesSupport preferencesSupport;
    private PreferencesPropagator preferencesPropagator;
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";
    private static final Preferences store;

    static {
        store = PHPCorePlugin.getDefault().getPluginPreferences();
    }

    private TaskTagsProvider() {
        this.install();
    }

    public static TaskTagsProvider getInstance() {
        if (instance == null) {
            instance = new TaskTagsProvider();
        }
        return instance;
    }

    public TaskTag[] getWorkspaceTaskTags() {
        String priorities = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
        String tags = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
        TaskTag[] workspaceTags = this.getTagsAndPropertiesFrom(tags, priorities);
        return workspaceTags;
    }

    public boolean isWorkspaceTagsCaseSensitive() {
        String caseSensitive = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskCaseSensitive");
        return "enabled".equals(caseSensitive);
    }

    public TaskTag[] getProjectTaskTags(IProject project) {
        String priorities = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", null, project);
        String projectTags = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, project);
        if (projectTags == null || priorities == null) {
            return null;
        }
        TaskTag[] tags = this.getTagsAndPropertiesFrom(projectTags, priorities);
        return tags;
    }

    public boolean getProjectTagsCaseSensitive(IProject project) {
        String caseSensitive = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskCaseSensitive", null, project);
        if (caseSensitive == null) {
            return this.isWorkspaceTagsCaseSensitive();
        }
        return "enabled".equals(caseSensitive);
    }

    public void addTaskTagsListener(ITaskTagsListener listener, IProject project) {
        this.projectToTaskTagListener.put(project, listener);
        this.installPropagatorListeners(project);
    }

    public void removeTaskTagsListener(ITaskTagsListener listener, IProject project) {
        this.projectToTaskTagListener.remove(project);
        this.uninstallPropagatorListeners(project);
    }

    private void installPropagatorListeners(IProject project) {
        IPreferencesPropagatorListener[] listeners = new IPreferencesPropagatorListener[]{new InnerTaskTagsListener(project), new InnerTaskPrioritiesListener(project), new InnerTaskCaseListener(project)};
        this.preferencesPropagator.addPropagatorListener(listeners[0], "org.eclipse.php.core.taskTags");
        this.preferencesPropagator.addPropagatorListener(listeners[1], "org.eclipse.php.core.taskPriorities");
        this.preferencesPropagator.addPropagatorListener(listeners[2], "org.eclipse.php.core.taskCaseSensitive");
        this.projectToPropagatorListeners.put(project, listeners);
    }

    private void uninstallPropagatorListeners(IProject project) {
        IPreferencesPropagatorListener[] listeners = (IPreferencesPropagatorListener[])this.projectToPropagatorListeners.get(project);
        if (listeners != null) {
            this.preferencesPropagator.removePropagatorListener(listeners[0], "org.eclipse.php.core.taskTags");
            this.preferencesPropagator.removePropagatorListener(listeners[1], "org.eclipse.php.core.taskPriorities");
            this.preferencesPropagator.removePropagatorListener(listeners[2], "org.eclipse.php.core.taskCaseSensitive");
        }
        this.projectToPropagatorListeners.remove(project);
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.preferencesSupport = new PreferencesSupport(NODES_QUALIFIER, PHPCorePlugin.getDefault().getPluginPreferences());
        this.projectToTaskTagListener = new HashMap();
        this.projectToPropagatorListeners = new HashMap();
        this.preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator(NODES_QUALIFIER, store);
        this.isInstalled = true;
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        Set keys = this.projectToPropagatorListeners.keySet();
        IProject[] projects = new IProject[keys.size()];
        keys.toArray(projects);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject element = iProjectArray[n2];
            this.uninstallPropagatorListeners(element);
            ++n2;
        }
        this.preferencesSupport = null;
        this.preferencesPropagator = null;
        this.projectToTaskTagListener = null;
        this.projectToPropagatorListeners = null;
        this.isInstalled = false;
    }

    private void notifyTaskTagChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskTagsChanged(event);
            ++n2;
        }
    }

    private void notifyTaskPriorityChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskPrioritiesChanged(event);
            ++n2;
        }
    }

    private void notifyTaskCaseChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskCaseChanged(event);
            ++n2;
        }
    }

    private TaskTag[] getTagsAndPropertiesFrom(String tagString, String priorityString) {
        String[] tags = StringUtils.unpack((String)tagString);
        String[] priorities = StringUtils.unpack((String)priorityString);
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] stringArray = priorities;
        int n = priorities.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Integer number = null;
            number = "HIGH".equals(element) ? new Integer(2) : ("LOW".equals(element) ? new Integer(0) : new Integer(1));
            list.add(number);
            ++n2;
        }
        Integer[] allPriorities = new Integer[list.size()];
        list.toArray(allPriorities);
        TaskTag[] taskTags = new TaskTag[Math.min(tags.length, priorities.length)];
        int i = 0;
        while (i < taskTags.length) {
            taskTags[i] = new TaskTag(tags[i], allPriorities[i].intValue());
            ++i;
        }
        return taskTags;
    }

    private abstract class AbstractTasksListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public AbstractTasksListener(IProject project) {
            this.project = project;
        }

        public IProject getProject() {
            return this.project;
        }
    }

    private class InnerTaskCaseListener
    extends AbstractTasksListener {
        public InnerTaskCaseListener(IProject project) {
            super(project);
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String tags = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, this.getProject());
            String priorities = null;
            if (tags == null) {
                tags = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
                priorities = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
            } else {
                priorities = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", "", this.getProject());
            }
            if (StringUtils.occurrencesOf((String)priorities, (char)',') == StringUtils.occurrencesOf((String)tags, (char)',')) {
                TaskTag[] taskTags = TaskTagsProvider.this.getTagsAndPropertiesFrom(tags, priorities);
                TaskTagsEvent taskEvent = null;
                String newValue = (String)event.getNewValue();
                if (newValue == null) {
                    newValue = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskCaseSensitive");
                }
                taskEvent = "enabled".equals(newValue) ? new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, true) : new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, false);
                TaskTagsProvider.this.notifyTaskCaseChange(taskEvent);
            }
        }
    }

    private class InnerTaskPrioritiesListener
    extends AbstractTasksListener {
        public InnerTaskPrioritiesListener(IProject project) {
            super(project);
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String tags;
            String newValue = (String)event.getNewValue();
            if (newValue == null) {
                newValue = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
            }
            if ((tags = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, this.getProject())) == null) {
                tags = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
            }
            if (StringUtils.occurrencesOf((String)tags, (char)',') == StringUtils.occurrencesOf((String)newValue, (char)',')) {
                TaskTag[] taskTags = TaskTagsProvider.this.getTagsAndPropertiesFrom(tags, newValue);
                TaskTagsEvent taskEvent = new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, TaskTagsProvider.this.getProjectTagsCaseSensitive(this.getProject()));
                TaskTagsProvider.this.notifyTaskPriorityChange(taskEvent);
            }
        }
    }

    private class InnerTaskTagsListener
    extends AbstractTasksListener {
        public InnerTaskTagsListener(IProject project) {
            super(project);
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String priorities;
            String newValue = (String)event.getNewValue();
            if (newValue == null) {
                newValue = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
            }
            if ((priorities = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", null, this.getProject())) == null) {
                priorities = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
            }
            if (StringUtils.occurrencesOf((String)priorities, (char)',') == StringUtils.occurrencesOf((String)newValue, (char)',')) {
                TaskTag[] taskTags = TaskTagsProvider.this.getTagsAndPropertiesFrom(newValue, priorities);
                IProject eventProject = event.getSource() != null && event.getSource() instanceof IProject ? (IProject)event.getSource() : null;
                TaskTagsEvent taskEvent = new TaskTagsEvent(TaskTagsProvider.this, eventProject, taskTags, TaskTagsProvider.this.getProjectTagsCaseSensitive(this.getProject()));
                TaskTagsProvider.this.notifyTaskTagChange(taskEvent);
            }
        }
    }
}

