/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;

class DeclarationSearcher
extends ASTVisitor {
    private int bestScore = Integer.MAX_VALUE;
    private int modelStart;
    private int modelEnd;
    private int modelCutoffStart;
    private int modelCutoffEnd;
    private String elementName;
    private Declaration result;
    private DeclarationType declarationType;

    public DeclarationSearcher(ModuleDeclaration moduleDeclaration, IMember modelElement, DeclarationType declarationType) throws ModelException {
        ISourceRange sourceRange = modelElement.getSourceRange();
        this.modelStart = sourceRange.getOffset();
        this.modelEnd = this.modelStart + sourceRange.getLength();
        this.modelCutoffStart = this.modelStart - 100;
        this.modelCutoffEnd = this.modelEnd + 100;
        this.elementName = modelElement.getElementName();
        this.declarationType = declarationType;
    }

    public Declaration getResult() {
        return this.result;
    }

    protected void checkElementDeclaration(Declaration s) {
        int astEnd;
        int diff2;
        int astStart;
        int diff1;
        int score;
        if (s.getName().equals(this.elementName) && (score = (diff1 = this.modelStart - (astStart = s.sourceStart())) * diff1 + (diff2 = this.modelEnd - (astEnd = s.sourceEnd())) * diff2) < this.bestScore) {
            this.bestScore = score;
            this.result = s;
        }
    }

    protected boolean interesting(ASTNode s) {
        if (s.sourceStart() < 0 || s.sourceEnd() < s.sourceStart()) {
            return true;
        }
        return this.modelCutoffEnd >= s.sourceStart() && this.modelCutoffStart < s.sourceEnd();
    }

    public boolean visit(Expression s) throws Exception {
        return this.interesting((ASTNode)s);
    }

    public boolean visit(Statement s) throws Exception {
        if (!this.interesting((ASTNode)s)) {
            return false;
        }
        if (this.declarationType == DeclarationType.FIELD && s instanceof Declaration) {
            this.checkElementDeclaration((Declaration)s);
        }
        return true;
    }

    public boolean visit(MethodDeclaration s) throws Exception {
        if (!this.interesting((ASTNode)s)) {
            return false;
        }
        if (this.declarationType == DeclarationType.METHOD) {
            this.checkElementDeclaration((Declaration)s);
        }
        return true;
    }

    public boolean visit(ModuleDeclaration s) throws Exception {
        return this.interesting((ASTNode)s);
    }

    public boolean visit(TypeDeclaration s) throws Exception {
        if (!this.interesting((ASTNode)s)) {
            return false;
        }
        if (this.declarationType == DeclarationType.CLASS) {
            this.checkElementDeclaration((Declaration)s);
        }
        return true;
    }

    public boolean visitGeneral(ASTNode s) throws Exception {
        return this.interesting(s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DeclarationType {
        METHOD,
        CLASS,
        FIELD;

    }
}

