/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.util.Util;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.IPhpScriptReconcilingListener;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class PhpReconcilingStrategy
implements IValidator,
ISourceValidator {
    private IEditorPart fEditor;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private IPhpScriptReconcilingListener fJavaReconcilingListener;
    private boolean fIsScriptReconcilingListener;
    private boolean fNotify = true;
    private IDocument document;

    public void connect(IDocument document) {
        this.document = document;
    }

    public void install(IValidationContext helper) {
        IEditorInput fEditorInput = this.findEditor(helper);
        this.fDocumentProvider = DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider();
        this.fEditor = this.getEditor(fEditorInput);
        this.fIsScriptReconcilingListener = this.fEditor instanceof IPhpScriptReconcilingListener;
        if (this.fIsScriptReconcilingListener) {
            this.fJavaReconcilingListener = (IPhpScriptReconcilingListener)this.fEditor;
        }
    }

    private IEditorPart getEditor(final IEditorInput editorInput) {
        final IEditorPart[] editor = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = DLTKUIPlugin.getActivePage();
                if (activePage != null) {
                    editor[0] = editorInput != null ? activePage.findEditor(editorInput) : activePage.getActiveEditor();
                }
            }
        });
        return editor[0];
    }

    private IEditorInput findEditor(IValidationContext helper) {
        String[] delta = helper.getURIs();
        if (delta.length > 0) {
            IFile file = this.getFile(delta[0]);
            FileEditorInput fileEditorInput = new FileEditorInput(file);
            return fileEditorInput;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program reconcile(ISourceModule unit, boolean initialReconcile) throws ModelException {
        IProblemRequestorExtension extension = this.getProblemRequestorExtension();
        if (extension != null) {
            extension.setProgressMonitor(this.fProgressMonitor);
            extension.setIsActive(true);
        }
        try {
            boolean isASTNeeded = initialReconcile || PHPUiPlugin.getDefault().getASTProvider().isActive(unit);
            ISourceModule iSourceModule = unit;
            synchronized (iSourceModule) {
                unit.reconcile(true, null, this.fProgressMonitor);
            }
            if (isASTNeeded) {
                PHPVersion phpVersion = ProjectOptions.getPhpVersion((IProject)unit.getScriptProject().getProject());
                ASTParser newParser = ASTParser.newParser((PHPVersion)phpVersion, (ISourceModule)unit);
                Program createdAST = newParser.createAST(null);
                if (createdAST != null && this.document != null) {
                    createdAST.setSourceModule(unit);
                    createdAST.setSourceRange(0, this.document.getLength());
                    createdAST.setLineEndTable(Util.lineEndTable((IDocument)this.document));
                }
                Program program = createdAST;
                return program;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            Assert.isTrue((this.fProgressMonitor == null || this.fProgressMonitor.isCanceled() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e, 4);
        }
        finally {
            if (extension != null) {
                extension.setProgressMonitor(null);
                extension.setIsActive(false);
            }
        }
        return null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validate(null, helper, reporter);
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (this.fEditor == null) {
            this.install(helper);
            if (this.fEditor == null) {
                return;
            }
        }
        if (!(this.fEditor instanceof PHPStructuredEditor)) {
            return;
        }
        final IModelElement modelElement = ((PHPStructuredEditor)this.fEditor).getModelElement();
        if (modelElement instanceof ISourceModule) {
            final Program[] ast = new Program[1];
            try {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws ModelException {
                        ast[0] = PhpReconcilingStrategy.this.reconcile((ISourceModule)modelElement, true);
                    }

                    public void handleException(Throwable ex) {
                        Status status = new Status(4, "org.eclipse.php.ui", 0, "Error in php Core during reconcile", ex);
                        PHPCorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                });
            }
            catch (Throwable throwable) {
                try {
                    if (this.fIsScriptReconcilingListener) {
                        IProgressMonitor pm = this.fProgressMonitor;
                        if (pm == null) {
                            pm = new NullProgressMonitor();
                        }
                        this.fJavaReconcilingListener.reconciled(ast[0], !this.fNotify, pm);
                    }
                }
                finally {
                    this.fNotify = true;
                }
                throw throwable;
            }
            try {
                if (this.fIsScriptReconcilingListener) {
                    IProgressMonitor pm = this.fProgressMonitor;
                    if (pm == null) {
                        pm = new NullProgressMonitor();
                    }
                    this.fJavaReconcilingListener.reconciled(ast[0], !this.fNotify, pm);
                }
            }
            finally {
                this.fNotify = true;
            }
        }
    }

    public IFile getFile(String delta) {
        IFile res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(delta));
        return res instanceof IFile ? res : null;
    }

    protected IDOMModel getModelForResource(IFile file) {
        IStructuredModel model = null;
        IModelManager manager = StructuredModelManager.getModelManager();
        try {
            model = manager.getModelForRead(file);
        }
        catch (Exception exception) {}
        return model instanceof IDOMModel ? (IDOMModel)model : null;
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    public void aboutToBeReconciled() {
        if (this.fIsScriptReconcilingListener) {
            this.fJavaReconcilingListener.aboutToBeReconciled();
        }
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }

    public void cleanup(IReporter reporter) {
    }

    public void disconnect(IDocument document) {
        this.document = null;
    }
}

