/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.refactor.participants;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.ui.refactor.participants.IncludepathRenameParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludepathRenameIParentParticipant
extends IncludepathRenameParticipant {
    @Override
    protected boolean accepts(IModelElement element) {
        return element instanceof IParent;
    }

    @Override
    protected void gatherChanges(IResource resource, List changes, String destProjectName) throws CoreException, OperationCanceledException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                ArrayList<IncludePath> newIncludePathEntryList = new ArrayList<IncludePath>();
                HashSet<IBuildpathEntry> newBuildPathEntryList = new HashSet<IBuildpathEntry>();
                this.getNewIncludePaths(projects[i], newIncludePathEntryList, newBuildPathEntryList, resource, destProjectName);
                IProject newProject = projects[i];
                if (projects[i].equals((Object)resource)) {
                    newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(destProjectName);
                }
                changes.add(new IncludepathChange(projects[i], newProject, newIncludePathEntryList.toArray(new IncludePath[newIncludePathEntryList.size()]), newBuildPathEntryList.toArray(new IBuildpathEntry[newBuildPathEntryList.size()])));
            }
            ++i;
        }
    }

    protected void getNewIncludePaths(IProject project, List<IncludePath> newIncludePathEntryList, Set<IBuildpathEntry> newBuildPathEntryList, IResource resource, String destProjectName) {
        IncludePath[] includePathEntries;
        block4: {
            includePathEntries = IncludePathManager.getInstance().getIncludePaths(project);
            try {
                IBuildpathEntry[] oldBuildpathEntries = DLTKCore.create((IProject)project).getRawBuildpath();
                int i = 0;
                while (i < oldBuildpathEntries.length) {
                    newBuildPathEntryList.add(oldBuildpathEntries[i]);
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < includePathEntries.length) {
            newIncludePathEntryList.add(this.getNewIncludePath(includePathEntries[i], resource, destProjectName, newBuildPathEntryList));
            ++i;
        }
    }

    protected IncludePath getNewIncludePath(IncludePath includePath, IResource resource, String destProjectName, Set<IBuildpathEntry> newBuildPathEntryList) {
        if (this.acceptKind(includePath)) {
            IResource oldRes;
            IPath renamedPath = resource.getFullPath();
            if (includePath.isBuildpath()) {
                IBuildpathEntry entry = (IBuildpathEntry)includePath.getEntry();
                if (renamedPath.isPrefixOf(entry.getPath())) {
                    entry = this.replaceBuildpath(destProjectName, newBuildPathEntryList, renamedPath, entry);
                    includePath = new IncludePath((Object)entry, includePath.getProject());
                }
            } else if (includePath.getEntry() instanceof IResource && renamedPath.isPrefixOf((oldRes = (IResource)includePath.getEntry()).getFullPath())) {
                renamedPath = renamedPath.removeLastSegments(1).append(destProjectName).append(oldRes.getFullPath().removeFirstSegments(renamedPath.segmentCount()));
                IFile newRes = null;
                if (oldRes.getType() == 1) {
                    newRes = ResourcesPlugin.getWorkspace().getRoot().getFile(renamedPath);
                } else if (oldRes.getType() == 2) {
                    newRes = ResourcesPlugin.getWorkspace().getRoot().getFolder(renamedPath);
                } else if (oldRes.getType() == 4) {
                    newRes = ResourcesPlugin.getWorkspace().getRoot().getProject(renamedPath.toString());
                }
                includePath = new IncludePath((Object)newRes, includePath.getProject());
            }
        }
        return includePath;
    }

    protected IBuildpathEntry replaceBuildpath(String destProjectName, Set<IBuildpathEntry> newBuildPathEntryList, IPath renamedPath, IBuildpathEntry entry) {
        renamedPath = renamedPath.removeLastSegments(1).append(destProjectName).append(entry.getPath().removeFirstSegments(renamedPath.segmentCount()));
        newBuildPathEntryList.remove(entry);
        entry = new BuildpathEntry(entry.getContentKind(), entry.getEntryKind(), renamedPath, entry.isExported(), entry.getInclusionPatterns(), entry.getExclusionPatterns(), entry.getAccessRules(), entry.combineAccessRules(), entry.getExtraAttributes(), entry.isExternal());
        newBuildPathEntryList.add(entry);
        return entry;
    }

    protected boolean isPrefix(IPath fullPath, IncludePath includePath) {
        return false;
    }

    protected boolean acceptKind(IncludePath includePath) {
        return true;
    }

    static class IncludepathChange
    extends Change {
        IProject project;
        IProject newProject;
        IncludePath[] oldIncludePathEntries;
        IncludePath[] newIncludePathEntries;
        IBuildpathEntry[] oldBuildpathEntries;
        IBuildpathEntry[] newBuildpathEntries;

        public IncludepathChange(IProject project, IProject newProject, IncludePath[] newIncludePathEntries, IBuildpathEntry[] newBuildpathEntries) {
            block2: {
                this.project = project;
                this.newProject = newProject;
                this.oldIncludePathEntries = IncludePathManager.getInstance().getIncludePaths(project);
                this.newIncludePathEntries = newIncludePathEntries;
                try {
                    this.oldBuildpathEntries = DLTKCore.create((IProject)project).getRawBuildpath();
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
            this.newBuildpathEntries = newBuildpathEntries;
        }

        public IncludepathChange(IProject project, IProject newProject, IncludePath[] oldIncludePathEntries, IncludePath[] newIncludePathEntries, IBuildpathEntry[] oldBuildpathEntries, IBuildpathEntry[] newBuildpathEntries) {
            this.project = project;
            this.newProject = newProject;
            this.oldIncludePathEntries = oldIncludePathEntries;
            this.newIncludePathEntries = newIncludePathEntries;
            this.oldBuildpathEntries = oldBuildpathEntries;
            this.newBuildpathEntries = newBuildpathEntries;
        }

        public String getName() {
            return "Rename Includepath";
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            IncludePathManager.getInstance().setIncludePath(this.newProject, this.newIncludePathEntries);
            return new IncludepathChange(this.newProject, this.project, this.newIncludePathEntries, this.oldIncludePathEntries, this.newBuildpathEntries, this.oldBuildpathEntries);
        }

        public Object getModifiedElement() {
            return "Rename Includepath";
        }
    }
}

