/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.wizards.IPHPExeCompositeFragment;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeCompositeFragment;
import org.eclipse.php.internal.ui.wizards.CompositeWizardFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.IWizardHandle;
import org.eclipse.php.internal.ui.wizards.WizardControlWrapper;
import org.eclipse.php.internal.ui.wizards.WizardModel;
import org.eclipse.swt.widgets.Composite;

public class PHPExeWizardFragment
extends CompositeWizardFragment
implements IPHPExeCompositeFragment {
    private PHPExeCompositeFragment compositeFragment;
    private PHPexeItem phpExeItem;
    private PHPexeItem[] existingItems;

    public Composite getComposite() {
        return this.compositeFragment;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.compositeFragment = new PHPExeCompositeFragment(parent, (IControlHandler)new WizardControlWrapper(handle), false);
        return this.compositeFragment;
    }

    public void enter() {
        if (this.compositeFragment != null) {
            try {
                this.phpExeItem = (PHPexeItem)this.getWizardModel().getObject("phpExe");
                if (this.phpExeItem == null) {
                    this.phpExeItem = new PHPexeItem();
                }
                this.compositeFragment.setData(this.phpExeItem);
                this.compositeFragment.setExistingItems(this.existingItems);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        } else {
            Logger.log(4, "Could not display the PHPExeItems wizard (component is null).");
        }
    }

    public boolean isComplete() {
        if (this.compositeFragment == null) {
            return super.isComplete();
        }
        return super.isComplete() && this.compositeFragment.isComplete();
    }

    public void exit() {
        if (this.compositeFragment != null) {
            WizardModel model = this.getWizardModel();
            model.putObject("phpExe", (Object)this.compositeFragment.getPHPExeItem());
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        if (this.compositeFragment != null) {
            this.compositeFragment.performOk();
        }
    }

    public void performCancel(IProgressMonitor monitor) throws CoreException {
        super.performCancel(monitor);
        if (this.getWizardModel().getObject("phpExe") != null) {
            this.getWizardModel().putObject("phpExe", null);
            PHPexes.getInstance().save();
        }
    }

    public void setExistingItems(PHPexeItem[] existingItems) {
        this.existingItems = existingItems;
    }
}

