/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.evaluation.types.IClassType;
import org.eclipse.dltk.ti.types.ClassType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;

public class PHPClassType
extends ClassType
implements IClassType {
    private String namespace;
    private String typeName;

    public PHPClassType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        int i = typeName.lastIndexOf(92);
        if (i == -1) {
            this.typeName = typeName;
        } else if (i == 0) {
            this.typeName = typeName.substring(1, typeName.length());
        } else if (i > 0) {
            if (typeName.charAt(0) != '\\') {
                typeName = '\\' + typeName;
                ++i;
            }
            this.namespace = typeName.substring(0, i);
            this.typeName = typeName;
        }
    }

    public PHPClassType(String namespace, String typeName) {
        if (namespace == null || typeName == null) {
            throw new IllegalArgumentException();
        }
        if (namespace.length() > 0 && namespace.charAt(0) != '\\') {
            namespace = String.valueOf('\\') + namespace;
        }
        this.namespace = namespace;
        this.typeName = namespace + '\\' + typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public String getModelKey() {
        return this.typeName;
    }

    public static PHPClassType fromTypeName(String typeName, ISourceModule sourceModule, int offset) {
        String namespace = PHPModelUtils.extractNamespaceName(typeName, sourceModule, offset);
        if (namespace != null) {
            return new PHPClassType(namespace, PHPModelUtils.extractElementName(typeName));
        }
        return new PHPClassType(typeName);
    }

    public static PHPClassType fromIType(IType type) {
        String elementName = type.getElementName();
        IType namespace = type.getDeclaringType();
        if (namespace != null) {
            return new PHPClassType(namespace.getElementName(), elementName);
        }
        return new PHPClassType(elementName);
    }

    public static IEvaluatedType fromSimpleReference(SimpleReference name) {
        String typeName = name instanceof FullyQualifiedReference ? ((FullyQualifiedReference)name).getFullyQualifiedName() : name.getName();
        IEvaluatedType simpleType = PHPSimpleTypes.fromString(typeName);
        if (simpleType != null) {
            return simpleType;
        }
        return new PHPClassType(typeName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PHPClassType other = (PHPClassType)((Object)obj);
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
    }
}

