/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugMessagesRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugMessages";
    private static final String MESSAGE_TAG = "message";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String HANDLER_ATTRIBUTE = "handler";
    private static final String OVERRIDES_ATTRIBUTE = "overridesId";
    private IntHashtable messagesHash = new IntHashtable(50);
    private Dictionary<String, Integer> messagesTypes = new Hashtable<String, Integer>();
    private IntHashtable handlers = new IntHashtable();
    private static DebugMessagesRegistry instance = null;

    private DebugMessagesRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        HashMap<String, IConfigurationElement> configElementsMap = new HashMap<String, IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (MESSAGE_TAG.equals(element.getName())) {
                String overridesId;
                String messageId = element.getAttribute(ID_ATTRIBUTE);
                if (!configElementsMap.containsKey(messageId)) {
                    configElementsMap.put(messageId, element);
                }
                if ((overridesId = element.getAttribute(OVERRIDES_ATTRIBUTE)) != null) {
                    configElementsMap.put(overridesId, null);
                }
            }
            ++n2;
        }
        Collection configElements = configElementsMap.values();
        while (configElements.remove(null)) {
        }
        for (final IConfigurationElement element : configElements) {
            final IDebugMessage[] messages = new IDebugMessage[1];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.internal.debug.core.phpDebugMessages"){

                public void run() throws Exception {
                    messages[0] = (IDebugMessage)element.createExecutableExtension(DebugMessagesRegistry.CLASS_ATTRIBUTE);
                }
            });
            if (messages[0] == null || this.messagesHash.containsKey(messages[0].getType())) continue;
            this.messagesHash.put(messages[0].getType(), (Object)messages[0]);
            this.messagesTypes.put(element.getAttribute(ID_ATTRIBUTE), new Integer(messages[0].getType()));
            String handlerClass = element.getAttribute(HANDLER_ATTRIBUTE);
            if (handlerClass == null || this.handlers.containsKey(messages[0].getType())) continue;
            this.handlers.put(messages[0].getType(), (Object)new DebugMessageHandlerFactory(element));
        }
    }

    private IntHashtable getMessages() {
        return this.messagesHash;
    }

    private Dictionary<String, Integer> getMessagesTypes() {
        return this.messagesTypes;
    }

    private IntHashtable getHandlers() {
        return this.handlers;
    }

    private static DebugMessagesRegistry getInstance() {
        if (instance == null) {
            instance = new DebugMessagesRegistry();
        }
        return instance;
    }

    public static IDebugMessage getMessage(int type) throws Exception {
        IntHashtable messages = DebugMessagesRegistry.getInstance().getMessages();
        if (messages.containsKey(type)) {
            return (IDebugMessage)messages.get(type).getClass().newInstance();
        }
        throw new Exception("Can't find message for ID = " + type + " in Debug messages registry!");
    }

    public static IDebugMessage getMessage(String id) throws Exception {
        return (IDebugMessage)DebugMessagesRegistry.getInstance().getMessages().get(DebugMessagesRegistry.getInstance().getMessagesTypes().get(id).intValue()).getClass().newInstance();
    }

    public static IDebugMessageHandler getHandler(IDebugMessage message) {
        DebugMessageHandlerFactory debugMessageHandlerFactory = (DebugMessageHandlerFactory)DebugMessagesRegistry.getInstance().getHandlers().get(message.getType());
        if (debugMessageHandlerFactory != null) {
            return debugMessageHandlerFactory.createHandler();
        }
        return null;
    }

    class DebugMessageHandlerFactory {
        IConfigurationElement element;

        public DebugMessageHandlerFactory(IConfigurationElement element) {
            this.element = element;
        }

        public IDebugMessageHandler createHandler() {
            final IDebugMessageHandler[] handler = new IDebugMessageHandler[1];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable("Error creation handler for extension-point org.eclipse.php.internal.debug.core.phpDebugMessages"){

                public void run() throws Exception {
                    handler[0] = (IDebugMessageHandler)DebugMessageHandlerFactory.this.element.createExecutableExtension(DebugMessagesRegistry.HANDLER_ATTRIBUTE);
                }
            });
            return handler[0];
        }
    }
}

